/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateDataBinarySet;
import org.h2.expression.aggregate.AggregateType;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueDouble;
import org.h2.value.ValueNull;

final class AggregateDataCorr
extends AggregateDataBinarySet {
    private final AggregateType aggregateType;
    private long count;
    private double sumY;
    private double sumX;
    private double sumYX;
    private double m2y;
    private double meanY;
    private double m2x;
    private double meanX;

    AggregateDataCorr(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    void add(SessionLocal session, Value yValue, Value xValue) {
        double y = yValue.getDouble();
        double x = xValue.getDouble();
        this.sumY += y;
        this.sumX += x;
        this.sumYX += y * x;
        if (++this.count == 1L) {
            this.meanY = y;
            this.meanX = x;
            this.m2y = 0.0;
            this.m2x = 0.0;
        } else {
            double delta = y - this.meanY;
            this.meanY += delta / (double)this.count;
            this.m2y += delta * (y - this.meanY);
            delta = x - this.meanX;
            this.meanX += delta / (double)this.count;
            this.m2x += delta * (x - this.meanX);
        }
    }

    @Override
    Value getValue(SessionLocal session) {
        double v;
        if (this.count < 1L) {
            return ValueNull.INSTANCE;
        }
        switch (this.aggregateType) {
            case CORR: {
                if (this.m2y == 0.0 || this.m2x == 0.0) {
                    return ValueNull.INSTANCE;
                }
                v = (this.sumYX - this.sumX * this.sumY / (double)this.count) / Math.sqrt(this.m2y * this.m2x);
                break;
            }
            case REGR_SLOPE: {
                if (this.m2x == 0.0) {
                    return ValueNull.INSTANCE;
                }
                v = (this.sumYX - this.sumX * this.sumY / (double)this.count) / this.m2x;
                break;
            }
            case REGR_INTERCEPT: {
                if (this.m2x == 0.0) {
                    return ValueNull.INSTANCE;
                }
                v = this.meanY - (this.sumYX - this.sumX * this.sumY / (double)this.count) / this.m2x * this.meanX;
                break;
            }
            case REGR_R2: {
                if (this.m2x == 0.0) {
                    return ValueNull.INSTANCE;
                }
                if (this.m2y == 0.0) {
                    return ValueDouble.ONE;
                }
                v = this.sumYX - this.sumX * this.sumY / (double)this.count;
                v = v * v / (this.m2y * this.m2x);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return ValueDouble.get(v);
    }
}

