/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.command.query.Select;
import org.h2.command.query.SelectGroups;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFunctionType;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDouble;
import org.h2.value.ValueNull;

public class WindowFunction
extends DataAnalysisOperation {
    private final WindowFunctionType type;
    private final Expression[] args;
    private boolean fromLast;
    private boolean ignoreNulls;

    public static int getMinArgumentCount(WindowFunctionType type) {
        switch (type) {
            case NTILE: 
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case RATIO_TO_REPORT: {
                return 1;
            }
            case NTH_VALUE: {
                return 2;
            }
        }
        return 0;
    }

    public static int getMaxArgumentCount(WindowFunctionType type) {
        switch (type) {
            case NTILE: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case RATIO_TO_REPORT: {
                return 1;
            }
            case LEAD: 
            case LAG: {
                return 3;
            }
            case NTH_VALUE: {
                return 2;
            }
        }
        return 0;
    }

    private static Value getNthValue(Iterator<Value[]> iterator, int number, boolean ignoreNulls) {
        Value v = ValueNull.INSTANCE;
        int cnt = 0;
        while (iterator.hasNext()) {
            Value t = iterator.next()[0];
            if (ignoreNulls && t == ValueNull.INSTANCE || cnt++ != number) continue;
            v = t;
            break;
        }
        return v;
    }

    public WindowFunction(WindowFunctionType type, Select select, Expression[] args) {
        super(select);
        this.type = type;
        this.args = args;
    }

    public WindowFunctionType getFunctionType() {
        return this.type;
    }

    public void setFromLast(boolean fromLast) {
        this.fromLast = fromLast;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    protected void updateAggregate(SessionLocal session, SelectGroups groupData, int groupRowId) {
        this.updateOrderedAggregate(session, groupData, groupRowId, this.over.getOrderBy());
    }

    @Override
    protected void updateGroupAggregates(SessionLocal session, int stage) {
        super.updateGroupAggregates(session, stage);
        if (this.args != null) {
            for (Expression expr : this.args) {
                expr.updateAggregate(session, stage);
            }
        }
    }

    @Override
    protected int getNumExpressions() {
        return this.args != null ? this.args.length : 0;
    }

    @Override
    protected void rememberExpressions(SessionLocal session, Value[] array) {
        if (this.args != null) {
            int cnt = this.args.length;
            for (int i = 0; i < cnt; ++i) {
                array[i] = this.args[i].getValue(session);
            }
        }
    }

    @Override
    protected Object createAggregateData() {
        throw DbException.getUnsupportedException("Window function");
    }

    @Override
    protected void getOrderedResultLoop(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        switch (this.type) {
            case ROW_NUMBER: {
                int i = 0;
                int size = ordered.size();
                while (i < size) {
                    result.put(ordered.get(i)[rowIdColumn].getInt(), ValueBigint.get(++i));
                }
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: {
                this.getRank(result, ordered, rowIdColumn);
                break;
            }
            case CUME_DIST: {
                this.getCumeDist(result, ordered, rowIdColumn);
                break;
            }
            case NTILE: {
                WindowFunction.getNtile(result, ordered, rowIdColumn);
                break;
            }
            case LEAD: 
            case LAG: {
                this.getLeadLag(result, ordered, rowIdColumn, session);
                break;
            }
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                this.getNth(session, result, ordered, rowIdColumn);
                break;
            }
            case RATIO_TO_REPORT: {
                WindowFunction.getRatioToReport(result, ordered, rowIdColumn);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.type));
            }
        }
    }

    private void getRank(HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        int size = ordered.size();
        int number = 0;
        for (int i = 0; i < size; ++i) {
            int nm;
            Value[] row = ordered.get(i);
            if (i == 0) {
                number = 1;
            } else if (this.getOverOrderBySort().compare(ordered.get(i - 1), row) != 0) {
                number = this.type == WindowFunctionType.DENSE_RANK ? ++number : i + 1;
            }
            Value v = this.type == WindowFunctionType.PERCENT_RANK ? ((nm = number - 1) == 0 ? ValueDouble.ZERO : ValueDouble.get((double)nm / (double)(size - 1))) : ValueBigint.get(number);
            result.put(row[rowIdColumn].getInt(), v);
        }
    }

    private void getCumeDist(HashMap<Integer, Value> result, ArrayList<Value[]> orderedData, int rowIdColumn) {
        int size = orderedData.size();
        int start = 0;
        while (start < size) {
            int end;
            Value[] array = orderedData.get(start);
            for (end = start + 1; end < size && this.overOrderBySort.compare(array, orderedData.get(end)) == 0; ++end) {
            }
            ValueDouble v = ValueDouble.get((double)end / (double)size);
            for (int i = start; i < end; ++i) {
                int rowId = orderedData.get(i)[rowIdColumn].getInt();
                result.put(rowId, v);
            }
            start = end;
        }
    }

    private static void getNtile(HashMap<Integer, Value> result, ArrayList<Value[]> orderedData, int rowIdColumn) {
        int size = orderedData.size();
        for (int i = 0; i < size; ++i) {
            Value[] array = orderedData.get(i);
            long buckets = array[0].getLong();
            if (buckets <= 0L) {
                throw DbException.getInvalidValueException("number of tiles", buckets);
            }
            long perTile = (long)size / buckets;
            long numLarger = (long)size - perTile * buckets;
            long largerGroup = numLarger * (perTile + 1L);
            long v = (long)i >= largerGroup ? ((long)i - largerGroup) / perTile + numLarger + 1L : (long)i / (perTile + 1L) + 1L;
            result.put(orderedData.get(i)[rowIdColumn].getInt(), ValueBigint.get(v));
        }
    }

    private void getLeadLag(HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn, SessionLocal session) {
        int size = ordered.size();
        int numExpressions = this.getNumExpressions();
        TypeInfo dataType = this.args[0].getType();
        for (int i = 0; i < size; ++i) {
            int j;
            int n;
            Value[] row = ordered.get(i);
            int rowId = row[rowIdColumn].getInt();
            if (numExpressions >= 2) {
                n = row[1].getInt();
                if (n < 0) {
                    throw DbException.getInvalidValueException("nth row", n);
                }
            } else {
                n = 1;
            }
            Value v = null;
            if (n == 0) {
                v = ordered.get(i)[0];
            } else if (this.type == WindowFunctionType.LEAD) {
                if (this.ignoreNulls) {
                    for (j = i + 1; n > 0 && j < size; ++j) {
                        v = ordered.get(j)[0];
                        if (v == ValueNull.INSTANCE) continue;
                        --n;
                    }
                    if (n > 0) {
                        v = null;
                    }
                } else if (n <= size - i - 1) {
                    v = ordered.get(i + n)[0];
                }
            } else if (this.ignoreNulls) {
                for (j = i - 1; n > 0 && j >= 0; --j) {
                    v = ordered.get(j)[0];
                    if (v == ValueNull.INSTANCE) continue;
                    --n;
                }
                if (n > 0) {
                    v = null;
                }
            } else if (n <= i) {
                v = ordered.get(i - n)[0];
            }
            if (v == null) {
                v = numExpressions >= 3 ? row[2].convertTo(dataType, (CastDataProvider)session) : ValueNull.INSTANCE;
            }
            result.put(rowId, v);
        }
    }

    private void getNth(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        int size = ordered.size();
        for (int i = 0; i < size; ++i) {
            Value v;
            Value[] row = ordered.get(i);
            int rowId = row[rowIdColumn].getInt();
            switch (this.type) {
                case FIRST_VALUE: {
                    v = WindowFunction.getNthValue(WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, false), 0, this.ignoreNulls);
                    break;
                }
                case LAST_VALUE: {
                    v = WindowFunction.getNthValue(WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, true), 0, this.ignoreNulls);
                    break;
                }
                case NTH_VALUE: {
                    int n = row[1].getInt();
                    if (n <= 0) {
                        throw DbException.getInvalidValueException("nth row", n);
                    }
                    Iterator<Value[]> iter = WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, this.fromLast);
                    v = WindowFunction.getNthValue(iter, --n, this.ignoreNulls);
                    break;
                }
                default: {
                    throw DbException.getInternalError("type=" + (Object)((Object)this.type));
                }
            }
            result.put(rowId, v);
        }
    }

    private static void getRatioToReport(HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        int i;
        int size = ordered.size();
        Value value = null;
        for (i = 0; i < size; ++i) {
            Value v = ordered.get(i)[0];
            if (v == ValueNull.INSTANCE) continue;
            value = value == null ? v.convertToDouble() : value.add(v.convertToDouble());
        }
        if (value != null && value.getSignum() == 0) {
            value = null;
        }
        for (i = 0; i < size; ++i) {
            Value v;
            Value[] row = ordered.get(i);
            if (value == null) {
                v = ValueNull.INSTANCE;
            } else {
                v = row[0];
                if (v != ValueNull.INSTANCE) {
                    v = v.convertToDouble().divide(value, TypeInfo.TYPE_DOUBLE);
                }
            }
            result.put(row[rowIdColumn].getInt(), v);
        }
    }

    @Override
    protected Value getAggregatedValue(SessionLocal session, Object aggregateData) {
        throw DbException.getUnsupportedException("Window function");
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        if (this.args != null) {
            for (Expression arg : this.args) {
                arg.mapColumns(resolver, level, innerState);
            }
        }
        super.mapColumnsAnalysis(resolver, level, innerState);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        if (this.over.getWindowFrame() != null) {
            switch (this.type) {
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTH_VALUE: {
                    break;
                }
                default: {
                    String sql = this.getTraceSQL();
                    throw DbException.getSyntaxError(sql, sql.length() - 1);
                }
            }
        }
        if (this.over.getOrderBy() == null) {
            if (this.type.requiresWindowOrdering()) {
                String sql = this.getTraceSQL();
                throw DbException.getSyntaxError(sql, sql.length() - 1, "ORDER BY");
            }
        } else if (this.type == WindowFunctionType.RATIO_TO_REPORT) {
            String sql = this.getTraceSQL();
            throw DbException.getSyntaxError(sql, sql.length() - 1);
        }
        super.optimize(session);
        if (this.over.getOrderBy() == null) {
            switch (this.type) {
                case RANK: 
                case DENSE_RANK: {
                    return ValueExpression.get(ValueBigint.get(1L));
                }
                case PERCENT_RANK: {
                    return ValueExpression.get(ValueDouble.ZERO);
                }
                case CUME_DIST: {
                    return ValueExpression.get(ValueDouble.ONE);
                }
            }
        }
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].optimize(session);
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.args != null) {
            for (Expression e : this.args) {
                e.setEvaluatable(tableFilter, b);
            }
        }
        super.setEvaluatable(tableFilter, b);
    }

    @Override
    public TypeInfo getType() {
        switch (this.type) {
            case NTILE: 
            case ROW_NUMBER: 
            case RANK: 
            case DENSE_RANK: {
                return TypeInfo.TYPE_BIGINT;
            }
            case RATIO_TO_REPORT: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                return TypeInfo.TYPE_DOUBLE;
            }
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                return this.args[0].getType();
            }
        }
        throw DbException.getInternalError("type=" + (Object)((Object)this.type));
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.type.getSQL()).append('(');
        if (this.args != null) {
            WindowFunction.writeExpressions(builder, this.args, sqlFlags);
        }
        builder.append(')');
        if (this.fromLast && this.type == WindowFunctionType.NTH_VALUE) {
            builder.append(" FROM LAST");
        }
        if (this.ignoreNulls) {
            switch (this.type) {
                case LEAD: 
                case LAG: 
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTH_VALUE: {
                    builder.append(" IGNORE NULLS");
                }
            }
        }
        return this.appendTailConditions(builder, sqlFlags, this.type.requiresWindowOrdering());
    }

    @Override
    public int getCost() {
        int cost = 1;
        if (this.args != null) {
            for (Expression expr : this.args) {
                cost += expr.getCost();
            }
        }
        return cost;
    }
}

