/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.SearchedCase;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.NullPredicate;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

public final class CompareLike
extends Condition {
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private final CompareMode compareMode;
    private final String defaultEscape;
    private final LikeType likeType;
    private Expression left;
    private final boolean not;
    private final boolean whenOperand;
    private Expression right;
    private Expression escape;
    private boolean isInit;
    private char[] patternChars;
    private String patternString;
    private int[] patternTypes;
    private int patternLength;
    private Pattern patternRegexp;
    private boolean ignoreCase;
    private boolean fastCompare;
    private boolean invalidPattern;
    private boolean shortcutToStartsWith;
    private boolean shortcutToEndsWith;
    private boolean shortcutToContains;

    public CompareLike(Database db, Expression left, boolean not, boolean whenOperand, Expression right, Expression escape, LikeType likeType) {
        this(db.getCompareMode(), db.getSettings().defaultEscape, left, not, whenOperand, right, escape, likeType);
    }

    public CompareLike(CompareMode compareMode, String defaultEscape, Expression left, boolean not, boolean whenOperand, Expression right, Expression escape, LikeType likeType) {
        this.compareMode = compareMode;
        this.defaultEscape = defaultEscape;
        this.likeType = likeType;
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
        this.right = right;
        this.escape = escape;
    }

    private static Character getEscapeChar(String s) {
        return s == null || s.isEmpty() ? null : Character.valueOf(s.charAt(0));
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        if (this.not) {
            builder.append(" NOT");
        }
        switch (this.likeType) {
            case LIKE: 
            case ILIKE: {
                builder.append(this.likeType == LikeType.LIKE ? " LIKE " : " ILIKE ");
                this.right.getSQL(builder, sqlFlags, 0);
                if (this.escape == null) break;
                this.escape.getSQL(builder.append(" ESCAPE "), sqlFlags, 0);
                break;
            }
            case REGEXP: {
                builder.append(" REGEXP ");
                this.right.getSQL(builder, sqlFlags, 0);
                break;
            }
            default: {
                throw DbException.getUnsupportedException(this.likeType.name());
            }
        }
        return builder;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Value l;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.likeType == LikeType.ILIKE || this.left.getType().getValueType() == 4) {
            this.ignoreCase = true;
        }
        if (this.escape != null) {
            this.escape = this.escape.optimize(session);
        }
        if (this.whenOperand) {
            return this;
        }
        if (this.left.isValueSet() && (l = this.left.getValue(session)) == ValueNull.INSTANCE) {
            return TypedValueExpression.UNKNOWN;
        }
        if (this.right.isValueSet() && (this.escape == null || this.escape.isValueSet())) {
            Value e;
            if (this.left.isValueSet()) {
                return ValueExpression.getBoolean(this.getValue(session));
            }
            Value r = this.right.getValue(session);
            if (r == ValueNull.INSTANCE) {
                return TypedValueExpression.UNKNOWN;
            }
            Value value = e = this.escape == null ? null : this.escape.getValue(session);
            if (e == ValueNull.INSTANCE) {
                return TypedValueExpression.UNKNOWN;
            }
            String p = r.getString();
            this.initPattern(p, this.getEscapeChar(e));
            if (this.invalidPattern) {
                return TypedValueExpression.UNKNOWN;
            }
            if (this.likeType != LikeType.REGEXP && "%".equals(p)) {
                return new SearchedCase(new Expression[]{new NullPredicate(this.left, true, false), ValueExpression.getBoolean(!this.not), TypedValueExpression.UNKNOWN}).optimize(session);
            }
            if (this.isFullMatch()) {
                Value value2 = this.ignoreCase ? ValueVarcharIgnoreCase.get(this.patternString) : ValueVarchar.get(this.patternString);
                ValueExpression expr = ValueExpression.get(value2);
                return new Comparison(this.not ? 1 : 0, this.left, expr, false).optimize(session);
            }
            this.isInit = true;
        }
        return this;
    }

    private Character getEscapeChar(Value e) {
        Character esc;
        if (e == null) {
            return CompareLike.getEscapeChar(this.defaultEscape);
        }
        String es = e.getString();
        if (es == null) {
            esc = CompareLike.getEscapeChar(this.defaultEscape);
        } else if (es.length() == 0) {
            esc = null;
        } else {
            if (es.length() > 1) {
                throw DbException.get(22025, es);
            }
            esc = Character.valueOf(es.charAt(0));
        }
        return esc;
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.not || this.whenOperand || this.likeType == LikeType.REGEXP || !(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter() || !TypeInfo.haveSameOrdering(l.getType(), this.ignoreCase ? TypeInfo.TYPE_VARCHAR_IGNORECASE : TypeInfo.TYPE_VARCHAR)) {
            return;
        }
        if (!this.right.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return;
        }
        if (this.escape != null && !this.escape.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return;
        }
        String p = this.right.getValue(session).getString();
        if (!this.isInit) {
            Value e;
            Value value = e = this.escape == null ? null : this.escape.getValue(session);
            if (e == ValueNull.INSTANCE) {
                throw DbException.getInternalError();
            }
            this.initPattern(p, this.getEscapeChar(e));
        }
        if (this.invalidPattern) {
            return;
        }
        if (this.patternLength <= 0 || this.patternTypes[0] != 0) {
            return;
        }
        if (!DataType.isStringType(l.getColumn().getType().getValueType())) {
            return;
        }
        int maxMatch = 0;
        StringBuilder buff = new StringBuilder();
        while (maxMatch < this.patternLength && this.patternTypes[maxMatch] == 0) {
            buff.append(this.patternChars[maxMatch++]);
        }
        String begin = buff.toString();
        if (maxMatch == this.patternLength) {
            filter.addIndexCondition(IndexCondition.get(0, l, ValueExpression.get(ValueVarchar.get(begin))));
        } else if (begin.length() > 0) {
            filter.addIndexCondition(IndexCondition.get(5, l, ValueExpression.get(ValueVarchar.get(begin))));
            char next = begin.charAt(begin.length() - 1);
            for (int i = 1; i < 2000; ++i) {
                String end = begin.substring(0, begin.length() - 1) + (char)(next + i);
                if (this.compareMode.compareString(begin, end, this.ignoreCase) >= 0) continue;
                filter.addIndexCondition(IndexCondition.get(2, l, ValueExpression.get(ValueVarchar.get(end))));
                break;
            }
        }
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.getValue(session, this.left.getValue(session));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(session, left).isTrue();
    }

    private Value getValue(SessionLocal session, Value left) {
        boolean result;
        if (left == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        if (!this.isInit) {
            Value e;
            Value r = this.right.getValue(session);
            if (r == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            String p = r.getString();
            Value value = e = this.escape == null ? null : this.escape.getValue(session);
            if (e == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            this.initPattern(p, this.getEscapeChar(e));
        }
        if (this.invalidPattern) {
            return ValueNull.INSTANCE;
        }
        String value = left.getString();
        if (this.likeType == LikeType.REGEXP) {
            result = this.patternRegexp.matcher(value).find();
        } else if (this.shortcutToStartsWith) {
            result = value.regionMatches(this.ignoreCase, 0, this.patternString, 0, this.patternLength - 1);
        } else if (this.shortcutToEndsWith) {
            result = value.regionMatches(this.ignoreCase, value.length() - this.patternLength + 1, this.patternString, 1, this.patternLength - 1);
        } else if (this.shortcutToContains) {
            String p = this.patternString.substring(1, this.patternString.length() - 1);
            result = this.ignoreCase ? CompareLike.containsIgnoreCase(value, p) : value.contains(p);
        } else {
            result = this.compareAt(value, 0, 0, value.length(), this.patternChars, this.patternTypes);
        }
        return ValueBoolean.get(this.not ^ result);
    }

    private static boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    private boolean compareAt(String s, int pi, int si, int sLen, char[] pattern, int[] types) {
        while (pi < this.patternLength) {
            switch (types[pi]) {
                case 0: {
                    if (si < sLen && this.compare(pattern, s, pi, si++)) break;
                    return false;
                }
                case 1: {
                    if (si++ < sLen) break;
                    return false;
                }
                case 2: {
                    if (++pi >= this.patternLength) {
                        return true;
                    }
                    while (si < sLen) {
                        if (this.compare(pattern, s, pi, si) && this.compareAt(s, pi, si, sLen, pattern, types)) {
                            return true;
                        }
                        ++si;
                    }
                    return false;
                }
                default: {
                    throw DbException.getInternalError(Integer.toString(types[pi]));
                }
            }
            ++pi;
        }
        return si == sLen;
    }

    private boolean compare(char[] pattern, String s, int pi, int si) {
        return pattern[pi] == s.charAt(si) || !this.fastCompare && this.compareMode.equalsChars(this.patternString, pi, s, si, this.ignoreCase);
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    public boolean test(String testPattern, String value, char escapeChar) {
        this.initPattern(testPattern, Character.valueOf(escapeChar));
        return this.test(value);
    }

    public boolean test(String value) {
        if (this.invalidPattern) {
            return false;
        }
        return this.compareAt(value, 0, 0, value.length(), this.patternChars, this.patternTypes);
    }

    public void initPattern(String p, Character escapeChar) {
        int maxMatch;
        int i;
        if (this.compareMode.getName().equals("OFF") && !this.ignoreCase) {
            this.fastCompare = true;
        }
        if (this.likeType == LikeType.REGEXP) {
            this.patternString = p;
            try {
                this.patternRegexp = this.ignoreCase ? Pattern.compile(p, 2) : Pattern.compile(p);
            }
            catch (PatternSyntaxException e) {
                throw DbException.get(22025, e, p);
            }
            return;
        }
        this.patternLength = 0;
        if (p == null) {
            this.patternTypes = null;
            this.patternChars = null;
            return;
        }
        int len = p.length();
        this.patternChars = new char[len];
        this.patternTypes = new int[len];
        boolean lastAny = false;
        for (i = 0; i < len; ++i) {
            int type;
            char c = p.charAt(i);
            if (escapeChar != null && escapeChar.charValue() == c) {
                if (i >= len - 1) {
                    this.invalidPattern = true;
                    return;
                }
                c = p.charAt(++i);
                type = 0;
                lastAny = false;
            } else if (c == '%') {
                if (lastAny) continue;
                type = 2;
                lastAny = true;
            } else if (c == '_') {
                type = 1;
            } else {
                type = 0;
                lastAny = false;
            }
            this.patternTypes[this.patternLength] = type;
            this.patternChars[this.patternLength++] = c;
        }
        for (i = 0; i < this.patternLength - 1; ++i) {
            if (this.patternTypes[i] != 2 || this.patternTypes[i + 1] != 1) continue;
            this.patternTypes[i] = 1;
            this.patternTypes[i + 1] = 2;
        }
        this.patternString = new String(this.patternChars, 0, this.patternLength);
        this.shortcutToStartsWith = false;
        this.shortcutToEndsWith = false;
        this.shortcutToContains = false;
        if (this.compareMode.getName().equals("OFF") && this.patternLength > 1) {
            for (maxMatch = 0; maxMatch < this.patternLength && this.patternTypes[maxMatch] == 0; ++maxMatch) {
            }
            if (maxMatch == this.patternLength - 1 && this.patternTypes[this.patternLength - 1] == 2) {
                this.shortcutToStartsWith = true;
                return;
            }
        }
        if (this.compareMode.getName().equals("OFF") && this.patternLength > 1 && this.patternTypes[0] == 2) {
            for (maxMatch = 1; maxMatch < this.patternLength && this.patternTypes[maxMatch] == 0; ++maxMatch) {
            }
            if (maxMatch == this.patternLength) {
                this.shortcutToEndsWith = true;
                return;
            }
        }
        if (this.compareMode.getName().equals("OFF") && this.patternLength > 2 && this.patternTypes[0] == 2) {
            for (maxMatch = 1; maxMatch < this.patternLength && this.patternTypes[maxMatch] == 0; ++maxMatch) {
            }
            if (maxMatch == this.patternLength - 1 && this.patternTypes[this.patternLength - 1] == 2) {
                this.shortcutToContains = true;
            }
        }
    }

    private boolean isFullMatch() {
        if (this.patternTypes == null) {
            return false;
        }
        for (int type : this.patternTypes) {
            if (type == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new CompareLike(this.compareMode, this.defaultEscape, this.left, !this.not, false, this.right, this.escape, this.likeType);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.right.mapColumns(resolver, level, state);
        if (this.escape != null) {
            this.escape.mapColumns(resolver, level, state);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
        if (this.escape != null) {
            this.escape.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        this.right.updateAggregate(session, stage);
        if (this.escape != null) {
            this.escape.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor) && (this.escape == null || this.escape.isEverything(visitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 3;
    }

    @Override
    public int getSubexpressionCount() {
        return this.escape == null ? 2 : 3;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
            case 2: {
                if (this.escape == null) break;
                return this.escape;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static enum LikeType {
        LIKE,
        ILIKE,
        REGEXP;

    }
}

