/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.NullPredicate;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public final class Comparison
extends Condition {
    public static final int EQUAL = 0;
    public static final int NOT_EQUAL = 1;
    public static final int SMALLER = 2;
    public static final int BIGGER = 3;
    public static final int SMALLER_EQUAL = 4;
    public static final int BIGGER_EQUAL = 5;
    public static final int EQUAL_NULL_SAFE = 6;
    public static final int NOT_EQUAL_NULL_SAFE = 7;
    public static final int SPATIAL_INTERSECTS = 8;
    static final String[] COMPARE_TYPES = new String[]{"=", "<>", "<", ">", "<=", ">=", "IS NOT DISTINCT FROM", "IS DISTINCT FROM", "&&"};
    public static final int FALSE = 9;
    public static final int IN_LIST = 10;
    public static final int IN_QUERY = 11;
    private int compareType;
    private Expression left;
    private Expression right;
    private final boolean whenOperand;

    public Comparison(int compareType, Expression left, Expression right, boolean whenOperand) {
        this.left = left;
        this.right = right;
        this.compareType = compareType;
        this.whenOperand = whenOperand;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        builder.append(' ').append(COMPARE_TYPES[this.compareType]).append(' ');
        return this.right.getSQL(builder, sqlFlags, this.right instanceof Aggregate && ((Aggregate)this.right).getAggregateType() == AggregateType.ANY ? 1 : 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        leftType = this.left.getType();
        rightType = this.right.getType();
        if (!session.getMode().numericWithBooleanComparison) ** GOTO lbl-1000
        switch (this.compareType) {
            case 0: 
            case 1: 
            case 6: 
            case 7: {
                lValueType = leftType.getValueType();
                if (lValueType == 8 ? DataType.isNumericType(rightType.getValueType()) != false : DataType.isNumericType(lValueType) != false && rightType.getValueType() == 8) break;
            }
            default: lbl-1000:
            // 2 sources

            {
                TypeInfo.checkComparable(leftType, rightType);
            }
        }
        if (this.whenOperand) {
            return this;
        }
        if (this.right instanceof ExpressionColumn && (this.left.isConstant() || this.left instanceof Parameter)) {
            temp = this.left;
            this.left = this.right;
            this.right = temp;
            this.compareType = Comparison.getReversedCompareType(this.compareType);
        }
        if (this.left instanceof ExpressionColumn) {
            if (this.right.isConstant()) {
                r = this.right.getValue(session);
                if (r == ValueNull.INSTANCE && (this.compareType & -2) != 6) {
                    return TypedValueExpression.UNKNOWN;
                }
                colType = this.left.getType();
                constType = r.getType();
                constValueType = constType.getValueType();
                if (!(constValueType == colType.getValueType() && constValueType < 40 || constValueType == (resType = TypeInfo.getHigherType(colType, constType)).getValueType() && constValueType < 40)) {
                    column = ((ExpressionColumn)this.left).getColumn();
                    this.right = ValueExpression.get(r.convertTo(resType, session, column));
                }
            } else if (this.right instanceof Parameter) {
                ((Parameter)this.right).setColumn(((ExpressionColumn)this.left).getColumn());
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        if (this.left.isNullConstant() || this.right.isNullConstant()) {
            if ((this.compareType & -2) != 6) {
                return TypedValueExpression.UNKNOWN;
            }
            e = this.left.isNullConstant() != false ? this.right : this.left;
            type = e.getType().getValueType();
            if (type != -1 && type != 41) {
                return new NullPredicate(e, this.compareType == 7, false);
            }
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE && (this.compareType & 0xFFFFFFFE) != 6) {
            return ValueNull.INSTANCE;
        }
        return Comparison.compare(session, l, this.right.getValue(session), this.compareType);
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        if (left == ValueNull.INSTANCE && (this.compareType & 0xFFFFFFFE) != 6) {
            return false;
        }
        return Comparison.compare(session, left, this.right.getValue(session), this.compareType).isTrue();
    }

    static Value compare(SessionLocal session, Value l, Value r, int compareType) {
        Value result;
        switch (compareType) {
            case 0: {
                int cmp = session.compareWithNull(l, r, true);
                if (cmp == 0) {
                    result = ValueBoolean.TRUE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.FALSE;
                break;
            }
            case 6: {
                result = ValueBoolean.get(session.areEqual(l, r));
                break;
            }
            case 1: {
                int cmp = session.compareWithNull(l, r, true);
                if (cmp == 0) {
                    result = ValueBoolean.FALSE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.TRUE;
                break;
            }
            case 7: {
                result = ValueBoolean.get(!session.areEqual(l, r));
                break;
            }
            case 5: {
                int cmp = session.compareWithNull(l, r, false);
                if (cmp >= 0) {
                    result = ValueBoolean.TRUE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.FALSE;
                break;
            }
            case 3: {
                int cmp = session.compareWithNull(l, r, false);
                if (cmp > 0) {
                    result = ValueBoolean.TRUE;
                    break;
                }
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.FALSE;
                break;
            }
            case 4: {
                int cmp = session.compareWithNull(l, r, false);
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.get(cmp <= 0);
                break;
            }
            case 2: {
                int cmp = session.compareWithNull(l, r, false);
                if (cmp == Integer.MIN_VALUE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.get(cmp < 0);
                break;
            }
            case 8: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueBoolean.get(l.convertToGeometry(null).intersectsBoundingBox(r.convertToGeometry(null)));
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + compareType);
            }
        }
        return result;
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    private static int getReversedCompareType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                return type;
            }
            case 5: {
                return 4;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 2: {
                return 3;
            }
        }
        throw DbException.getInternalError("type=" + type);
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.compareType == 8 || this.whenOperand) {
            return null;
        }
        int type = this.getNotCompareType();
        return new Comparison(type, this.left, this.right, false);
    }

    private int getNotCompareType() {
        switch (this.compareType) {
            case 0: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 1: {
                return 0;
            }
            case 7: {
                return 6;
            }
            case 5: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 2: {
                return 5;
            }
        }
        throw DbException.getInternalError("type=" + this.compareType);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (!this.whenOperand) {
            Comparison.createIndexConditions(filter, this.left, this.right, this.compareType);
        }
    }

    static void createIndexConditions(TableFilter filter, Expression left, Expression right, int compareType) {
        if (!filter.getTable().isQueryComparable()) {
            return;
        }
        ExpressionColumn l = null;
        if (left instanceof ExpressionColumn && filter != (l = (ExpressionColumn)left).getTableFilter()) {
            l = null;
        }
        ExpressionColumn r = null;
        if (right instanceof ExpressionColumn && filter != (r = (ExpressionColumn)right).getTableFilter()) {
            r = null;
        }
        if (l == null == (r == null)) {
            return;
        }
        if (l == null ? !left.isEverything(ExpressionVisitor.getNotFromResolverVisitor(filter)) : !right.isEverything(ExpressionVisitor.getNotFromResolverVisitor(filter))) {
            return;
        }
        switch (compareType) {
            case 1: 
            case 7: {
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (l != null) {
                    TypeInfo colType = l.getType();
                    if (!TypeInfo.haveSameOrdering(colType, TypeInfo.getHigherType(colType, right.getType()))) break;
                    filter.addIndexCondition(IndexCondition.get(compareType, l, right));
                    break;
                }
                TypeInfo colType = r.getType();
                if (!TypeInfo.haveSameOrdering(colType, TypeInfo.getHigherType(colType, left.getType()))) break;
                filter.addIndexCondition(IndexCondition.get(Comparison.getReversedCompareType(compareType), r, left));
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + compareType);
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        if (this.right != null) {
            this.right.updateAggregate(session, stage);
        }
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.right.mapColumns(resolver, level, state);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 1;
    }

    Expression getIfEquals(Expression match) {
        if (this.compareType == 0) {
            String sql = match.getSQL(0);
            if (this.left.getSQL(0).equals(sql)) {
                return this.right;
            }
            if (this.right.getSQL(0).equals(sql)) {
                return this.left;
            }
        }
        return null;
    }

    Expression getAdditionalAnd(SessionLocal session, Comparison other) {
        if (this.compareType == 0 && other.compareType == 0 && !this.whenOperand) {
            boolean lc = this.left.isConstant();
            boolean rc = this.right.isConstant();
            boolean l2c = other.left.isConstant();
            boolean r2c = other.right.isConstant();
            String l = this.left.getSQL(0);
            String l2 = other.left.getSQL(0);
            String r = this.right.getSQL(0);
            String r2 = other.right.getSQL(0);
            if (!(rc && r2c || !l.equals(l2))) {
                return new Comparison(0, this.right, other.right, false);
            }
            if (!(rc && l2c || !l.equals(r2))) {
                return new Comparison(0, this.right, other.left, false);
            }
            if (!(lc && r2c || !r.equals(l2))) {
                return new Comparison(0, this.left, other.right, false);
            }
            if (!(lc && l2c || !r.equals(r2))) {
                return new Comparison(0, this.left, other.left, false);
            }
        }
        return null;
    }

    Expression optimizeOr(SessionLocal session, Comparison other) {
        if (this.compareType == 0 && other.compareType == 0) {
            Expression left2 = other.left;
            Expression right2 = other.right;
            String l2 = left2.getSQL(0);
            String r2 = right2.getSQL(0);
            if (this.left.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR)) {
                String l = this.left.getSQL(0);
                if (l.equals(l2)) {
                    return Comparison.getConditionIn(this.left, this.right, right2);
                }
                if (l.equals(r2)) {
                    return Comparison.getConditionIn(this.left, this.right, left2);
                }
            }
            if (this.right.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR)) {
                String r = this.right.getSQL(0);
                if (r.equals(l2)) {
                    return Comparison.getConditionIn(this.right, this.left, right2);
                }
                if (r.equals(r2)) {
                    return Comparison.getConditionIn(this.right, this.left, left2);
                }
            }
        }
        return null;
    }

    private static ConditionIn getConditionIn(Expression left, Expression value1, Expression value2) {
        ArrayList<Expression> right = new ArrayList<Expression>(2);
        right.add(value1);
        right.add(value2);
        return new ConditionIn(left, false, false, right);
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

