/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.ConditionInConstantSet;
import org.h2.expression.condition.ConditionNot;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOrN
extends Condition {
    private final int andOrType;
    private final List<Expression> expressions;
    private List<Expression> added;
    private static final Comparator<Expression> COMPARE_BY_COST = new Comparator<Expression>(){

        @Override
        public int compare(Expression lhs, Expression rhs) {
            return lhs.getCost() - rhs.getCost();
        }
    };

    public ConditionAndOrN(int andOrType, Expression expr1, Expression expr2, Expression expr3) {
        this.andOrType = andOrType;
        this.expressions = new ArrayList<Expression>(3);
        this.expressions.add(expr1);
        this.expressions.add(expr2);
        this.expressions.add(expr3);
    }

    public ConditionAndOrN(int andOrType, List<Expression> expressions) {
        this.andOrType = andOrType;
        this.expressions = expressions;
    }

    int getAndOrType() {
        return this.andOrType;
    }

    void addFirst(Expression e) {
        this.expressions.add(0, e);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        Iterator<Expression> it = this.expressions.iterator();
        it.next().getSQL(builder, sqlFlags, 0);
        while (it.hasNext()) {
            switch (this.andOrType) {
                case 0: {
                    builder.append("\n    AND ");
                    break;
                }
                case 1: {
                    builder.append("\n    OR ");
                    break;
                }
                default: {
                    throw DbException.getInternalError("andOrType=" + this.andOrType);
                }
            }
            it.next().getSQL(builder, sqlFlags, 0);
        }
        return builder;
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.andOrType == 0) {
            for (Expression e : this.expressions) {
                e.createIndexConditions(session, filter);
            }
            if (this.added != null) {
                for (Expression e : this.added) {
                    e.createIndexConditions(session, filter);
                }
            }
        }
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        ArrayList<Expression> newList = new ArrayList<Expression>(this.expressions.size());
        for (Expression e : this.expressions) {
            Expression l = e.getNotIfPossible(session);
            if (l == null) {
                l = new ConditionNot(e);
            }
            newList.add(l);
        }
        int reversed = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOrN(reversed, newList);
    }

    @Override
    public Value getValue(SessionLocal session) {
        boolean hasNull = false;
        switch (this.andOrType) {
            case 0: {
                for (Expression e : this.expressions) {
                    Value v = e.getValue(session);
                    if (v == ValueNull.INSTANCE) {
                        hasNull = true;
                        continue;
                    }
                    if (v.getBoolean()) continue;
                    return ValueBoolean.FALSE;
                }
                return hasNull ? ValueNull.INSTANCE : ValueBoolean.TRUE;
            }
            case 1: {
                for (Expression e : this.expressions) {
                    Value v = e.getValue(session);
                    if (v == ValueNull.INSTANCE) {
                        hasNull = true;
                        continue;
                    }
                    if (!v.getBoolean()) continue;
                    return ValueBoolean.TRUE;
                }
                return hasNull ? ValueNull.INSTANCE : ValueBoolean.FALSE;
            }
        }
        throw DbException.getInternalError("type=" + this.andOrType);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        int i;
        for (i = 0; i < this.expressions.size(); ++i) {
            this.expressions.set(i, this.expressions.get(i).optimize(session));
        }
        Collections.sort(this.expressions, COMPARE_BY_COST);
        this.optimizeMerge(0);
        i = 1;
        block5: while (i < this.expressions.size()) {
            Expression left = this.expressions.get(i - 1);
            Expression right = this.expressions.get(i);
            switch (this.andOrType) {
                case 0: {
                    Expression added;
                    if (!session.getDatabase().getSettings().optimizeTwoEquals || !(left instanceof Comparison) || !(right instanceof Comparison) || (added = ((Comparison)left).getAdditionalAnd(session, (Comparison)right)) == null) break;
                    if (this.added == null) {
                        this.added = new ArrayList<Expression>();
                    }
                    this.added.add(added.optimize(session));
                    break;
                }
                case 1: {
                    Expression reduced;
                    if (!session.getDatabase().getSettings().optimizeOr) break;
                    if (left instanceof Comparison && right instanceof Comparison) {
                        reduced = ((Comparison)left).optimizeOr(session, (Comparison)right);
                    } else if (left instanceof ConditionIn && right instanceof Comparison) {
                        reduced = ((ConditionIn)left).getAdditional((Comparison)right);
                    } else if (right instanceof ConditionIn && left instanceof Comparison) {
                        reduced = ((ConditionIn)right).getAdditional((Comparison)left);
                    } else if (left instanceof ConditionInConstantSet && right instanceof Comparison) {
                        reduced = ((ConditionInConstantSet)left).getAdditional(session, (Comparison)right);
                    } else if (right instanceof ConditionInConstantSet && left instanceof Comparison) {
                        reduced = ((ConditionInConstantSet)right).getAdditional(session, (Comparison)left);
                    } else {
                        if (!(left instanceof ConditionAndOr) || !(right instanceof ConditionAndOr)) break;
                        reduced = ConditionAndOr.optimizeConditionAndOr((ConditionAndOr)left, (ConditionAndOr)right);
                    }
                    if (reduced == null) break;
                    this.expressions.remove(i);
                    this.expressions.set(i - 1, reduced.optimize(session));
                    continue block5;
                }
            }
            Expression e = ConditionAndOr.optimizeIfConstant(session, this.andOrType, left, right);
            if (e != null) {
                this.expressions.remove(i);
                this.expressions.set(i - 1, e);
                continue;
            }
            if (this.optimizeMerge(i)) continue;
            ++i;
        }
        Collections.sort(this.expressions, COMPARE_BY_COST);
        if (this.expressions.size() == 1) {
            return Condition.castToBoolean(session, this.expressions.get(0));
        }
        return this;
    }

    private boolean optimizeMerge(int i) {
        ConditionAndOr rightCondition;
        Expression e = this.expressions.get(i);
        if (e instanceof ConditionAndOrN) {
            ConditionAndOrN rightCondition2 = (ConditionAndOrN)e;
            if (this.andOrType == rightCondition2.andOrType) {
                this.expressions.remove(i);
                this.expressions.addAll(i, rightCondition2.expressions);
                return true;
            }
        } else if (e instanceof ConditionAndOr && this.andOrType == (rightCondition = (ConditionAndOr)e).getAndOrType()) {
            this.expressions.set(i, rightCondition.getSubexpression(0));
            this.expressions.add(i + 1, rightCondition.getSubexpression(1));
            return true;
        }
        return false;
    }

    @Override
    public void addFilterConditions(TableFilter filter) {
        if (this.andOrType == 0) {
            for (Expression e : this.expressions) {
                e.addFilterConditions(filter);
            }
        } else {
            super.addFilterConditions(filter);
        }
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.expressions) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.expressions) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        for (Expression e : this.expressions) {
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.expressions) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 0;
        for (Expression e : this.expressions) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.expressions.size();
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.expressions.get(index);
    }
}

