/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionInConstantSet;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public final class ConditionIn
extends Condition {
    private Expression left;
    private final boolean not;
    private final boolean whenOperand;
    private final ArrayList<Expression> valueList;

    public ConditionIn(Expression left, boolean not, boolean whenOperand, ArrayList<Expression> values) {
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
        this.valueList = values;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.getValue(session, this.left.getValue(session));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(session, left).isTrue();
    }

    private Value getValue(SessionLocal session, Value left) {
        if (left.containsNull()) {
            return ValueNull.INSTANCE;
        }
        boolean hasNull = false;
        for (Expression e : this.valueList) {
            Value r = e.getValue(session);
            Value cmp = Comparison.compare(session, left, r, 0);
            if (cmp == ValueNull.INSTANCE) {
                hasNull = true;
                continue;
            }
            if (cmp != ValueBoolean.TRUE) continue;
            return ValueBoolean.get(!this.not);
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.not);
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        for (Expression e : this.valueList) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean constant;
        this.left = this.left.optimize(session);
        boolean bl = constant = !this.whenOperand && this.left.isConstant();
        if (constant && this.left.isNullConstant()) {
            return TypedValueExpression.UNKNOWN;
        }
        boolean allValuesConstant = true;
        boolean allValuesNull = true;
        TypeInfo leftType = this.left.getType();
        int l = this.valueList.size();
        for (int i = 0; i < l; ++i) {
            Expression e = this.valueList.get(i);
            e = e.optimize(session);
            TypeInfo.checkComparable(leftType, e.getType());
            if (e.isConstant() && !e.getValue(session).containsNull()) {
                allValuesNull = false;
            }
            if (allValuesConstant && !e.isConstant()) {
                allValuesConstant = false;
            }
            if (this.left instanceof ExpressionColumn && e instanceof Parameter) {
                ((Parameter)e).setColumn(((ExpressionColumn)this.left).getColumn());
            }
            this.valueList.set(i, e);
        }
        return this.optimize2(session, constant, allValuesConstant, allValuesNull, this.valueList);
    }

    private Expression optimize2(SessionLocal session, boolean constant, boolean allValuesConstant, boolean allValuesNull, ArrayList<Expression> values) {
        if (constant && allValuesConstant) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        if (values.size() == 1) {
            return new Comparison(this.not ? 1 : 0, this.left, values.get(0), this.whenOperand).optimize(session);
        }
        if (allValuesConstant && !allValuesNull) {
            int leftType = this.left.getType().getValueType();
            if (leftType == -1) {
                return this;
            }
            if (leftType == 36 && !(this.left instanceof ExpressionColumn)) {
                return this;
            }
            return new ConditionInConstantSet(session, this.left, this.not, this.whenOperand, values).optimize(session);
        }
        return this;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new ConditionIn(this.left, !this.not, false, this.valueList);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.not || this.whenOperand || !(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            ExpressionVisitor visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
            TypeInfo colType = l.getType();
            for (Expression e : this.valueList) {
                if (e.isEverything(visitor) && TypeInfo.haveSameOrdering(colType, TypeInfo.getHigherType(colType, e.getType()))) continue;
                return;
            }
            filter.addIndexCondition(IndexCondition.getInList(l, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        for (Expression e : this.valueList) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        if (this.not) {
            builder.append(" NOT");
        }
        return ConditionIn.writeExpressions(builder.append(" IN("), this.valueList, sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        for (Expression e : this.valueList) {
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!this.left.isEverything(visitor)) {
            return false;
        }
        return this.areAllValues(visitor);
    }

    private boolean areAllValues(ExpressionVisitor visitor) {
        for (Expression e : this.valueList) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.left.getCost();
        for (Expression e : this.valueList) {
            cost += e.getCost();
        }
        return cost;
    }

    Expression getAdditional(Comparison other) {
        Expression add;
        if (!this.not && !this.whenOperand && this.left.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && (add = other.getIfEquals(this.left)) != null) {
            ArrayList<Expression> list = new ArrayList<Expression>(this.valueList.size() + 1);
            list.addAll(this.valueList);
            list.add(add);
            return new ConditionIn(this.left, false, false, list);
        }
        return null;
    }

    @Override
    public int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        if (index > 0 && index <= this.valueList.size()) {
            return this.valueList.get(index - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

