/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Condition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression condition) {
        this.condition = condition;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        return ConditionNot.castToBoolean(session, this.condition.optimize(session));
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v = this.condition.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return v;
        }
        return v.convertToBoolean().negate();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.condition.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Expression e2 = this.condition.getNotIfPossible(session);
        if (e2 != null) {
            return e2.optimize(session);
        }
        Expression expr = this.condition.optimize(session);
        if (expr.isConstant()) {
            Value v = expr.getValue(session);
            if (v == ValueNull.INSTANCE) {
                return TypedValueExpression.UNKNOWN;
            }
            return ValueExpression.getBoolean(!v.getBoolean());
        }
        this.condition = expr;
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.condition.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.condition.getSQL(builder.append("NOT "), sqlFlags, 0);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.condition.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.condition.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.condition.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.condition;
        }
        throw new IndexOutOfBoundsException();
    }
}

