/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Condition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;

public abstract class SimplePredicate
extends Condition {
    Expression left;
    final boolean not;
    final boolean whenOperand;

    SimplePredicate(Expression left, boolean not, boolean whenOperand) {
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (!this.whenOperand && this.left.isConstant()) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public final boolean needParentheses() {
        return true;
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final boolean isWhenConditionOperand() {
        return this.whenOperand;
    }
}

