/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.condition.SimplePredicate;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public final class TypePredicate
extends SimplePredicate {
    private final TypeInfo[] typeList;
    private int[] valueTypes;

    public TypePredicate(Expression left, boolean not, boolean whenOperand, TypeInfo[] typeList) {
        super(left, not, whenOperand);
        this.typeList = typeList;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        builder.append(" IS");
        if (this.not) {
            builder.append(" NOT");
        }
        builder.append(" OF (");
        for (int i = 0; i < this.typeList.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.typeList[i].getSQL(builder, sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public Expression optimize(SessionLocal session) {
        int count = this.typeList.length;
        this.valueTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            this.valueTypes[i] = this.typeList[i].getValueType();
        }
        Arrays.sort(this.valueTypes);
        return super.optimize(session);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(Arrays.binarySearch(this.valueTypes, l.getValueType()) >= 0 ^ this.not);
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        if (left == ValueNull.INSTANCE) {
            return false;
        }
        return Arrays.binarySearch(this.valueTypes, left.getValueType()) >= 0 ^ this.not;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new TypePredicate(this.left, !this.not, false, this.typeList);
    }
}

