/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.Arrays;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.PredicateWithSubquery;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class UniquePredicate
extends PredicateWithSubquery {
    public UniquePredicate(Query query) {
        super(query);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        super.optimize(session);
        if (this.query.isStandardDistinct()) {
            return ValueExpression.TRUE;
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        this.query.setSession(session);
        int columnCount = this.query.getColumnCount();
        LocalResult result = new LocalResult(session, this.query.getExpressions().toArray(new Expression[0]), columnCount, columnCount);
        result.setDistinct();
        Target target = new Target(columnCount, result);
        this.query.query(Integer.MAX_VALUE, target);
        result.close();
        return ValueBoolean.get(!target.hasDuplicates);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return super.getUnenclosedSQL(builder.append("UNIQUE"), sqlFlags);
    }

    private static final class Target
    implements ResultTarget {
        private final int columnCount;
        private final LocalResult result;
        boolean hasDuplicates;

        Target(int columnCount, LocalResult result) {
            this.columnCount = columnCount;
            this.result = result;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public long getRowCount() {
            return 0L;
        }

        @Override
        public void addRow(Value ... values) {
            if (this.hasDuplicates) {
                return;
            }
            for (int i = 0; i < this.columnCount; ++i) {
                if (values[i] != ValueNull.INSTANCE) continue;
                return;
            }
            if (values.length != this.columnCount) {
                values = Arrays.copyOf(values, this.columnCount);
            }
            long expected = this.result.getRowCount() + 1L;
            this.result.addRow(values);
            if (expected != this.result.getRowCount()) {
                this.hasDuplicates = true;
                this.result.close();
            }
        }
    }
}

