/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.util.Bits;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueInteger;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueVarbinary;

public final class BitFunction
extends Function1_2 {
    public static final int BITAND = 0;
    public static final int BITOR = 1;
    public static final int BITXOR = 2;
    public static final int BITNOT = 3;
    public static final int BITNAND = 4;
    public static final int BITNOR = 5;
    public static final int BITXNOR = 6;
    public static final int BITGET = 7;
    public static final int BITCOUNT = 8;
    public static final int LSHIFT = 9;
    public static final int RSHIFT = 10;
    public static final int ULSHIFT = 11;
    public static final int URSHIFT = 12;
    public static final int ROTATELEFT = 13;
    public static final int ROTATERIGHT = 14;
    private static final String[] NAMES = new String[]{"BITAND", "BITOR", "BITXOR", "BITNOT", "BITNAND", "BITNOR", "BITXNOR", "BITGET", "BITCOUNT", "LSHIFT", "RSHIFT", "ULSHIFT", "URSHIFT", "ROTATELEFT", "ROTATERIGHT"};
    private final int function;

    public BitFunction(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        switch (this.function) {
            case 7: {
                return BitFunction.bitGet(v1, v2);
            }
            case 8: {
                return BitFunction.bitCount(v1);
            }
            case 9: {
                return BitFunction.shift(v1, v2.getLong(), false);
            }
            case 10: {
                long offset = v2.getLong();
                return BitFunction.shift(v1, offset != Long.MIN_VALUE ? -offset : Long.MAX_VALUE, false);
            }
            case 11: {
                return BitFunction.shift(v1, v2.getLong(), true);
            }
            case 12: {
                return BitFunction.shift(v1, -v2.getLong(), true);
            }
            case 13: {
                return BitFunction.rotate(v1, v2.getLong(), false);
            }
            case 14: {
                return BitFunction.rotate(v1, v2.getLong(), true);
            }
        }
        return BitFunction.getBitwise(this.function, this.type, v1, v2);
    }

    private static ValueBoolean bitGet(Value v1, Value v2) {
        boolean b;
        block8: {
            block7: {
                long offset = v2.getLong();
                if (offset < 0L) break block7;
                switch (v1.getValueType()) {
                    case 5: 
                    case 6: {
                        byte[] bytes = v1.getBytesNoCopy();
                        int bit = (int)(offset & 7L);
                        b = (offset >>>= 3) < (long)bytes.length && (bytes[(int)offset] & 1 << bit) != 0;
                        break block8;
                    }
                    case 9: {
                        b = offset < 8L && (v1.getByte() & 1 << (int)offset) != 0;
                        break block8;
                    }
                    case 10: {
                        b = offset < 16L && (v1.getShort() & 1 << (int)offset) != 0;
                        break block8;
                    }
                    case 11: {
                        b = offset < 32L && (v1.getInt() & 1 << (int)offset) != 0;
                        break block8;
                    }
                    case 12: {
                        b = (v1.getLong() & 1L << (int)offset) != 0L;
                        break block8;
                    }
                    default: {
                        throw DbException.getInvalidValueException("bit function parameter", v1.getTraceSQL());
                    }
                }
            }
            b = false;
        }
        return ValueBoolean.get(b);
    }

    private static ValueBigint bitCount(Value v1) {
        long c;
        switch (v1.getValueType()) {
            case 5: 
            case 6: {
                int i;
                byte[] bytes = v1.getBytesNoCopy();
                int l = bytes.length;
                c = 0L;
                int blocks = l >>> 3;
                for (i = 0; i < blocks; ++i) {
                    c += (long)Long.bitCount(Bits.readLong(bytes, i));
                }
                for (i = blocks << 3; i < l; ++i) {
                    c += (long)Integer.bitCount(bytes[i] & 0xFF);
                }
                break;
            }
            case 9: {
                c = Integer.bitCount(v1.getByte() & 0xFF);
                break;
            }
            case 10: {
                c = Integer.bitCount(v1.getShort() & 0xFFFF);
                break;
            }
            case 11: {
                c = Integer.bitCount(v1.getInt());
                break;
            }
            case 12: {
                c = Long.bitCount(v1.getLong());
                break;
            }
            default: {
                throw DbException.getInvalidValueException("bit function parameter", v1.getTraceSQL());
            }
        }
        return ValueBigint.get(c);
    }

    private static Value shift(Value v1, long offset, boolean unsigned) {
        if (offset == 0L) {
            return v1;
        }
        int vt = v1.getValueType();
        switch (vt) {
            case 5: 
            case 6: {
                byte[] bytes = v1.getBytesNoCopy();
                int length = bytes.length;
                if (length == 0) {
                    return v1;
                }
                byte[] newBytes = new byte[length];
                if (offset > -8L * (long)length && offset < 8L * (long)length) {
                    if (offset > 0L) {
                        int nBytes = (int)(offset >> 3);
                        int nBits = (int)offset & 7;
                        if (nBits == 0) {
                            System.arraycopy(bytes, nBytes, newBytes, 0, length - nBytes);
                        } else {
                            int nBits2 = 8 - nBits;
                            int dstIndex = 0;
                            int srcIndex = nBytes;
                            --length;
                            while (srcIndex < length) {
                                newBytes[dstIndex++] = (byte)(bytes[srcIndex++] << nBits | (bytes[srcIndex] & 0xFF) >>> nBits2);
                            }
                            newBytes[dstIndex] = (byte)(bytes[srcIndex] << nBits);
                        }
                    } else {
                        offset = -offset;
                        int nBytes = (int)(offset >> 3);
                        int nBits = (int)offset & 7;
                        if (nBits == 0) {
                            System.arraycopy(bytes, 0, newBytes, nBytes, length - nBytes);
                        } else {
                            int nBits2 = 8 - nBits;
                            int dstIndex = nBytes;
                            int srcIndex = 0;
                            newBytes[dstIndex++] = (byte)((bytes[srcIndex] & 0xFF) >>> nBits);
                            while (dstIndex < length) {
                                newBytes[dstIndex++] = (byte)(bytes[srcIndex++] << nBits2 | (bytes[srcIndex] & 0xFF) >>> nBits);
                            }
                        }
                    }
                }
                return vt == 5 ? ValueBinary.getNoCopy(newBytes) : ValueVarbinary.getNoCopy(newBytes);
            }
            case 9: {
                byte v;
                if (offset < 8L) {
                    v = v1.getByte();
                    v = offset > -8L ? (offset > 0L ? (byte)(v << (int)offset) : (unsigned ? (byte)((v & 0xFF) >>> (int)(-offset)) : (byte)(v >> (int)(-offset)))) : (unsigned ? (byte)0 : (byte)(v >> 7));
                } else {
                    v = 0;
                }
                return ValueTinyint.get(v);
            }
            case 10: {
                short v;
                if (offset < 16L) {
                    v = v1.getShort();
                    v = offset > -16L ? (offset > 0L ? (short)(v << (int)offset) : (unsigned ? (short)((v & 0xFFFF) >>> (int)(-offset)) : (short)(v >> (int)(-offset)))) : (unsigned ? (short)0 : (short)(v >> 15));
                } else {
                    v = 0;
                }
                return ValueSmallint.get(v);
            }
            case 11: {
                int v;
                if (offset < 32L) {
                    v = v1.getInt();
                    v = offset > -32L ? (offset > 0L ? (v <<= (int)offset) : (unsigned ? (v >>>= (int)(-offset)) : (v >>= (int)(-offset)))) : (unsigned ? 0 : (v >>= 31));
                } else {
                    v = 0;
                }
                return ValueInteger.get(v);
            }
            case 12: {
                long v;
                if (offset < 64L) {
                    v = v1.getLong();
                    v = offset > -64L ? (offset > 0L ? (v <<= (int)offset) : (unsigned ? (v >>>= (int)(-offset)) : (v >>= (int)(-offset)))) : (unsigned ? 0L : (v >>= 63));
                } else {
                    v = 0L;
                }
                return ValueBigint.get(v);
            }
        }
        throw DbException.getInvalidValueException("bit function parameter", v1.getTraceSQL());
    }

    private static Value rotate(Value v1, long offset, boolean right) {
        int vt = v1.getValueType();
        switch (vt) {
            case 5: 
            case 6: {
                byte[] bytes = v1.getBytesNoCopy();
                int length = bytes.length;
                if (length == 0) {
                    return v1;
                }
                long bitLength = length << 3;
                offset %= bitLength;
                if (right) {
                    offset = -offset;
                }
                if (offset == 0L) {
                    return v1;
                }
                if (offset < 0L) {
                    offset += bitLength;
                }
                byte[] newBytes = new byte[length];
                int nBytes = (int)(offset >> 3);
                int nBits = (int)offset & 7;
                if (nBits == 0) {
                    System.arraycopy(bytes, nBytes, newBytes, 0, length - nBytes);
                    System.arraycopy(bytes, 0, newBytes, length - nBytes, nBytes);
                } else {
                    int nBits2 = 8 - nBits;
                    int dstIndex = 0;
                    int srcIndex = nBytes;
                    while (dstIndex < length) {
                        int n = dstIndex++;
                        int n2 = bytes[srcIndex] << nBits;
                        srcIndex = (srcIndex + 1) % length;
                        newBytes[n] = (byte)(n2 | (bytes[srcIndex] & 0xFF) >>> nBits2);
                    }
                }
                return vt == 5 ? ValueBinary.getNoCopy(newBytes) : ValueVarbinary.getNoCopy(newBytes);
            }
            case 9: {
                int o = (int)offset;
                if (right) {
                    o = -o;
                }
                if ((o &= 7) == 0) {
                    return v1;
                }
                int v = v1.getByte() & 0xFF;
                return ValueTinyint.get((byte)(v << o | v >>> 8 - o));
            }
            case 10: {
                int o = (int)offset;
                if (right) {
                    o = -o;
                }
                if ((o &= 0xF) == 0) {
                    return v1;
                }
                int v = v1.getShort() & 0xFFFF;
                return ValueSmallint.get((short)(v << o | v >>> 16 - o));
            }
            case 11: {
                int o = (int)offset;
                if (right) {
                    o = -o;
                }
                if ((o &= 0x1F) == 0) {
                    return v1;
                }
                return ValueInteger.get(Integer.rotateLeft(v1.getInt(), o));
            }
            case 12: {
                int o = (int)offset;
                if (right) {
                    o = -o;
                }
                if ((o &= 0x3F) == 0) {
                    return v1;
                }
                return ValueBigint.get(Long.rotateLeft(v1.getLong(), o));
            }
        }
        throw DbException.getInvalidValueException("bit function parameter", v1.getTraceSQL());
    }

    public static Value getBitwise(int function, TypeInfo type, Value v1, Value v2) {
        return type.getValueType() < 9 ? BitFunction.getBinaryString(function, type, v1, v2) : BitFunction.getNumeric(function, type, v1, v2);
    }

    private static Value getBinaryString(int function, TypeInfo type, Value v1, Value v2) {
        byte[] bytes;
        if (function == 3) {
            bytes = v1.getBytes();
            int l = bytes.length;
            for (int i = 0; i < l; ++i) {
                bytes[i] = ~bytes[i];
            }
        } else {
            int max;
            int min;
            byte[] bytes2;
            int length2;
            byte[] bytes1 = v1.getBytesNoCopy();
            int length1 = bytes1.length;
            if (length1 <= (length2 = (bytes2 = v2.getBytesNoCopy()).length)) {
                min = length1;
                max = length2;
            } else {
                min = length2;
                max = length1;
                byte[] t = bytes1;
                bytes1 = bytes2;
                bytes2 = t;
            }
            int limit = (int)type.getPrecision();
            if (min > limit) {
                max = min = limit;
            } else if (max > limit) {
                max = limit;
            }
            bytes = new byte[max];
            switch (function) {
                case 0: {
                    int i;
                    for (i = 0; i < min; ++i) {
                        bytes[i] = (byte)(bytes1[i] & bytes2[i]);
                    }
                    break;
                }
                case 1: {
                    int i;
                    while (i < min) {
                        bytes[i] = (byte)(bytes1[i] | bytes2[i]);
                        ++i;
                    }
                    System.arraycopy(bytes2, i, bytes, i, max - i);
                    break;
                }
                case 2: {
                    int i;
                    while (i < min) {
                        bytes[i] = (byte)(bytes1[i] ^ bytes2[i]);
                        ++i;
                    }
                    System.arraycopy(bytes2, i, bytes, i, max - i);
                    break;
                }
                case 4: {
                    int i;
                    while (i < min) {
                        bytes[i] = (byte)(~(bytes1[i] & bytes2[i]));
                        ++i;
                    }
                    Arrays.fill(bytes, i, max, (byte)-1);
                    break;
                }
                case 5: {
                    int i;
                    while (i < min) {
                        bytes[i] = (byte)(~(bytes1[i] | bytes2[i]));
                        ++i;
                    }
                    while (i < max) {
                        bytes[i] = ~bytes2[i];
                        ++i;
                    }
                    break;
                }
                case 6: {
                    int i;
                    while (i < min) {
                        bytes[i] = (byte)(~(bytes1[i] ^ bytes2[i]));
                        ++i;
                    }
                    while (i < max) {
                        bytes[i] = ~bytes2[i];
                        ++i;
                    }
                    break;
                }
                default: {
                    throw DbException.getInternalError("function=" + function);
                }
            }
        }
        return type.getValueType() == 5 ? ValueBinary.getNoCopy(bytes) : ValueVarbinary.getNoCopy(bytes);
    }

    private static Value getNumeric(int function, TypeInfo type, Value v1, Value v2) {
        long l1 = v1.getLong();
        switch (function) {
            case 0: {
                l1 &= v2.getLong();
                break;
            }
            case 1: {
                l1 |= v2.getLong();
                break;
            }
            case 2: {
                l1 ^= v2.getLong();
                break;
            }
            case 3: {
                l1 ^= 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 4: {
                l1 = l1 & v2.getLong() ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 5: {
                l1 = (l1 | v2.getLong()) ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 6: {
                l1 = l1 ^ v2.getLong() ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + function);
            }
        }
        switch (type.getValueType()) {
            case 9: {
                return ValueTinyint.get((byte)l1);
            }
            case 10: {
                return ValueSmallint.get((short)l1);
            }
            case 11: {
                return ValueInteger.get((int)l1);
            }
            case 12: {
                return ValueBigint.get(l1);
            }
        }
        throw DbException.getInternalError();
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 3: {
                return this.optimizeNot(session);
            }
            case 7: {
                this.type = TypeInfo.TYPE_BOOLEAN;
                break;
            }
            case 8: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.type = BitFunction.checkArgType(this.left);
                break;
            }
            default: {
                this.type = BitFunction.getCommonType(this.left, this.right);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    private Expression optimizeNot(SessionLocal session) {
        this.type = BitFunction.checkArgType(this.left);
        if (this.left.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        if (this.left instanceof BitFunction) {
            BitFunction l = (BitFunction)this.left;
            int f = l.function;
            switch (f) {
                case 0: 
                case 1: 
                case 2: {
                    f += 4;
                    break;
                }
                case 3: {
                    return l.left;
                }
                case 4: 
                case 5: 
                case 6: {
                    f -= 4;
                    break;
                }
                default: {
                    return this;
                }
            }
            return new BitFunction(l.left, l.right, f).optimize(session);
        }
        if (this.left instanceof Aggregate) {
            AggregateType t;
            Aggregate l = (Aggregate)this.left;
            switch (l.getAggregateType()) {
                case BIT_AND_AGG: {
                    t = AggregateType.BIT_NAND_AGG;
                    break;
                }
                case BIT_OR_AGG: {
                    t = AggregateType.BIT_NOR_AGG;
                    break;
                }
                case BIT_XOR_AGG: {
                    t = AggregateType.BIT_XNOR_AGG;
                    break;
                }
                case BIT_NAND_AGG: {
                    t = AggregateType.BIT_AND_AGG;
                    break;
                }
                case BIT_NOR_AGG: {
                    t = AggregateType.BIT_OR_AGG;
                    break;
                }
                case BIT_XNOR_AGG: {
                    t = AggregateType.BIT_XOR_AGG;
                    break;
                }
                default: {
                    return this;
                }
            }
            Aggregate aggregate = new Aggregate(t, new Expression[]{l.getSubexpression(0)}, l.getSelect(), l.isDistinct());
            aggregate.setFilterCondition(l.getFilterCondition());
            aggregate.setOverCondition(l.getOverCondition());
            return aggregate.optimize(session);
        }
        return this;
    }

    private static TypeInfo getCommonType(Expression arg1, Expression arg2) {
        TypeInfo t1 = BitFunction.checkArgType(arg1);
        TypeInfo t2 = BitFunction.checkArgType(arg2);
        int vt1 = t1.getValueType();
        int vt2 = t2.getValueType();
        boolean bs = DataType.isBinaryStringType(vt1);
        if (bs != DataType.isBinaryStringType(vt2)) {
            throw DbException.getInvalidValueException("bit function parameters", t2.getSQL(t1.getSQL(new StringBuilder(), 3).append(" vs "), 3).toString());
        }
        if (bs) {
            long precision;
            if (vt1 == 5) {
                precision = t1.getDeclaredPrecision();
                if (vt2 == 5) {
                    precision = Math.max(precision, t2.getDeclaredPrecision());
                }
            } else if (vt2 == 5) {
                vt1 = 5;
                precision = t2.getDeclaredPrecision();
            } else {
                long precision1 = t1.getDeclaredPrecision();
                long precision2 = t2.getDeclaredPrecision();
                precision = precision1 <= 0L || precision2 <= 0L ? -1L : Math.max(precision1, precision2);
            }
            return TypeInfo.getTypeInfo(vt1, precision, 0, null);
        }
        return TypeInfo.getTypeInfo(Math.max(vt1, vt2));
    }

    public static TypeInfo checkArgType(Expression arg) {
        TypeInfo t = arg.getType();
        switch (t.getValueType()) {
            case 0: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return t;
            }
        }
        throw Store.getInvalidExpressionTypeException("bit function argument", arg);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

