/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class CoalesceFunction
extends FunctionN {
    public static final int COALESCE = 0;
    public static final int GREATEST = 1;
    public static final int LEAST = 2;
    private static final String[] NAMES = new String[]{"COALESCE", "GREATEST", "LEAST"};
    private final int function;

    public CoalesceFunction(int function) {
        this(function, new Expression[4]);
    }

    public CoalesceFunction(int function, Expression ... args) {
        super(args);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v = ValueNull.INSTANCE;
        block0 : switch (this.function) {
            case 0: {
                int l = this.args.length;
                for (int i = 0; i < l; ++i) {
                    Value v2 = this.args[i].getValue(session);
                    if (v2 == ValueNull.INSTANCE) continue;
                    v = v2.convertTo(this.type, (CastDataProvider)session);
                    break block0;
                }
                break;
            }
            case 1: 
            case 2: {
                int l = this.args.length;
                for (int i = 0; i < l; ++i) {
                    Value v2 = this.args[i].getValue(session);
                    if (v2 == ValueNull.INSTANCE) continue;
                    v2 = v2.convertTo(this.type, (CastDataProvider)session);
                    if (v == ValueNull.INSTANCE) {
                        v = v2;
                        continue;
                    }
                    int comp = session.compareTypeSafe(v, v2);
                    if (this.function == 1) {
                        if (comp >= 0) continue;
                        v = v2;
                        continue;
                    }
                    if (comp <= 0) continue;
                    v = v2;
                }
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        this.type = TypeInfo.getHigherType(this.args);
        if (this.type.getValueType() <= 0) {
            this.type = TypeInfo.TYPE_VARCHAR;
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

