/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.util.MathUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarbinary;

public final class CryptFunction
extends FunctionN {
    public static final int ENCRYPT = 0;
    public static final int DECRYPT = 1;
    private static final String[] NAMES = new String[]{"ENCRYPT", "DECRYPT"};
    private final int function;

    public CryptFunction(Expression arg1, Expression arg2, Expression arg3, int function) {
        super(new Expression[]{arg1, arg2, arg3});
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        BlockCipher cipher = CipherFactory.getBlockCipher(v1.getString());
        cipher.setKey(CryptFunction.getPaddedArrayCopy(v2.getBytesNoCopy(), cipher.getKeyLength()));
        byte[] newData = CryptFunction.getPaddedArrayCopy(v3.getBytesNoCopy(), 16);
        switch (this.function) {
            case 0: {
                cipher.encrypt(newData, 0, newData.length);
                break;
            }
            case 1: {
                cipher.decrypt(newData, 0, newData.length);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return ValueVarbinary.getNoCopy(newData);
    }

    private static byte[] getPaddedArrayCopy(byte[] data, int blockSize) {
        return Utils.copyBytes(data, MathUtils.roundUpInt(data.length, blockSize));
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        TypeInfo t = this.args[2].getType();
        TypeInfo typeInfo = this.type = DataType.isBinaryStringType(t.getValueType()) ? TypeInfo.getTypeInfo(6, t.getPrecision(), 0, null) : TypeInfo.TYPE_VARBINARY;
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

