/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.util.JSR310Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarchar;

public final class DateTimeFormatFunction
extends FunctionN {
    public static final int FORMATDATETIME = 0;
    public static final int PARSEDATETIME = 1;
    private static final String[] NAMES = new String[]{"FORMATDATETIME", "PARSEDATETIME"};
    private static final LinkedHashMap<CacheKey, CacheValue> CACHE = new LinkedHashMap<CacheKey, CacheValue>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, CacheValue> eldest) {
            return this.size() > 100;
        }
    };
    private final int function;

    public DateTimeFormatFunction(int function) {
        super(new Expression[4]);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        String tz;
        String locale;
        String format = v2.getString();
        if (v3 != null) {
            locale = v3.getString();
            tz = this.args.length > 3 ? this.args[3].getValue(session).getString() : null;
        } else {
            locale = null;
            tz = null;
        }
        switch (this.function) {
            case 0: {
                v1 = ValueVarchar.get(DateTimeFormatFunction.formatDateTime(session, v1, format, locale, tz));
                break;
            }
            case 1: {
                v1 = DateTimeFormatFunction.parseDateTime(session, v1.getString(), format, locale, tz);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    public static String formatDateTime(SessionLocal session, Value date, String format, String locale, String timeZone) {
        ZonedDateTime value;
        CacheValue formatAndZone = DateTimeFormatFunction.getDateFormat(format, locale, timeZone);
        ZoneId zoneId = formatAndZone.zoneId;
        if (date instanceof ValueTimestampTimeZone) {
            ZoneOffset offset;
            OffsetDateTime dateTime = JSR310Utils.valueToOffsetDateTime(date, session);
            ZoneId zoneToSet = zoneId != null ? zoneId : ZoneId.ofOffset((offset = dateTime.getOffset()).getTotalSeconds() == 0 ? "UTC" : "GMT", offset);
            value = dateTime.atZoneSameInstant(zoneToSet);
        } else {
            LocalDateTime dateTime = JSR310Utils.valueToLocalDateTime(date, session);
            value = dateTime.atZone(zoneId != null ? zoneId : ZoneId.of(session.currentTimeZone().getId()));
        }
        return formatAndZone.formatter.format(value);
    }

    public static ValueTimestampTimeZone parseDateTime(SessionLocal session, String date, String format, String locale, String timeZone) {
        CacheValue formatAndZone = DateTimeFormatFunction.getDateFormat(format, locale, timeZone);
        try {
            ValueTimestampTimeZone result;
            TemporalAccessor parsed = formatAndZone.formatter.parse(date);
            ZoneId parsedZoneId = parsed.query(TemporalQueries.zoneId());
            if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
                result = JSR310Utils.offsetDateTimeToValue(OffsetDateTime.from(parsed));
            } else if (parsed.isSupported(ChronoField.INSTANT_SECONDS)) {
                Instant instant = Instant.from(parsed);
                if (parsedZoneId == null) {
                    parsedZoneId = formatAndZone.zoneId;
                }
                result = parsedZoneId != null ? JSR310Utils.zonedDateTimeToValue(instant.atZone(parsedZoneId)) : JSR310Utils.offsetDateTimeToValue(instant.atOffset(ZoneOffset.ofTotalSeconds(session.currentTimeZone().getTimeZoneOffsetUTC(instant.getEpochSecond()))));
            } else {
                LocalDate localDate = parsed.query(TemporalQueries.localDate());
                LocalTime localTime = parsed.query(TemporalQueries.localTime());
                if (parsedZoneId == null) {
                    parsedZoneId = formatAndZone.zoneId;
                }
                if (localDate != null) {
                    LocalDateTime localDateTime = localTime != null ? LocalDateTime.of(localDate, localTime) : localDate.atStartOfDay();
                    result = parsedZoneId != null ? JSR310Utils.zonedDateTimeToValue(localDateTime.atZone(parsedZoneId)) : (ValueTimestampTimeZone)JSR310Utils.localDateTimeToValue(localDateTime).convertTo(21, (CastDataProvider)session);
                } else {
                    result = parsedZoneId != null ? JSR310Utils.zonedDateTimeToValue(JSR310Utils.valueToInstant(session.currentTimestamp(), session).atZone(parsedZoneId).with(localTime)) : (ValueTimestampTimeZone)ValueTime.fromNanos(localTime.toNanoOfDay()).convertTo(21, (CastDataProvider)session);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            throw DbException.get(90014, e, date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheValue getDateFormat(String format, String locale, String timeZone) {
        Exception ex = null;
        if (format.length() <= 100) {
            try {
                CacheValue value;
                CacheKey key = new CacheKey(format, locale, timeZone);
                LinkedHashMap<CacheKey, CacheValue> linkedHashMap = CACHE;
                synchronized (linkedHashMap) {
                    value = CACHE.get(key);
                    if (value == null) {
                        ZoneId zoneId;
                        DateTimeFormatter df = locale == null ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ofPattern(format, new Locale(locale));
                        if (timeZone != null) {
                            zoneId = DateTimeFormatFunction.getZoneId(timeZone);
                            df = df.withZone(zoneId);
                        } else {
                            zoneId = null;
                        }
                        value = new CacheValue(df, zoneId);
                        CACHE.put(key, value);
                    }
                }
                return value;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        throw DbException.get(90014, ex, format + '/' + locale);
    }

    private static ZoneId getZoneId(String timeZone) {
        try {
            return ZoneId.of(timeZone, ZoneId.SHORT_IDS);
        }
        catch (RuntimeException e) {
            throw DbException.getInvalidValueException("TIME ZONE", timeZone);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_TIMESTAMP_TZ;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }

    private static final class CacheValue {
        final DateTimeFormatter formatter;
        final ZoneId zoneId;

        CacheValue(DateTimeFormatter formatter, ZoneId zoneId) {
            this.formatter = formatter;
            this.zoneId = zoneId;
        }
    }

    private static final class CacheKey {
        private final String format;
        private final String locale;
        private final String timeZone;

        CacheKey(String format, String locale, String timeZone) {
            this.format = format;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.format.hashCode();
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.format.equals(other.format) && Objects.equals(this.locale, other.locale) && Objects.equals(this.timeZone, other.timeZone);
        }
    }
}

