/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;

public final class FileFunction
extends Function1_2 {
    public static final int FILE_READ = 0;
    public static final int FILE_WRITE = 1;
    private static final String[] NAMES = new String[]{"FILE_READ", "FILE_WRITE"};
    private final int function;

    public FileFunction(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Value getValue(SessionLocal session) {
        session.getUser().checkAdmin();
        v1 = this.left.getValue(session);
        if (v1 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (this.function) {
            case 0: {
                fileName = v1.getString();
                database = session.getDatabase();
                try {
                    fileLength = FileUtils.size(fileName);
                    in = FileUtils.newInputStream(fileName);
                    var9_13 = null;
                    try {
                        if (this.right == null) {
                            lob /* !! */  = database.getLobStorage().createBlob(in, fileLength);
                        } else {
                            v2 = this.right.getValue(session);
                            reader = v2 == ValueNull.INSTANCE ? new InputStreamReader(in) : new InputStreamReader(in, v2.getString());
                            lob /* !! */  = database.getLobStorage().createClob(reader, fileLength);
                        }
                    }
                    catch (Throwable var10_22) {
                        var9_13 = var10_22;
                        throw var10_22;
                    }
                    finally {
                        if (in != null) {
                            if (var9_13 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable var10_21) {
                                    var9_13.addSuppressed(var10_21);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                    v1 = session.addTemporaryLob(lob /* !! */ );
                    break;
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            case 1: {
                v2 = this.right.getValue(session);
                if (v2 == ValueNull.INSTANCE) {
                    v1 = ValueNull.INSTANCE;
                    break;
                }
                fileName = v2.getString();
                try {
                    fileOutputStream = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                    var6_26 = null;
                    in = v1.getInputStream();
                    var8_12 = null;
                    try {
                        v1 = ValueBigint.get(IOUtils.copy(in, fileOutputStream));
                    }
                    catch (Throwable var9_15) {
                        var8_12 = var9_15;
                        throw var9_15;
                    }
                    finally {
                        if (in != null) {
                            if (var8_12 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable var9_14) {
                                    var8_12.addSuppressed(var9_14);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                    if (fileOutputStream == null) break;
                    if (var6_26 == null) ** GOTO lbl76
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable var7_18) {
                        var6_26.addSuppressed(var7_18);
                    }
                    break;
lbl76:
                    // 1 sources

                    fileOutputStream.close();
                    ** break;
                    catch (Throwable var7_19) {
                        try {
                            var6_26 = var7_19;
                            throw var7_19;
                        }
                        catch (Throwable var16_29) {
                            if (fileOutputStream != null) {
                                if (var6_26 != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (Throwable var17_30) {
                                        var6_26.addSuppressed(var17_30);
                                    }
                                } else {
                                    fileOutputStream.close();
                                }
                            }
                            throw var16_29;
lbl93:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = this.right == null ? TypeInfo.getTypeInfo(7, Integer.MAX_VALUE, 0, null) : TypeInfo.getTypeInfo(3, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: 
            case 8: {
                return false;
            }
            case 5: {
                if (this.function != 1) break;
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

