/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.NamedExpression;
import org.h2.message.DbException;
import org.h2.schema.FunctionAlias;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class JavaFunction
extends Expression
implements NamedExpression {
    private final FunctionAlias functionAlias;
    private final FunctionAlias.JavaMethod javaMethod;
    private final Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] args) {
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(args);
        if (this.javaMethod.getDataType() == null) {
            throw DbException.get(90022, this.getName());
        }
        this.args = args;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.javaMethod.getValue(session, this.args, false);
    }

    @Override
    public TypeInfo getType() {
        return this.javaMethod.getDataType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.args) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.functionAlias.isDeterministic();
        int len = this.args.length;
        for (int i = 0; i < len; ++i) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            allConst &= e.isConstant();
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return JavaFunction.writeExpressions(this.functionAlias.getSQL(builder, sqlFlags).append('('), this.args, sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public String getName() {
        return this.functionAlias.getName();
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                if (this.functionAlias.isDeterministic()) break;
                return false;
            }
            case 7: {
                visitor.addDependency(this.functionAlias);
                break;
            }
        }
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.javaMethod.hasConnectionParam() ? 25 : 5;
        for (Expression e : this.args) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }
}

