/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.ByteArrayOutputStream;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionWithFlags;
import org.h2.expression.Format;
import org.h2.expression.OperationN;
import org.h2.expression.Subquery;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.NamedExpression;
import org.h2.message.DbException;
import org.h2.util.json.JsonConstructorUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;

public final class JsonConstructorFunction
extends OperationN
implements ExpressionWithFlags,
NamedExpression {
    private final boolean array;
    private int flags;

    public JsonConstructorFunction(boolean array) {
        super(new Expression[4]);
        this.array = array;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.array ? this.jsonArray(session, this.args) : this.jsonObject(session, this.args);
    }

    private Value jsonObject(SessionLocal session, Expression[] args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(123);
        int i = 0;
        int l = args.length;
        while (i < l) {
            Value value;
            String name;
            if ((name = args[i++].getValue(session).getString()) == null) {
                throw DbException.getInvalidValueException("JSON_OBJECT key", "NULL");
            }
            if ((value = args[i++].getValue(session)) == ValueNull.INSTANCE) {
                if ((this.flags & 1) != 0) continue;
                value = ValueJson.NULL;
            }
            JsonConstructorUtils.jsonObjectAppend(baos, name, value);
        }
        return JsonConstructorUtils.jsonObjectFinish(baos, this.flags);
    }

    /*
     * Unable to fully structure code
     */
    private Value jsonArray(SessionLocal session, Expression[] args) {
        baos = new ByteArrayOutputStream();
        baos.write(91);
        l = args.length;
        if (l != 1) ** GOTO lbl-1000
        arg0 = args[0];
        if (arg0 instanceof Subquery) {
            q = (Subquery)arg0;
            for (Value value : q.getAllRows(session)) {
                JsonConstructorUtils.jsonArrayAppend(baos, value, this.flags);
            }
        } else if (arg0 instanceof Format && (arg0 = (format = (Format)arg0).getSubexpression(0)) instanceof Subquery) {
            q = (Subquery)arg0;
            for (Value value : q.getAllRows(session)) {
                JsonConstructorUtils.jsonArrayAppend(baos, format.getValue(value), this.flags);
            }
        } else lbl-1000:
        // 2 sources

        {
            i = 0;
            while (i < l) {
                JsonConstructorUtils.jsonArrayAppend(baos, args[i++].getValue(session), this.flags);
            }
        }
        baos.write(93);
        return ValueJson.getInternal(baos.toByteArray());
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        this.type = TypeInfo.TYPE_JSON;
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.getName()).append('(');
        if (this.array) {
            JsonConstructorFunction.writeExpressions(builder, this.args, sqlFlags);
        } else {
            int i = 0;
            int l = this.args.length;
            while (i < l) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.args[i++].getUnenclosedSQL(builder, sqlFlags).append(": ");
                this.args[i++].getUnenclosedSQL(builder, sqlFlags);
            }
        }
        return JsonConstructorFunction.getJsonFunctionFlagsSQL(builder, this.flags, this.array).append(')');
    }

    public static StringBuilder getJsonFunctionFlagsSQL(StringBuilder builder, int flags, boolean forArray) {
        if ((flags & 1) != 0) {
            if (!forArray) {
                builder.append(" ABSENT ON NULL");
            }
        } else if (forArray) {
            builder.append(" NULL ON NULL");
        }
        if (!forArray && (flags & 2) != 0) {
            builder.append(" WITH UNIQUE KEYS");
        }
        return builder;
    }

    @Override
    public String getName() {
        return this.array ? "JSON_ARRAY" : "JSON_OBJECT";
    }
}

