/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function2;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDouble;

public final class MathFunction2
extends Function2 {
    public static final int ATAN2 = 0;
    public static final int LOG = 1;
    public static final int POWER = 2;
    private static final String[] NAMES = new String[]{"ATAN2", "LOG", "POWER"};
    private final int function;

    public MathFunction2(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        double d1 = v1.getDouble();
        double d2 = v2.getDouble();
        switch (this.function) {
            case 0: {
                d1 = Math.atan2(d1, d2);
                break;
            }
            case 1: {
                if (session.getMode().swapLogFunctionParameters) {
                    double t = d2;
                    d2 = d1;
                    d1 = t;
                }
                if (d2 <= 0.0) {
                    throw DbException.getInvalidValueException("LOG() argument", d2);
                }
                if (d1 <= 0.0 || d1 == 1.0) {
                    throw DbException.getInvalidValueException("LOG() base", d1);
                }
                if (d1 == Math.E) {
                    d1 = Math.log(d2);
                    break;
                }
                if (d1 == 10.0) {
                    d1 = Math.log10(d2);
                    break;
                }
                d1 = Math.log(d2) / Math.log(d1);
                break;
            }
            case 2: {
                d1 = Math.pow(d1, d2);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return ValueDouble.get(d1);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        this.type = TypeInfo.TYPE_DOUBLE;
        if (this.left.isConstant() && this.right.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

