/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Variable;
import org.h2.expression.function.Function2;
import org.h2.message.DbException;
import org.h2.value.Value;

public final class SetFunction
extends Function2 {
    public SetFunction(Expression arg1, Expression arg2) {
        super(arg1, arg2);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Variable var = (Variable)this.left;
        Value v = this.right.getValue(session);
        session.setVariable(var.getName(), v);
        return v;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        this.type = this.right.getType();
        if (!(this.left instanceof Variable)) {
            throw DbException.get(90137, this.left.getTraceSQL());
        }
        return this;
    }

    @Override
    public String getName() {
        return "SET";
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return false;
            }
        }
        return true;
    }
}

