/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.nio.charset.StandardCharsets;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueVarchar;

public final class SoundexFunction
extends Function1_2 {
    public static final int SOUNDEX = 0;
    public static final int DIFFERENCE = 1;
    private static final String[] NAMES = new String[]{"SOUNDEX", "DIFFERENCE"};
    private static final byte[] SOUNDEX_INDEX = "71237128722455712623718272\u0000\u0000\u0000\u0000\u0000\u000071237128722455712623718272".getBytes(StandardCharsets.ISO_8859_1);
    private final int function;

    public SoundexFunction(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        switch (this.function) {
            case 0: {
                v1 = ValueVarchar.get(new String(SoundexFunction.getSoundex(v1.getString()), StandardCharsets.ISO_8859_1), session);
                break;
            }
            case 1: {
                v1 = ValueInteger.get(SoundexFunction.getDifference(v1.getString(), v2.getString()));
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    private static int getDifference(String s1, String s2) {
        byte[] b1 = SoundexFunction.getSoundex(s1);
        byte[] b2 = SoundexFunction.getSoundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (b1[i] != b2[i]) continue;
            ++e;
        }
        return e;
    }

    private static byte[] getSoundex(String s) {
        byte[] chars = new byte[]{48, 48, 48, 48};
        byte lastDigit = 48;
        int j = 0;
        int l = s.length();
        for (int i = 0; i < l && j < 4; ++i) {
            byte newDigit;
            char c = s.charAt(i);
            if (c < 'A' || c > 'z' || (newDigit = SOUNDEX_INDEX[c - 65]) == 0) continue;
            if (j == 0) {
                chars[j++] = (byte)c;
                lastDigit = newDigit;
                continue;
            }
            if (newDigit <= 54) {
                if (newDigit == lastDigit) continue;
                chars[j++] = lastDigit = newDigit;
                continue;
            }
            if (newDigit != 55) continue;
            lastDigit = newDigit;
        }
        return chars;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.getTypeInfo(2, 4L, 0, null);
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_INTEGER;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

