/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function2;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

public final class StringFunction2
extends Function2 {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int REPEAT = 2;
    private static final String[] NAMES = new String[]{"LEFT", "RIGHT", "REPEAT"};
    private final int function;

    public StringFunction2(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        String s = v1.getString();
        int count = v2.getInt();
        if (count <= 0) {
            return ValueVarchar.get("", session);
        }
        int length = s.length();
        switch (this.function) {
            case 0: {
                if (count > length) {
                    count = length;
                }
                s = s.substring(0, count);
                break;
            }
            case 1: {
                if (count > length) {
                    count = length;
                }
                s = s.substring(length - count);
                break;
            }
            case 2: {
                StringBuilder builder = new StringBuilder(length * count);
                while (count-- > 0) {
                    builder.append(s);
                }
                s = builder.toString();
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return ValueVarchar.get(s, session);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        switch (this.function) {
            case 0: 
            case 1: {
                this.type = TypeInfo.getTypeInfo(2, this.left.getType().getPrecision(), 0, null);
                break;
            }
            case 2: {
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

