/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.Constants;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Operation0;
import org.h2.expression.function.NamedExpression;
import org.h2.message.DbException;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

public final class SysInfoFunction
extends Operation0
implements NamedExpression {
    public static final int AUTOCOMMIT = 0;
    public static final int DATABASE_PATH = 1;
    public static final int H2VERSION = 2;
    public static final int LOCK_MODE = 3;
    public static final int LOCK_TIMEOUT = 4;
    public static final int MEMORY_FREE = 5;
    public static final int MEMORY_USED = 6;
    public static final int READONLY = 7;
    public static final int SESSION_ID = 8;
    public static final int TRANSACTION_ID = 9;
    private static final int[] TYPES = new int[]{8, 2, 2, 11, 11, 12, 12, 8, 11, 2};
    private static final String[] NAMES = new String[]{"AUTOCOMMIT", "DATABASE_PATH", "H2VERSION", "LOCK_MODE", "LOCK_TIMEOUT", "MEMORY_FREE", "MEMORY_USED", "READONLY", "SESSION_ID", "TRANSACTION_ID"};
    private final int function;
    private final TypeInfo type;

    public static String getName(int function) {
        return NAMES[function];
    }

    public SysInfoFunction(int function) {
        this.function = function;
        this.type = TypeInfo.getTypeInfo(TYPES[function]);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value result;
        switch (this.function) {
            case 0: {
                result = ValueBoolean.get(session.getAutoCommit());
                break;
            }
            case 1: {
                String path = session.getDatabase().getDatabasePath();
                result = path != null ? ValueVarchar.get(path, session) : ValueNull.INSTANCE;
                break;
            }
            case 2: {
                result = ValueVarchar.get(Constants.VERSION, session);
                break;
            }
            case 3: {
                result = ValueInteger.get(session.getDatabase().getLockMode());
                break;
            }
            case 4: {
                result = ValueInteger.get(session.getLockTimeout());
                break;
            }
            case 5: {
                session.getUser().checkAdmin();
                result = ValueBigint.get(Utils.getMemoryFree());
                break;
            }
            case 6: {
                session.getUser().checkAdmin();
                result = ValueBigint.get(Utils.getMemoryUsed());
                break;
            }
            case 7: {
                result = ValueBoolean.get(session.getDatabase().isReadOnly());
                break;
            }
            case 8: {
                result = ValueInteger.get(session.getId());
                break;
            }
            case 9: {
                result = session.getTransactionId();
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return result;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.getName()).append("()");
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

