/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Typed;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Index
extends SchemaObject {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected final int uniqueColumnColumn;
    protected final Table table;
    protected final IndexType indexType;
    private final RowFactory rowFactory;
    private final RowFactory uniqueRowFactory;

    protected static void checkIndexColumnTypes(IndexColumn[] columns) {
        for (IndexColumn c : columns) {
            if (DataType.isIndexable(c.column.getType())) continue;
            throw DbException.getUnsupportedException("Index on column: " + c.column.getCreateSQL());
        }
    }

    protected Index(Table newTable, int id, String name, IndexColumn[] newIndexColumns, int uniqueColumnCount, IndexType newIndexType) {
        super(newTable.getSchema(), id, name, 5);
        this.uniqueColumnColumn = uniqueColumnCount;
        this.indexType = newIndexType;
        this.table = newTable;
        if (newIndexColumns != null) {
            this.indexColumns = newIndexColumns;
            this.columns = new Column[newIndexColumns.length];
            int len = this.columns.length;
            this.columnIds = new int[len];
            for (int i = 0; i < len; ++i) {
                Column col;
                this.columns[i] = col = newIndexColumns[i].column;
                this.columnIds[i] = col.getColumnId();
            }
        }
        RowFactory databaseRowFactory = this.database.getRowFactory();
        CompareMode compareMode = this.database.getCompareMode();
        Typed[] tableColumns = this.table.getColumns();
        this.rowFactory = databaseRowFactory.createRowFactory(this.database, compareMode, this.database, tableColumns, newIndexType.isScan() ? null : newIndexColumns, true);
        RowFactory uniqueRowFactory = uniqueColumnCount > 0 ? (newIndexColumns == null || uniqueColumnCount == newIndexColumns.length ? this.rowFactory : databaseRowFactory.createRowFactory(this.database, compareMode, this.database, tableColumns, Arrays.copyOf(newIndexColumns, uniqueColumnCount), true)) : null;
        this.uniqueRowFactory = uniqueRowFactory;
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public final boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public String getCreateSQLForCopy(Table targetTable, String quotedName) {
        StringBuilder builder = new StringBuilder("CREATE ");
        builder.append(this.indexType.getSQL());
        builder.append(' ');
        if (this.table.isHidden()) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(quotedName);
        builder.append(" ON ");
        targetTable.getSQL(builder, 0);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        return this.getColumnListSQL(builder, 0).toString();
    }

    private StringBuilder getColumnListSQL(StringBuilder builder, int sqlFlags) {
        builder.append('(');
        int length = this.indexColumns.length;
        if (this.uniqueColumnColumn > 0 && this.uniqueColumnColumn < length) {
            IndexColumn.writeColumns(builder, this.indexColumns, 0, this.uniqueColumnColumn, sqlFlags).append(") INCLUDE(");
            IndexColumn.writeColumns(builder, this.indexColumns, this.uniqueColumnColumn, length, sqlFlags);
        } else {
            IndexColumn.writeColumns(builder, this.indexColumns, 0, length, sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(0));
    }

    public String getPlanSQL() {
        return this.getSQL(11);
    }

    public abstract void close(SessionLocal var1);

    public abstract void add(SessionLocal var1, Row var2);

    public abstract void remove(SessionLocal var1, Row var2);

    public void update(SessionLocal session, Row oldRow, Row newRow) {
        this.remove(session, oldRow);
        this.add(session, newRow);
    }

    public boolean isFindUsingFullTableScan() {
        return false;
    }

    public abstract Cursor find(SessionLocal var1, SearchRow var2, SearchRow var3);

    public abstract double getCost(SessionLocal var1, int[] var2, TableFilter[] var3, int var4, SortOrder var5, AllColumnsForPlan var6);

    public abstract void remove(SessionLocal var1);

    public abstract void truncate(SessionLocal var1);

    public boolean canGetFirstOrLast() {
        return false;
    }

    public boolean canFindNext() {
        return false;
    }

    public Cursor findNext(SessionLocal session, SearchRow higherThan, SearchRow last) {
        throw DbException.getInternalError(this.toString());
    }

    public Cursor findFirstOrLast(SessionLocal session, boolean first) {
        throw DbException.getInternalError(this.toString());
    }

    public abstract boolean needRebuild();

    public abstract long getRowCount(SessionLocal var1);

    public abstract long getRowCountApproximation(SessionLocal var1);

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public final int compareRows(SearchRow rowData, SearchRow compare) {
        if (rowData == compare) {
            return 0;
        }
        int len = this.indexColumns.length;
        for (int i = 0; i < len; ++i) {
            int index = this.columnIds[i];
            Value v1 = rowData.getValue(index);
            Value v2 = compare.getValue(index);
            if (v1 == null || v2 == null) {
                return 0;
            }
            int c = this.compareValues(v1, v2, this.indexColumns[i].sortType);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private int compareValues(Value a, Value b, int sortType) {
        boolean aNull;
        if (a == b) {
            return 0;
        }
        boolean bl = aNull = a == ValueNull.INSTANCE;
        if (aNull || b == ValueNull.INSTANCE) {
            return this.table.getDatabase().getDefaultNullOrdering().compareNull(aNull, sortType);
        }
        int comp = this.table.compareValues(this.database, a, b);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    public int getColumnIndex(Column col) {
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            if (!this.columns[i].equals(col)) continue;
            return i;
        }
        return -1;
    }

    public boolean isFirstColumn(Column column) {
        return column.equals(this.columns[0]);
    }

    public final IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public final Column[] getColumns() {
        return this.columns;
    }

    public final int getUniqueColumnCount() {
        return this.uniqueColumnColumn;
    }

    public final IndexType getIndexType() {
        return this.indexType;
    }

    public Table getTable() {
        return this.table;
    }

    public Row getRow(SessionLocal session, long key) {
        throw DbException.getUnsupportedException(this.toString());
    }

    public boolean isRowIdIndex() {
        return false;
    }

    public boolean canScan() {
        return true;
    }

    public DbException getDuplicateKeyException(String key) {
        StringBuilder builder = new StringBuilder();
        this.getSQL(builder, 3).append(" ON ");
        this.table.getSQL(builder, 3);
        this.getColumnListSQL(builder, 3);
        if (key != null) {
            builder.append(" VALUES ").append(key);
        }
        DbException e = DbException.get(23505, builder.toString());
        e.setSource(this);
        return e;
    }

    protected StringBuilder getDuplicatePrimaryKeyMessage(int mainIndexColumn) {
        StringBuilder builder = new StringBuilder("PRIMARY KEY ON ");
        this.table.getSQL(builder, 3);
        if (mainIndexColumn >= 0 && mainIndexColumn < this.indexColumns.length) {
            builder.append('(');
            this.indexColumns[mainIndexColumn].getSQL(builder, 3).append(')');
        }
        return builder;
    }

    protected final long getCostRangeIndex(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
        boolean needsToReadFromScanIndex;
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            boolean tryAdditional = false;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i > 0 && i == this.uniqueColumnColumn) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = 2L + rowsCost / 4L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = 2L + rowsCost / 3L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 4) == 4) {
                    rowsCost /= 3L;
                    tryAdditional = true;
                    break;
                }
                if (mask != 0) break;
                --i;
                break;
            }
            if (tryAdditional) {
                while (i < len && masks[this.columns[i].getColumnId()] != 0) {
                    ++i;
                    --rowsCost;
                }
            }
            rowsCost += (long)(len - i);
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypesWithNullOrdering();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals(indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        if (!isScanIndex && allColumnsSet != null) {
            needsToReadFromScanIndex = false;
            ArrayList<Column> foundCols = allColumnsSet.get(this.getTable());
            if (foundCols != null) {
                int main = this.table.getMainIndexColumn();
                block3: for (Column c : foundCols) {
                    int id = c.getColumnId();
                    if (id == -1 || id == main) continue;
                    for (Column c2 : this.columns) {
                        if (c == c2) continue block3;
                    }
                    needsToReadFromScanIndex = true;
                    break;
                }
            }
        } else {
            needsToReadFromScanIndex = true;
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    public final boolean mayHaveNullDuplicates(SearchRow searchRow) {
        switch (this.database.getMode().uniqueIndexNullsHandling) {
            case ALLOW_DUPLICATES_WITH_ANY_NULL: {
                for (int i = 0; i < this.uniqueColumnColumn; ++i) {
                    int index = this.columnIds[i];
                    if (searchRow.getValue(index) != ValueNull.INSTANCE) continue;
                    return true;
                }
                return false;
            }
            case ALLOW_DUPLICATES_WITH_ALL_NULLS: {
                for (int i = 0; i < this.uniqueColumnColumn; ++i) {
                    int index = this.columnIds[i];
                    if (searchRow.getValue(index) == ValueNull.INSTANCE) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public RowFactory getUniqueRowFactory() {
        return this.uniqueRowFactory;
    }
}

