/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueToObjectConverter;

public final class JdbcArray
extends TraceObject
implements Array {
    private ValueArray value;
    private final JdbcConnection conn;

    public JdbcArray(JdbcConnection conn, Value value, int id) {
        this.setTrace(conn.getSession().getTrace(), 16, id);
        this.conn = conn;
        this.value = value.convertToAnyArray(conn);
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + JdbcArray.quoteMap(map) + ')');
            }
            JdbcConnection.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + index + ", " + count + ')');
            }
            this.checkClosed();
            return this.get(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + index + ", " + count + ", " + JdbcArray.quoteMap(map) + ')');
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.get(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return DataType.convertTypeToSQLType(this.value.getComponentType());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return this.value.getComponentType().getDeclaredTypeName();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return this.getResultSetImpl(1L, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + JdbcArray.quoteMap(map) + ')');
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.getResultSetImpl(1L, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + index + ", " + count + ')');
            }
            this.checkClosed();
            return this.getResultSetImpl(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + index + ", " + count + ", " + JdbcArray.quoteMap(map) + ')');
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.getResultSetImpl(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private ResultSet getResultSetImpl(long index, int count) {
        int id = JdbcArray.getNextId(4);
        SimpleResult rs = new SimpleResult();
        rs.addColumn("INDEX", TypeInfo.TYPE_BIGINT);
        rs.addColumn("VALUE", this.value.getComponentType());
        Value[] values = this.value.getList();
        count = JdbcArray.checkRange(index, count, values.length);
        int i = (int)index;
        while ((long)i < index + (long)count) {
            rs.addRow(ValueBigint.get(i), values[i - 1]);
            ++i;
        }
        return new JdbcResultSet(this.conn, null, null, (ResultInterface)rs, id, true, false, false);
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    private Object get() {
        return ValueToObjectConverter.valueToDefaultArray(this.value, this.conn, true);
    }

    private Object get(long index, int count) {
        Value[] values = this.value.getList();
        count = JdbcArray.checkRange(index, count, values.length);
        Object[] a = new Object[count];
        int i = 0;
        int j = (int)index - 1;
        while (i < count) {
            a[i] = ValueToObjectConverter.valueToDefaultObject(values[j], this.conn, true);
            ++i;
            ++j;
        }
        return a;
    }

    private static int checkRange(long index, int count, int len) {
        if (index < 1L || index != 1L && index > (long)len) {
            throw DbException.getInvalidValueException("index (1.." + len + ')', index);
        }
        int rem = len - (int)index + 1;
        if (count < 0) {
            throw DbException.getInvalidValueException("count (0.." + rem + ')', count);
        }
        return Math.min(rem, count);
    }

    public String toString() {
        return this.value == null ? "null" : this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

