/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcStatementBackwardsCompat;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.result.SimpleResult;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class JdbcStatement
extends TraceObject
implements Statement,
JdbcStatementBackwardsCompat {
    protected JdbcConnection conn;
    protected Session session;
    protected JdbcResultSet resultSet;
    protected long maxRows;
    protected int fetchSize = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
    protected long updateCount;
    protected JdbcResultSet generatedKeys;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    private volatile CommandInterface executingCommand;
    private ArrayList<String> batchCommands;
    private boolean escapeProcessing = true;
    private volatile boolean cancelled;
    private boolean closeOnCompletion;

    JdbcStatement(JdbcConnection conn, int id, int resultSetType, int resultSetConcurrency) {
        this.conn = conn;
        this.session = conn.getSession();
        this.setTrace(this.session.getTrace(), 8, id);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            int id = JdbcStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, id, "executeQuery(" + JdbcStatement.quote(sql) + ')');
            }
            Session session = this.session;
            synchronized (session) {
                ResultInterface result;
                this.checkClosed();
                this.closeOldResultSet();
                sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
                CommandInterface command = this.conn.prepareCommand(sql, this.fetchSize);
                boolean lazy = false;
                boolean scrollable = this.resultSetType != 1003;
                boolean updatable = this.resultSetConcurrency == 1008;
                this.setExecutingStatement(command);
                try {
                    result = command.executeQuery(this.maxRows, scrollable);
                    lazy = result.isLazy();
                }
                finally {
                    if (!lazy) {
                        this.setExecutingStatement(null);
                    }
                }
                if (!lazy) {
                    command.close();
                }
                this.resultSet = new JdbcResultSet(this.conn, this, command, result, id, scrollable, updatable, false);
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", sql);
            long updateCount = this.executeUpdateInternal(sql, null);
            return updateCount <= Integer.MAX_VALUE ? (int)updateCount : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate", sql);
            return this.executeUpdateInternal(sql, null);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeUpdateInternal(String sql, Object generatedKeysRequest) {
        if (this.getClass() != JdbcStatement.class) {
            throw DbException.get(90130);
        }
        this.checkClosed();
        this.closeOldResultSet();
        sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
        CommandInterface command = this.conn.prepareCommand(sql, this.fetchSize);
        Session session = this.session;
        synchronized (session) {
            this.setExecutingStatement(command);
            try {
                ResultWithGeneratedKeys result = command.executeUpdate(generatedKeysRequest);
                this.updateCount = result.getUpdateCount();
                ResultInterface gk = result.getGeneratedKeys();
                if (gk != null) {
                    int id = JdbcStatement.getNextId(4);
                    this.generatedKeys = new JdbcResultSet(this.conn, this, command, gk, id, true, false, false);
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        command.close();
        return this.updateCount;
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        try {
            this.debugCodeCall("execute", sql);
            return this.executeInternal(sql, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String sql, Object generatedKeysRequest) {
        boolean returnsResultSet;
        if (this.getClass() != JdbcStatement.class) {
            throw DbException.get(90130);
        }
        int id = JdbcStatement.getNextId(4);
        this.checkClosed();
        this.closeOldResultSet();
        sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
        CommandInterface command = this.conn.prepareCommand(sql, this.fetchSize);
        boolean lazy = false;
        Session session = this.session;
        synchronized (session) {
            this.setExecutingStatement(command);
            try {
                if (command.isQuery()) {
                    returnsResultSet = true;
                    boolean scrollable = this.resultSetType != 1003;
                    boolean updatable = this.resultSetConcurrency == 1008;
                    ResultInterface result = command.executeQuery(this.maxRows, scrollable);
                    lazy = result.isLazy();
                    this.resultSet = new JdbcResultSet(this.conn, this, command, result, id, scrollable, updatable, false);
                } else {
                    returnsResultSet = false;
                    ResultWithGeneratedKeys result = command.executeUpdate(generatedKeysRequest);
                    this.updateCount = result.getUpdateCount();
                    ResultInterface gk = result.getGeneratedKeys();
                    if (gk != null) {
                        this.generatedKeys = new JdbcResultSet(this.conn, this, command, gk, id, true, false, false);
                    }
                }
            }
            finally {
                if (!lazy) {
                    this.setExecutingStatement(null);
                }
            }
        }
        if (!lazy) {
            command.close();
        }
        return returnsResultSet;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int id = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, id, "getResultSet()");
            } else {
                this.debugCodeCall("getResultSet");
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount <= Integer.MAX_VALUE ? (int)this.updateCount : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final long getLargeUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getLargeUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() {
        Session session = this.session;
        synchronized (session) {
            this.closeOldResultSet();
            if (this.conn != null) {
                this.conn = null;
            }
        }
    }

    @Override
    public Connection getConnection() {
        this.debugCodeCall("getConnection");
        return this.conn;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", name);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", direction);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows <= Integer.MAX_VALUE ? (int)this.maxRows : 0;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getLargeMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", maxRows);
            this.checkClosed();
            if (maxRows < 0) {
                throw DbException.getInvalidValueException("maxRows", maxRows);
            }
            this.maxRows = maxRows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setLargeMaxRows(long maxRows) throws SQLException {
        try {
            this.debugCodeCall("setLargeMaxRows", maxRows);
            this.checkClosed();
            if (maxRows < 0L) {
                throw DbException.getInvalidValueException("maxRows", maxRows);
            }
            this.maxRows = maxRows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", rows);
            this.checkClosed();
            if (rows < 0 || rows > 0 && this.maxRows > 0L && (long)rows > this.maxRows) {
                throw DbException.getInvalidValueException("rows", rows);
            }
            if (rows == 0) {
                rows = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.fetchSize = rows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return this.resultSetConcurrency;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", max);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setEscapeProcessing(" + enable + ')');
            }
            this.checkClosed();
            this.escapeProcessing = enable;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface c = this.executingCommand;
            try {
                if (c != null) {
                    c.cancel();
                    this.cancelled = true;
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.conn.getQueryTimeout();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", seconds);
            this.checkClosed();
            if (seconds < 0) {
                throw DbException.getInvalidValueException("seconds", seconds);
            }
            this.conn.setQueryTimeout(seconds);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.debugCodeCall("addBatch", sql);
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
            if (this.batchCommands == null) {
                this.batchCommands = Utils.newSmallArrayList();
            }
            this.batchCommands.add(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchCommands == null) {
                this.batchCommands = new ArrayList();
            }
            int size = this.batchCommands.size();
            int[] result = new int[size];
            SQLException exception = new SQLException();
            for (int i = 0; i < size; ++i) {
                long updateCount = this.executeBatchElement(this.batchCommands.get(i), exception);
                result[i] = updateCount <= Integer.MAX_VALUE ? (int)updateCount : -2;
            }
            this.batchCommands = null;
            if ((exception = exception.getNextException()) != null) {
                throw new JdbcBatchUpdateException(exception, result);
            }
            return result;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeLargeBatch");
            this.checkClosed();
            if (this.batchCommands == null) {
                this.batchCommands = new ArrayList();
            }
            int size = this.batchCommands.size();
            long[] result = new long[size];
            SQLException exception = new SQLException();
            for (int i = 0; i < size; ++i) {
                result[i] = this.executeBatchElement(this.batchCommands.get(i), exception);
            }
            this.batchCommands = null;
            if ((exception = exception.getNextException()) != null) {
                throw new JdbcBatchUpdateException(exception, result);
            }
            return result;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private long executeBatchElement(String sql, SQLException exception) {
        long updateCount;
        try {
            updateCount = this.executeUpdateInternal(sql, null);
        }
        catch (Exception e) {
            exception.setNextException(this.logAndConvert(e));
            updateCount = -3L;
        }
        return updateCount;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            int id;
            int n = id = this.generatedKeys != null ? this.generatedKeys.getTraceId() : JdbcStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, id, "getGeneratedKeys()");
            }
            this.checkClosed();
            if (this.generatedKeys == null) {
                this.generatedKeys = new JdbcResultSet(this.conn, this, null, (ResultInterface)new SimpleResult(), id, true, false, false);
            }
            return this.generatedKeys;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOldResultSet();
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults", current);
            switch (current) {
                case 1: 
                case 3: {
                    this.checkClosed();
                    this.closeOldResultSet();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("current", current);
                }
            }
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(sql) + ", " + autoGeneratedKeys + ')');
            }
            long updateCount = this.executeUpdateInternal(sql, autoGeneratedKeys == 1);
            return updateCount <= Integer.MAX_VALUE ? (int)updateCount : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcStatement.quote(sql) + ", " + autoGeneratedKeys + ')');
            }
            return this.executeUpdateInternal(sql, autoGeneratedKeys == 1);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            long updateCount;
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteIntArray(columnIndexes) + ')');
            }
            return (updateCount = this.executeUpdateInternal(sql, columnIndexes)) <= Integer.MAX_VALUE ? (int)updateCount : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteIntArray(columnIndexes) + ')');
            }
            return this.executeUpdateInternal(sql, columnIndexes);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            long updateCount;
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteArray(columnNames) + ')');
            }
            return (updateCount = this.executeUpdateInternal(sql, columnNames)) <= Integer.MAX_VALUE ? (int)updateCount : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteArray(columnNames) + ')');
            }
            return this.executeUpdateInternal(sql, columnNames);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(sql) + ", " + autoGeneratedKeys + ')');
            }
            return this.executeInternal(sql, autoGeneratedKeys == 1);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteIntArray(columnIndexes) + ')');
            }
            return this.executeInternal(sql, columnIndexes);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteArray(columnNames) + ')');
            }
            return this.executeInternal(sql, columnNames);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this.debugCodeCall("closeOnCompletion");
            this.checkClosed();
            this.closeOnCompletion = true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            this.debugCodeCall("isCloseOnCompletion");
            this.checkClosed();
            return this.closeOnCompletion;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    void closeIfCloseOnCompletion() {
        if (this.closeOnCompletion) {
            try {
                this.closeInternal();
            }
            catch (Exception e) {
                this.logAndConvert(e);
            }
        }
    }

    void checkClosed() {
        if (this.conn == null) {
            throw DbException.get(90007);
        }
        this.conn.checkClosed();
    }

    protected void closeOldResultSet() {
        try {
            if (this.resultSet != null) {
                this.resultSet.closeInternal(true);
            }
            if (this.generatedKeys != null) {
                this.generatedKeys.closeInternal(true);
            }
        }
        finally {
            this.cancelled = false;
            this.resultSet = null;
            this.updateCount = -1L;
            this.generatedKeys = null;
        }
    }

    void setExecutingStatement(CommandInterface c) {
        if (c == null) {
            this.conn.setExecutingStatement(null);
        } else {
            this.conn.setExecutingStatement(this);
        }
        this.executingCommand = c;
    }

    void onLazyResultSetClose(CommandInterface command, boolean closeCommand) {
        this.setExecutingStatement(null);
        command.stop();
        if (closeCommand) {
            command.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isPoolable() {
        this.debugCodeCall("isPoolable");
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPoolable(" + poolable + ')');
        }
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        if (this.isSimpleIdentifier(identifier)) {
            return alwaysQuote ? '\"' + identifier + '\"' : identifier;
        }
        try {
            int length = identifier.length();
            if (length > 0) {
                if (identifier.charAt(0) == '\"') {
                    JdbcStatement.checkQuotes(identifier, 1, length);
                    return identifier;
                }
                if (identifier.startsWith("U&\"") || identifier.startsWith("u&\"")) {
                    JdbcStatement.checkQuotes(identifier, 3, length);
                    StringUtils.decodeUnicodeStringSQL(identifier, 92);
                    return identifier;
                }
            }
            return StringUtils.quoteIdentifier(identifier);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private static void checkQuotes(String identifier, int offset, int length) {
        boolean quoted = true;
        for (int i = offset; i < length; ++i) {
            if (identifier.charAt(i) == '\"') {
                quoted = !quoted;
                continue;
            }
            if (quoted) continue;
            throw DbException.get(42602, identifier);
        }
        if (quoted) {
            throw DbException.get(42602, identifier);
        }
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        Session.StaticSettings settings;
        try {
            this.checkClosed();
            settings = this.conn.getStaticSettings();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
        return ParserUtil.isSimpleIdentifier(identifier, settings.databaseToUpper, settings.databaseToLower);
    }

    public String toString() {
        return this.getTraceObjectName();
    }
}

