/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

public enum DefaultNullOrdering {
    LOW(2, 4),
    HIGH(4, 2),
    FIRST(2, 2),
    LAST(4, 4);

    private static final DefaultNullOrdering[] VALUES;
    private final int defaultAscNulls;
    private final int defaultDescNulls;
    private final int nullAsc;
    private final int nullDesc;

    public static DefaultNullOrdering valueOf(int ordinal) {
        return VALUES[ordinal];
    }

    private DefaultNullOrdering(int defaultAscNulls, int defaultDescNulls) {
        this.defaultAscNulls = defaultAscNulls;
        this.defaultDescNulls = defaultDescNulls;
        this.nullAsc = defaultAscNulls == 2 ? -1 : 1;
        this.nullDesc = defaultDescNulls == 2 ? -1 : 1;
    }

    public int addExplicitNullOrdering(int sortType) {
        if ((sortType & 6) == 0) {
            sortType |= (sortType & 1) == 0 ? this.defaultAscNulls : this.defaultDescNulls;
        }
        return sortType;
    }

    public int compareNull(boolean aNull, int sortType) {
        if ((sortType & 2) != 0) {
            return aNull ? -1 : 1;
        }
        if ((sortType & 4) != 0) {
            return aNull ? 1 : -1;
        }
        if ((sortType & 1) == 0) {
            return aNull ? this.nullAsc : -this.nullAsc;
        }
        return aNull ? this.nullDesc : -this.nullDesc;
    }

    static {
        VALUES = DefaultNullOrdering.values();
    }
}

