/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.expression.function.ToCharFunction;
import org.h2.message.DbException;
import org.h2.mode.ToDateParser;
import org.h2.util.TimeZoneProvider;

final class ToDateTokenizer {
    static final Pattern PATTERN_INLINE = Pattern.compile("(\"[^\"]*\")");
    static final Pattern PATTERN_NUMBER = Pattern.compile("^([+-]?[0-9]+)");
    static final Pattern PATTERN_FOUR_DIGITS = Pattern.compile("^([+-]?[0-9]{4})");
    static final Pattern PATTERN_TWO_TO_FOUR_DIGITS = Pattern.compile("^([+-]?[0-9]{2,4})");
    static final Pattern PATTERN_THREE_DIGITS = Pattern.compile("^([+-]?[0-9]{3})");
    static final Pattern PATTERN_TWO_DIGITS = Pattern.compile("^([+-]?[0-9]{2})");
    static final Pattern PATTERN_TWO_DIGITS_OR_LESS = Pattern.compile("^([+-]?[0-9][0-9]?)");
    static final Pattern PATTERN_ONE_DIGIT = Pattern.compile("^([+-]?[0-9])");
    static final Pattern PATTERN_FF = Pattern.compile("^(FF[0-9]?)", 2);
    static final Pattern PATTERN_AM_PM = Pattern.compile("^(AM|A\\.M\\.|PM|P\\.M\\.)", 2);
    static final Pattern PATTERN_BC_AD = Pattern.compile("^(BC|B\\.C\\.|AD|A\\.D\\.)", 2);
    static final YearParslet PARSLET_YEAR = new YearParslet();
    static final MonthParslet PARSLET_MONTH = new MonthParslet();
    static final DayParslet PARSLET_DAY = new DayParslet();
    static final TimeParslet PARSLET_TIME = new TimeParslet();
    static final InlineParslet PARSLET_INLINE = new InlineParslet();

    static String matchStringOrThrow(Pattern p, ToDateParser params, Enum<?> aEnum) {
        String s = params.getInputStr();
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            ToDateTokenizer.throwException(params, String.format("Issue happened when parsing token '%s'", aEnum.name()));
        }
        return matcher.group(1);
    }

    static String setByName(ToDateParser params, int field) {
        String inputFragmentStr = null;
        String s = params.getInputStr();
        Object[] values = ToCharFunction.getDateNames(field);
        for (int i = 0; i < values.length; ++i) {
            int len;
            String dayName = values[i];
            if (dayName == null || !dayName.equalsIgnoreCase(s.substring(0, len = dayName.length()))) continue;
            switch (field) {
                case 0: 
                case 1: {
                    params.setMonth(i + 1);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            inputFragmentStr = dayName;
            break;
        }
        if (inputFragmentStr == null || inputFragmentStr.isEmpty()) {
            ToDateTokenizer.throwException(params, String.format("Tried to parse one of '%s' but failed (may be an internal error?)", Arrays.toString(values)));
        }
        return inputFragmentStr;
    }

    static void throwException(ToDateParser params, String errorStr) {
        throw DbException.get(90056, params.getFunctionName(), String.format(" %s. Details: %s", errorStr, params));
    }

    private ToDateTokenizer() {
    }

    public static enum FormatTokenEnum {
        YYYY(PARSLET_YEAR),
        SYYYY(PARSLET_YEAR),
        YYY(PARSLET_YEAR),
        YY(PARSLET_YEAR),
        SCC(PARSLET_YEAR),
        CC(PARSLET_YEAR),
        RRRR(PARSLET_YEAR),
        RR(PARSLET_YEAR),
        BC_AD(PARSLET_YEAR, PATTERN_BC_AD),
        MONTH(PARSLET_MONTH),
        MON(PARSLET_MONTH),
        MM(PARSLET_MONTH),
        RM(PARSLET_MONTH),
        DDD(PARSLET_DAY),
        DAY(PARSLET_DAY),
        DD(PARSLET_DAY),
        DY(PARSLET_DAY),
        HH24(PARSLET_TIME),
        HH12(PARSLET_TIME),
        HH(PARSLET_TIME),
        MI(PARSLET_TIME),
        SSSSS(PARSLET_TIME),
        SS(PARSLET_TIME),
        FF(PARSLET_TIME, PATTERN_FF),
        TZH(PARSLET_TIME),
        TZM(PARSLET_TIME),
        TZR(PARSLET_TIME),
        TZD(PARSLET_TIME),
        AM_PM(PARSLET_TIME, PATTERN_AM_PM),
        EE(PARSLET_YEAR),
        E(PARSLET_YEAR),
        Y(PARSLET_YEAR),
        Q(PARSLET_MONTH),
        D(PARSLET_DAY),
        J(PARSLET_DAY),
        INLINE(PARSLET_INLINE, PATTERN_INLINE);

        private static final List<FormatTokenEnum> INLINE_LIST;
        private static List<FormatTokenEnum>[] TOKENS;
        private final ToDateParslet toDateParslet;
        private final Pattern patternToUse;

        private FormatTokenEnum(ToDateParslet toDateParslet, Pattern patternToUse) {
            this.toDateParslet = toDateParslet;
            this.patternToUse = patternToUse;
        }

        private FormatTokenEnum(ToDateParslet toDateParslet) {
            this.toDateParslet = toDateParslet;
            this.patternToUse = Pattern.compile(String.format("^(%s)", this.name()), 2);
        }

        static List<FormatTokenEnum> getTokensInQuestion(String formatStr) {
            if (formatStr != null && !formatStr.isEmpty()) {
                char key = Character.toUpperCase(formatStr.charAt(0));
                if (key >= 'A' && key <= 'Y') {
                    List<FormatTokenEnum>[] tokens = TOKENS;
                    if (tokens == null) {
                        tokens = FormatTokenEnum.initTokens();
                    }
                    return tokens[key - 65];
                }
                if (key == '\"') {
                    return INLINE_LIST;
                }
            }
            return null;
        }

        private static List<FormatTokenEnum>[] initTokens() {
            List[] tokens = new List[25];
            for (FormatTokenEnum token : FormatTokenEnum.values()) {
                String name = token.name();
                if (name.indexOf(95) >= 0) {
                    for (String tokenLets : name.split("_")) {
                        FormatTokenEnum.putToCache(tokens, token, tokenLets);
                    }
                    continue;
                }
                FormatTokenEnum.putToCache(tokens, token, name);
            }
            TOKENS = tokens;
            return tokens;
        }

        private static void putToCache(List<FormatTokenEnum>[] cache, FormatTokenEnum token, String name) {
            int idx = Character.toUpperCase(name.charAt(0)) - 65;
            List<FormatTokenEnum> l = cache[idx];
            if (l == null) {
                cache[idx] = l = new ArrayList<FormatTokenEnum>(1);
            }
            l.add(token);
        }

        boolean parseFormatStrWithToken(ToDateParser params) {
            Matcher matcher = this.patternToUse.matcher(params.getFormatStr());
            boolean foundToken = matcher.find();
            if (foundToken) {
                String formatTokenStr = matcher.group(1);
                this.toDateParslet.parse(params, this, formatTokenStr);
            }
            return foundToken;
        }

        static {
            INLINE_LIST = Collections.singletonList(INLINE);
        }
    }

    static class InlineParslet
    implements ToDateParslet {
        InlineParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            String inputFragmentStr = null;
            switch (formatTokenEnum) {
                case INLINE: {
                    inputFragmentStr = formatTokenStr.replace("\"", "");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class TimeParslet
    implements ToDateParslet {
        TimeParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case HH24: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setHour(dateNr);
                    break;
                }
                case HH12: 
                case HH: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setHour12(dateNr);
                    break;
                }
                case MI: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setMinute(dateNr);
                    break;
                }
                case SS: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setSecond(dateNr);
                    break;
                }
                case SSSSS: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    int second = dateNr % 60;
                    int minute = (dateNr /= 60) % 60;
                    int hour = (dateNr /= 60) % 24;
                    params.setHour(hour);
                    params.setMinute(minute);
                    params.setSecond(second);
                    break;
                }
                case FF: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    String paddedRightNrStr = String.format("%-9s", inputFragmentStr).replace(' ', '0');
                    paddedRightNrStr = paddedRightNrStr.substring(0, 9);
                    double nineDigits = Double.parseDouble(paddedRightNrStr);
                    params.setNanos((int)nineDigits);
                    break;
                }
                case AM_PM: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_AM_PM, params, formatTokenEnum);
                    if (inputFragmentStr.toUpperCase().startsWith("A")) {
                        params.setAmPm(true);
                        break;
                    }
                    params.setAmPm(false);
                    break;
                }
                case TZH: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setTimeZoneHour(dateNr);
                    break;
                }
                case TZM: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setTimeZoneMinute(dateNr);
                    break;
                }
                case TZR: 
                case TZD: {
                    String tzName = params.getInputStr();
                    params.setTimeZone(TimeZoneProvider.ofId(tzName));
                    inputFragmentStr = tzName;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class DayParslet
    implements ToDateParslet {
        DayParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case DDD: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setDayOfYear(dateNr);
                    break;
                }
                case DD: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setDay(dateNr);
                    break;
                }
                case D: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_ONE_DIGIT, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setDay(dateNr);
                    break;
                }
                case DAY: {
                    inputFragmentStr = ToDateTokenizer.setByName(params, 2);
                    break;
                }
                case DY: {
                    inputFragmentStr = ToDateTokenizer.setByName(params, 3);
                    break;
                }
                case J: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setAbsoluteDay(dateNr + -2440588);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class MonthParslet
    implements ToDateParslet {
        private static final String[] ROMAN_MONTH = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};

        MonthParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            String s = params.getInputStr();
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case MONTH: {
                    inputFragmentStr = ToDateTokenizer.setByName(params, 0);
                    break;
                }
                case Q: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case MON: {
                    inputFragmentStr = ToDateTokenizer.setByName(params, 1);
                    break;
                }
                case MM: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    params.setMonth(dateNr);
                    break;
                }
                case RM: {
                    dateNr = 0;
                    for (String monthName : ROMAN_MONTH) {
                        ++dateNr;
                        int len = monthName.length();
                        if (s.length() < len || !monthName.equalsIgnoreCase(s.substring(0, len))) continue;
                        params.setMonth(dateNr + 1);
                        inputFragmentStr = monthName;
                        break;
                    }
                    if (inputFragmentStr != null && !inputFragmentStr.isEmpty()) break;
                    ToDateTokenizer.throwException(params, String.format("Issue happened when parsing token '%s'. Expected one of: %s", formatTokenEnum.name(), Arrays.toString(ROMAN_MONTH)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class YearParslet
    implements ToDateParslet {
        YearParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case SYYYY: 
                case YYYY: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_FOUR_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    if (dateNr == 0) {
                        ToDateTokenizer.throwException(params, "Year may not be zero");
                    }
                    params.setYear(dateNr >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case YYY: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_THREE_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    if (dateNr > 999) {
                        ToDateTokenizer.throwException(params, "Year may have only three digits with specified format");
                    }
                    params.setYear((dateNr += params.getCurrentYear() / 1000 * 1000) >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case RRRR: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_TO_FOUR_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    if (inputFragmentStr.length() < 4) {
                        if (dateNr < 50) {
                            dateNr += 2000;
                        } else if (dateNr < 100) {
                            dateNr += 1900;
                        }
                    }
                    if (dateNr == 0) {
                        ToDateTokenizer.throwException(params, "Year may not be zero");
                    }
                    params.setYear(dateNr);
                    break;
                }
                case RR: {
                    int cc = params.getCurrentYear() / 100;
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr) + cc * 100;
                    params.setYear(dateNr);
                    break;
                }
                case EE: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case E: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case YY: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    if (dateNr > 99) {
                        ToDateTokenizer.throwException(params, "Year may have only two digits with specified format");
                    }
                    params.setYear((dateNr += params.getCurrentYear() / 100 * 100) >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case SCC: 
                case CC: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr) * 100;
                    params.setYear(dateNr);
                    break;
                }
                case Y: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_ONE_DIGIT, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    if (dateNr > 9) {
                        ToDateTokenizer.throwException(params, "Year may have only two digits with specified format");
                    }
                    params.setYear((dateNr += params.getCurrentYear() / 10 * 10) >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case BC_AD: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_BC_AD, params, formatTokenEnum);
                    params.setBC(inputFragmentStr.toUpperCase().startsWith("B"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static interface ToDateParslet {
        public void parse(ToDateParser var1, FormatTokenEnum var2, String var3);
    }
}

