/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Map;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.WriteBuffer;
import org.h2.util.StringUtils;

public final class Chunk {
    public static final int MAX_ID = 0x3FFFFFF;
    static final int MAX_HEADER_LENGTH = 1024;
    static final int FOOTER_LENGTH = 128;
    private static final String ATTR_CHUNK = "chunk";
    private static final String ATTR_BLOCK = "block";
    private static final String ATTR_LEN = "len";
    private static final String ATTR_MAP = "map";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_NEXT = "next";
    private static final String ATTR_PAGES = "pages";
    private static final String ATTR_ROOT = "root";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_LIVE_MAX = "liveMax";
    private static final String ATTR_LIVE_PAGES = "livePages";
    private static final String ATTR_UNUSED = "unused";
    private static final String ATTR_UNUSED_AT_VERSION = "unusedAtVersion";
    private static final String ATTR_PIN_COUNT = "pinCount";
    private static final String ATTR_TOC = "toc";
    private static final String ATTR_OCCUPANCY = "occupancy";
    private static final String ATTR_FLETCHER = "fletcher";
    public final int id;
    public volatile long block;
    public int len;
    int pageCount;
    int pageCountLive;
    int tocPos;
    BitSet occupancy;
    public long maxLen;
    public long maxLenLive;
    int collectPriority;
    long layoutRootPos;
    public long version;
    public long time;
    public long unused;
    long unusedAtVersion;
    public int mapId;
    public long next;
    private int pinCount;

    private Chunk(String s) {
        this(DataUtils.parseMap(s), true);
    }

    Chunk(Map<String, String> map) {
        this(map, false);
    }

    private Chunk(Map<String, String> map, boolean full) {
        this(DataUtils.readHexInt(map, ATTR_CHUNK, 0));
        this.block = DataUtils.readHexLong(map, ATTR_BLOCK, 0L);
        this.version = DataUtils.readHexLong(map, ATTR_VERSION, this.id);
        if (full) {
            this.len = DataUtils.readHexInt(map, ATTR_LEN, 0);
            this.pageCount = DataUtils.readHexInt(map, ATTR_PAGES, 0);
            this.pageCountLive = DataUtils.readHexInt(map, ATTR_LIVE_PAGES, this.pageCount);
            this.mapId = DataUtils.readHexInt(map, ATTR_MAP, 0);
            this.maxLen = DataUtils.readHexLong(map, ATTR_MAX, 0L);
            this.maxLenLive = DataUtils.readHexLong(map, ATTR_LIVE_MAX, this.maxLen);
            this.layoutRootPos = DataUtils.readHexLong(map, ATTR_ROOT, 0L);
            this.time = DataUtils.readHexLong(map, ATTR_TIME, 0L);
            this.unused = DataUtils.readHexLong(map, ATTR_UNUSED, 0L);
            this.unusedAtVersion = DataUtils.readHexLong(map, ATTR_UNUSED_AT_VERSION, 0L);
            this.next = DataUtils.readHexLong(map, ATTR_NEXT, 0L);
            this.pinCount = DataUtils.readHexInt(map, ATTR_PIN_COUNT, 0);
            this.tocPos = DataUtils.readHexInt(map, ATTR_TOC, 0);
            byte[] bytes = DataUtils.parseHexBytes(map, ATTR_OCCUPANCY);
            if (bytes == null) {
                this.occupancy = new BitSet();
            } else {
                this.occupancy = BitSet.valueOf(bytes);
                if (this.pageCount - this.pageCountLive != this.occupancy.cardinality()) {
                    throw DataUtils.newMVStoreException(6, "Inconsistent occupancy info {0} - {1} != {2} {3}", this.pageCount, this.pageCountLive, this.occupancy.cardinality(), this);
                }
            }
        }
    }

    Chunk(int id) {
        this.id = id;
        if (id <= 0) {
            throw DataUtils.newMVStoreException(6, "Invalid chunk id {0}", id);
        }
    }

    static Chunk readChunkHeader(ByteBuffer buff, long start) {
        int pos = buff.position();
        byte[] data = new byte[Math.min(buff.remaining(), 1024)];
        buff.get(data);
        try {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 10) continue;
                buff.position(pos + i + 1);
                String s = new String(data, 0, i, StandardCharsets.ISO_8859_1).trim();
                return Chunk.fromString(s);
            }
        }
        catch (Exception e) {
            throw DataUtils.newMVStoreException(6, "File corrupt reading chunk at position {0}", start, e);
        }
        throw DataUtils.newMVStoreException(6, "File corrupt reading chunk at position {0}", start);
    }

    void writeChunkHeader(WriteBuffer buff, int minLength) {
        long delimiterPosition = buff.position() + minLength - 1;
        buff.put(this.asString().getBytes(StandardCharsets.ISO_8859_1));
        while ((long)buff.position() < delimiterPosition) {
            buff.put((byte)32);
        }
        if (minLength != 0 && (long)buff.position() > delimiterPosition) {
            throw DataUtils.newMVStoreException(3, "Chunk metadata too long", new Object[0]);
        }
        buff.put((byte)10);
    }

    static String getMetaKey(int chunkId) {
        return "chunk." + Integer.toHexString(chunkId);
    }

    public static Chunk fromString(String s) {
        return new Chunk(s);
    }

    int getFillRate() {
        assert (this.maxLenLive <= this.maxLen) : this.maxLenLive + " > " + this.maxLen;
        if (this.maxLenLive <= 0L) {
            return 0;
        }
        if (this.maxLenLive == this.maxLen) {
            return 100;
        }
        return 1 + (int)(98L * this.maxLenLive / this.maxLen);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o instanceof Chunk && ((Chunk)o).id == this.id;
    }

    public String asString() {
        StringBuilder buff = new StringBuilder(240);
        DataUtils.appendMap(buff, ATTR_CHUNK, this.id);
        DataUtils.appendMap(buff, ATTR_BLOCK, this.block);
        DataUtils.appendMap(buff, ATTR_LEN, this.len);
        if (this.maxLen != this.maxLenLive) {
            DataUtils.appendMap(buff, ATTR_LIVE_MAX, this.maxLenLive);
        }
        if (this.pageCount != this.pageCountLive) {
            DataUtils.appendMap(buff, ATTR_LIVE_PAGES, this.pageCountLive);
        }
        DataUtils.appendMap(buff, ATTR_MAP, this.mapId);
        DataUtils.appendMap(buff, ATTR_MAX, this.maxLen);
        if (this.next != 0L) {
            DataUtils.appendMap(buff, ATTR_NEXT, this.next);
        }
        DataUtils.appendMap(buff, ATTR_PAGES, this.pageCount);
        DataUtils.appendMap(buff, ATTR_ROOT, this.layoutRootPos);
        DataUtils.appendMap(buff, ATTR_TIME, this.time);
        if (this.unused != 0L) {
            DataUtils.appendMap(buff, ATTR_UNUSED, this.unused);
        }
        if (this.unusedAtVersion != 0L) {
            DataUtils.appendMap(buff, ATTR_UNUSED_AT_VERSION, this.unusedAtVersion);
        }
        DataUtils.appendMap(buff, ATTR_VERSION, this.version);
        if (this.pinCount > 0) {
            DataUtils.appendMap(buff, ATTR_PIN_COUNT, this.pinCount);
        }
        if (this.tocPos > 0) {
            DataUtils.appendMap(buff, ATTR_TOC, this.tocPos);
        }
        if (!this.occupancy.isEmpty()) {
            DataUtils.appendMap(buff, ATTR_OCCUPANCY, StringUtils.convertBytesToHex(this.occupancy.toByteArray()));
        }
        return buff.toString();
    }

    byte[] getFooterBytes() {
        StringBuilder buff = new StringBuilder(128);
        DataUtils.appendMap(buff, ATTR_CHUNK, this.id);
        DataUtils.appendMap(buff, ATTR_BLOCK, this.block);
        DataUtils.appendMap(buff, ATTR_VERSION, this.version);
        byte[] bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        int checksum = DataUtils.getFletcher32(bytes, 0, bytes.length);
        DataUtils.appendMap(buff, ATTR_FLETCHER, checksum);
        while (buff.length() < 127) {
            buff.append(' ');
        }
        buff.append('\n');
        return buff.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    boolean isSaved() {
        return this.block != Long.MAX_VALUE;
    }

    boolean isLive() {
        return this.pageCountLive > 0;
    }

    boolean isRewritable() {
        return this.isSaved() && this.isLive() && this.pageCountLive < this.pageCount && this.isEvacuatable();
    }

    private boolean isEvacuatable() {
        return this.pinCount == 0;
    }

    /*
     * Unable to fully structure code
     */
    ByteBuffer readBufferForPage(FileStore fileStore, int offset, long pos) {
        if (!Chunk.$assertionsDisabled && !this.isSaved()) {
            throw new AssertionError(this);
        }
        while (true) lbl-1000:
        // 3 sources

        {
            originalBlock = this.block;
            try {
                filePos = originalBlock * 4096L;
                maxPos = filePos + (long)this.len * 4096L;
                if ((filePos += (long)offset) < 0L) {
                    throw DataUtils.newMVStoreException(6, "Negative position {0}; p={1}, c={2}", new Object[]{filePos, pos, this.toString()});
                }
                length = DataUtils.getPageMaxLength(pos);
                if (length == 0x200000) {
                    length = fileStore.readFully(filePos, 128).getInt();
                    length += 4;
                }
                if ((length = (int)Math.min(maxPos - filePos, (long)length)) < 0) {
                    throw DataUtils.newMVStoreException(6, "Illegal page length {0} reading at {1}; max pos {2} ", new Object[]{length, filePos, maxPos});
                }
                buff = fileStore.readFully(filePos, length);
                if (originalBlock != this.block) ** GOTO lbl-1000
                return buff;
            }
            catch (MVStoreException ex) {
                if (originalBlock != this.block) continue;
                throw ex;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    long[] readToC(FileStore fileStore) {
        if (!Chunk.$assertionsDisabled && !this.isSaved()) {
            throw new AssertionError(this);
        }
        if (!Chunk.$assertionsDisabled && this.tocPos <= 0) {
            throw new AssertionError();
        }
        while (true) lbl-1000:
        // 3 sources

        {
            originalBlock = this.block;
            try {
                filePos = originalBlock * 4096L + (long)this.tocPos;
                length = this.pageCount * 8;
                toc = new long[this.pageCount];
                fileStore.readFully(filePos, length).asLongBuffer().get(toc);
                if (originalBlock != this.block) ** GOTO lbl-1000
                return toc;
            }
            catch (MVStoreException ex) {
                if (originalBlock != this.block) continue;
                throw ex;
            }
            break;
        }
    }

    void accountForWrittenPage(int pageLengthOnDisk, boolean singleWriter) {
        this.maxLen += (long)pageLengthOnDisk;
        ++this.pageCount;
        this.maxLenLive += (long)pageLengthOnDisk;
        ++this.pageCountLive;
        if (singleWriter) {
            ++this.pinCount;
        }
        assert (this.pageCount - this.pageCountLive == this.occupancy.cardinality()) : this.pageCount + " - " + this.pageCountLive + " <> " + this.occupancy.cardinality() + " : " + this.occupancy;
    }

    boolean accountForRemovedPage(int pageNo, int pageLength, boolean pinned, long now, long version) {
        assert (this.isSaved()) : this;
        if (this.tocPos > 0) {
            assert (pageNo >= 0 && pageNo < this.pageCount) : pageNo + " // " + this.pageCount;
            assert (!this.occupancy.get(pageNo)) : pageNo + " " + this + " " + this.occupancy;
            assert (this.pageCount - this.pageCountLive == this.occupancy.cardinality()) : this.pageCount + " - " + this.pageCountLive + " <> " + this.occupancy.cardinality() + " : " + this.occupancy;
            this.occupancy.set(pageNo);
        }
        this.maxLenLive -= (long)pageLength;
        --this.pageCountLive;
        if (pinned) {
            --this.pinCount;
        }
        if (this.unusedAtVersion < version) {
            this.unusedAtVersion = version;
        }
        assert (this.pinCount >= 0) : this;
        assert (this.pageCountLive >= 0) : this;
        assert (this.pinCount <= this.pageCountLive) : this;
        assert (this.maxLenLive >= 0L) : this;
        assert (this.pageCountLive == 0 == (this.maxLenLive == 0L)) : this;
        if (!this.isLive()) {
            this.unused = now;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.asString();
    }

    public static final class PositionComparator
    implements Comparator<Chunk> {
        public static final Comparator<Chunk> INSTANCE = new PositionComparator();

        private PositionComparator() {
        }

        @Override
        public int compare(Chunk one, Chunk two) {
            return Long.compare(one.block, two.block);
        }
    }
}

