/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.Utils;

public class MVStore
implements AutoCloseable {
    private static final String HDR_H = "H";
    private static final String HDR_BLOCK_SIZE = "blockSize";
    private static final String HDR_FORMAT = "format";
    private static final String HDR_CREATED = "created";
    private static final String HDR_FORMAT_READ = "formatRead";
    private static final String HDR_CHUNK = "chunk";
    private static final String HDR_BLOCK = "block";
    private static final String HDR_VERSION = "version";
    private static final String HDR_CLEAN = "clean";
    private static final String HDR_FLETCHER = "fletcher";
    public static final String META_ID_KEY = "meta.id";
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE_MIN = 2;
    private static final int FORMAT_WRITE_MAX = 2;
    private static final int FORMAT_READ_MIN = 2;
    private static final int FORMAT_READ_MAX = 2;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private static final int PIPE_LENGTH = 1;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final ReentrantLock serializationLock = new ReentrantLock(true);
    private final ReentrantLock saveChunkLock = new ReentrantLock(true);
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private ThreadPoolExecutor serializationExecutor;
    private ThreadPoolExecutor bufferSaveExecutor;
    private volatile boolean reuseSpace = true;
    private volatile int state;
    private final FileStore fileStore;
    private final boolean fileStoreShallBeClosed;
    private final int pageSplitSize;
    private final int keysPerPage;
    private final CacheLongKeyLIRS<Page<?, ?>> cache;
    private final CacheLongKeyLIRS<long[]> chunksToC;
    private volatile Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final Queue<RemovedPageInfo> removedPages = new PriorityBlockingQueue<RemovedPageInfo>();
    private final Deque<Chunk> deadChunks = new ArrayDeque<Chunk>();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final MVMap<String, String> layout;
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final HashMap<String, Object> storeHeader = new HashMap();
    private final Queue<WriteBuffer> writeBufferPool = new ArrayBlockingQueue<WriteBuffer>(2);
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int lastChunkId;
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final boolean recoveryMode;
    public final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private final int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private volatile MVStoreException panicException;
    private long lastTimeAbsolute;
    private long leafCount;
    private long nonLeafCount;
    private volatile LongConsumer oldestVersionTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(Map<String, Object> config) {
        this.recoveryMode = config.containsKey("recoveryMode");
        this.compressionLevel = DataUtils.getConfigParam(config, "compress", 0);
        String fileName = (String)config.get("fileName");
        FileStore fileStore = (FileStore)config.get("fileStore");
        boolean fileStoreShallBeOpen = false;
        if (fileStore == null) {
            if (fileName != null) {
                fileStore = new FileStore();
                fileStoreShallBeOpen = true;
            }
            this.fileStoreShallBeClosed = true;
        } else {
            if (fileName != null) {
                throw new IllegalArgumentException("fileName && fileStore");
            }
            Boolean fileStoreIsAdopted = (Boolean)config.get("fileStoreIsAdopted");
            this.fileStoreShallBeClosed = fileStoreIsAdopted != null && fileStoreIsAdopted != false;
        }
        this.fileStore = fileStore;
        int pgSplitSize = 48;
        CacheLongKeyLIRS.Config cc = null;
        CacheLongKeyLIRS.Config cc2 = null;
        if (this.fileStore != null) {
            int mb = DataUtils.getConfigParam(config, "cacheSize", 16);
            if (mb > 0) {
                cc = new CacheLongKeyLIRS.Config();
                cc.maxMemory = (long)mb * 1024L * 1024L;
                Object o = config.get("cacheConcurrency");
                if (o != null) {
                    cc.segmentCount = (Integer)o;
                }
            }
            cc2 = new CacheLongKeyLIRS.Config();
            cc2.maxMemory = 0x100000L;
            pgSplitSize = 16384;
        }
        this.cache = cc != null ? new CacheLongKeyLIRS(cc) : null;
        this.chunksToC = cc2 == null ? null : new CacheLongKeyLIRS(cc2);
        pgSplitSize = DataUtils.getConfigParam(config, "pageSplitSize", pgSplitSize);
        if (this.cache != null && (long)pgSplitSize > this.cache.getMaxItemSize()) {
            pgSplitSize = (int)this.cache.getMaxItemSize();
        }
        this.pageSplitSize = pgSplitSize;
        this.keysPerPage = DataUtils.getConfigParam(config, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)config.get("backgroundExceptionHandler");
        this.layout = new MVMap<String, String>(this, 0, StringDataType.INSTANCE, StringDataType.INSTANCE);
        if (this.fileStore != null) {
            this.retentionTime = this.fileStore.getDefaultRetentionTime();
            int kb = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory(64))) * 1024;
            kb = DataUtils.getConfigParam(config, "autoCommitBufferSize", kb);
            this.autoCommitMemory = kb * 1024;
            this.autoCompactFillRate = DataUtils.getConfigParam(config, "autoCompactFillRate", 90);
            char[] encryptionKey = (char[])config.remove("encryptionKey");
            this.storeLock.lock();
            try {
                this.saveChunkLock.lock();
                try {
                    if (fileStoreShallBeOpen) {
                        boolean readOnly = config.containsKey("readOnly");
                        this.fileStore.open(fileName, readOnly, encryptionKey);
                    }
                    if (this.fileStore.size() == 0L) {
                        this.creationTime = this.getTimeAbsolute();
                        this.storeHeader.put(HDR_H, 2);
                        this.storeHeader.put(HDR_BLOCK_SIZE, 4096);
                        this.storeHeader.put(HDR_FORMAT, 2);
                        this.storeHeader.put(HDR_CREATED, this.creationTime);
                        this.setLastChunk(null);
                        this.writeStoreHeader();
                    } else {
                        this.readStoreHeader();
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            catch (MVStoreException e) {
                this.panic(e);
            }
            finally {
                if (encryptionKey != null) {
                    Arrays.fill(encryptionKey, '\u0000');
                }
                this.unlockAndCheckPanicCondition();
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            this.meta = this.openMetaMap();
            this.scrubLayoutMap();
            this.scrubMetaMap();
            int delay = DataUtils.getConfigParam(config, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(delay);
        } else {
            this.autoCommitMemory = 0;
            this.autoCompactFillRate = 0;
            this.meta = this.openMetaMap();
        }
        this.onVersionChange(this.currentVersion);
    }

    private MVMap<String, String> openMetaMap() {
        int metaId;
        String metaIdStr = this.layout.get(META_ID_KEY);
        if (metaIdStr == null) {
            metaId = this.lastMapId.incrementAndGet();
            this.layout.put(META_ID_KEY, Integer.toHexString(metaId));
        } else {
            metaId = DataUtils.parseHexInt(metaIdStr);
        }
        MVMap<String, String> map = new MVMap<String, String>(this, metaId, StringDataType.INSTANCE, StringDataType.INSTANCE);
        map.setRootPos(this.getRootPos(map.getId()), this.currentVersion - 1L);
        return map;
    }

    private void scrubLayoutMap() {
        String key;
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String prefix : new String[]{"name.", "map."}) {
            String key2;
            Iterator<String> it = this.layout.keyIterator(prefix);
            while (it.hasNext() && (key2 = it.next()).startsWith(prefix)) {
                this.meta.putIfAbsent(key2, this.layout.get(key2));
                this.markMetaChanged();
                keysToRemove.add(key2);
            }
        }
        Iterator<String> it = this.layout.keyIterator("root.");
        while (it.hasNext() && (key = it.next()).startsWith("root.")) {
            String mapIdStr = key.substring(key.lastIndexOf(46) + 1);
            if (this.meta.containsKey("map." + mapIdStr) || DataUtils.parseHexInt(mapIdStr) == this.meta.getId()) continue;
            keysToRemove.add(key);
        }
        for (String key3 : keysToRemove) {
            this.layout.remove(key3);
        }
    }

    private void scrubMetaMap() {
        String mapName;
        String key2;
        HashSet<String> keysToRemove = new HashSet<String>();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext() && (key2 = it.next()).startsWith("name.")) {
            int mapId;
            String realMapName;
            mapName = key2.substring("name.".length());
            if (mapName.equals(realMapName = this.getMapName(mapId = DataUtils.parseHexInt(this.meta.get(key2))))) continue;
            keysToRemove.add(key2);
        }
        for (String key2 : keysToRemove) {
            this.meta.remove(key2);
            this.markMetaChanged();
        }
        it = this.meta.keyIterator("map.");
        while (it.hasNext() && (key2 = it.next()).startsWith("map.")) {
            mapName = DataUtils.getMapName(this.meta.get(key2));
            String mapIdStr = key2.substring("map.".length());
            int mapId = DataUtils.parseHexInt(mapIdStr);
            if (mapId > this.lastMapId.get()) {
                this.lastMapId.set(mapId);
            }
            if (mapIdStr.equals(this.meta.get("name." + mapName))) continue;
            this.meta.put("name." + mapName, mapIdStr);
            this.markMetaChanged();
        }
    }

    private void unlockAndCheckPanicCondition() {
        this.storeLock.unlock();
        if (this.getPanicException() != null) {
            this.closeImmediately();
        }
    }

    public void panic(MVStoreException e) {
        if (this.isOpen()) {
            this.handleException(e);
            this.panicException = e;
        }
        throw e;
    }

    public MVStoreException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String fileName) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("fileName", fileName);
        return new MVStore(config);
    }

    public <K, V> MVMap<K, V> openMap(String name) {
        return this.openMap(name, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String name, MVMap.MapBuilder<M, K, V> builder) {
        int id = this.getMapId(name);
        if (id >= 0) {
            MVMap<K, V> map = this.getMap(id);
            if (map == null) {
                map = this.openMap(id, builder);
            }
            assert (builder.getKeyType() == null || map.getKeyType().getClass().equals(builder.getKeyType().getClass()));
            assert (builder.getValueType() == null || map.getValueType().getClass().equals(builder.getValueType().getClass()));
            return (M)map;
        }
        HashMap<String, Object> c = new HashMap<String, Object>();
        id = this.lastMapId.incrementAndGet();
        assert (this.getMap(id) == null);
        c.put("id", id);
        c.put("createVersion", this.currentVersion);
        Object map = builder.create(this, c);
        String x = Integer.toHexString(id);
        this.meta.put(MVMap.getMapKey(id), ((MVMap)map).asString(name));
        String existing = this.meta.putIfAbsent("name." + name, x);
        if (existing != null) {
            this.meta.remove(MVMap.getMapKey(id));
            return this.openMap(name, builder);
        }
        long lastStoredVersion = this.currentVersion - 1L;
        ((MVMap)map).setRootPos(0L, lastStoredVersion);
        this.markMetaChanged();
        MVMap<?, ?> existingMap = this.maps.putIfAbsent(id, (MVMap<?, ?>)map);
        if (existingMap != null) {
            map = existingMap;
        }
        return map;
    }

    public <M extends MVMap<K, V>, K, V> M openMap(int id, MVMap.MapBuilder<M, K, V> builder) {
        MVMap<K, V> map;
        while ((map = this.getMap(id)) == null) {
            String configAsString = this.meta.get(MVMap.getMapKey(id));
            DataUtils.checkArgument(configAsString != null, "Missing map with id {0}", id);
            HashMap<String, Object> config = new HashMap<String, Object>(DataUtils.parseMap(configAsString));
            config.put("id", (String)((Object)Integer.valueOf(id)));
            map = builder.create(this, config);
            long root = this.getRootPos(id);
            long lastStoredVersion = this.currentVersion - 1L;
            map.setRootPos(root, lastStoredVersion);
            if (this.maps.putIfAbsent(id, map) != null) continue;
            break;
        }
        return (M)map;
    }

    public <K, V> MVMap<K, V> getMap(int id) {
        this.checkOpen();
        MVMap<?, ?> map = this.maps.get(id);
        return map;
    }

    public Set<String> getMapNames() {
        String x;
        HashSet<String> set = new HashSet<String>();
        this.checkOpen();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext() && (x = it.next()).startsWith("name.")) {
            String mapName = x.substring("name.".length());
            set.add(mapName);
        }
        return set;
    }

    public MVMap<String, String> getLayoutMap() {
        this.checkOpen();
        return this.layout;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getLayoutMap(long version) {
        Chunk c = this.getChunkForVersion(version);
        DataUtils.checkArgument(c != null, "Unknown version {0}", version);
        long block = c.block;
        c = this.readChunkHeader(block);
        MVMap<String, String> oldMap = this.layout.openReadOnly(c.layoutRootPos, version);
        return oldMap;
    }

    private Chunk getChunkForVersion(long version) {
        Chunk newest = null;
        for (Chunk c : this.chunks.values()) {
            if (c.version > version || newest != null && c.id <= newest.id) continue;
            newest = c;
        }
        return newest;
    }

    public boolean hasMap(String name) {
        return this.meta.containsKey("name." + name);
    }

    public boolean hasData(String name) {
        return this.hasMap(name) && this.getRootPos(this.getMapId(name)) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader() {
        Chunk newest = null;
        boolean assumeCleanShutdown = true;
        boolean validStoreHeader = false;
        ByteBuffer fileHeaderBlocks = this.fileStore.readFully(0L, 8192);
        byte[] buff = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            fileHeaderBlocks.get(buff);
            try {
                HashMap<String, String> m = DataUtils.parseChecksummedMap(buff);
                if (m == null) {
                    assumeCleanShutdown = false;
                    continue;
                }
                long version = DataUtils.readHexLong(m, HDR_VERSION, 0L);
                boolean bl = assumeCleanShutdown = assumeCleanShutdown && (newest == null || version == newest.version);
                if (newest != null && version <= newest.version) continue;
                validStoreHeader = true;
                this.storeHeader.putAll(m);
                this.creationTime = DataUtils.readHexLong(m, HDR_CREATED, 0L);
                int chunkId = DataUtils.readHexInt(m, HDR_CHUNK, 0);
                long block = DataUtils.readHexLong(m, HDR_BLOCK, 2L);
                Chunk test = this.readChunkHeaderAndFooter(block, chunkId);
                if (test == null) continue;
                newest = test;
                continue;
            }
            catch (Exception ignore) {
                assumeCleanShutdown = false;
            }
        }
        if (!validStoreHeader) {
            throw DataUtils.newMVStoreException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        int blockSize = DataUtils.readHexInt(this.storeHeader, HDR_BLOCK_SIZE, 4096);
        if (blockSize != 4096) {
            throw DataUtils.newMVStoreException(5, "Block size {0} is currently not supported", blockSize);
        }
        long format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT, 1L);
        if (!this.fileStore.isReadOnly()) {
            if (format > 2L) {
                throw this.getUnsupportedWriteFormatException(format, 2, "The write format {0} is larger than the supported format {1}");
            }
            if (format < 2L) {
                throw this.getUnsupportedWriteFormatException(format, 2, "The write format {0} is smaller than the supported format {1}");
            }
        }
        if ((format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, format)) > 2L) {
            throw DataUtils.newMVStoreException(5, "The read format {0} is larger than the supported format {1}", format, 2);
        }
        if (format < 2L) {
            throw DataUtils.newMVStoreException(5, "The read format {0} is smaller than the supported format {1}", format, 2);
        }
        boolean bl = assumeCleanShutdown = assumeCleanShutdown && newest != null && !this.recoveryMode;
        if (assumeCleanShutdown) {
            assumeCleanShutdown = DataUtils.readHexInt(this.storeHeader, HDR_CLEAN, 0) != 0;
        }
        this.chunks.clear();
        long now = System.currentTimeMillis();
        int year = 1970 + (int)(now / 31557600000L);
        if (year < 2014) {
            this.creationTime = now - (long)this.fileStore.getDefaultRetentionTime();
        } else if (now < this.creationTime) {
            this.creationTime = now;
            this.storeHeader.put(HDR_CREATED, this.creationTime);
        }
        long fileSize = this.fileStore.size();
        long blocksInStore = fileSize / 4096L;
        Comparator chunkComparator = (one, two) -> {
            int result = Long.compare(two.version, one.version);
            if (result == 0) {
                result = Long.compare(one.block, two.block);
            }
            return result;
        };
        HashMap<Long, Chunk> validChunksByLocation = new HashMap<Long, Chunk>();
        if (!assumeCleanShutdown) {
            Chunk tailChunk = this.discoverChunk(blocksInStore);
            if (tailChunk != null) {
                blocksInStore = tailChunk.block;
                validChunksByLocation.put(blocksInStore, tailChunk);
                if (newest == null || tailChunk.version > newest.version) {
                    newest = tailChunk;
                }
            }
            if (newest != null) {
                while (true) {
                    Chunk test;
                    validChunksByLocation.put(newest.block, newest);
                    if (newest.next == 0L || newest.next >= blocksInStore || (test = this.readChunkHeaderAndFooter(newest.next, newest.id + 1)) == null || test.version <= newest.version) break;
                    newest = test;
                }
            }
        }
        if (assumeCleanShutdown) {
            PriorityQueue chunksToVerify = new PriorityQueue(20, Collections.reverseOrder(chunkComparator));
            try {
                Chunk c;
                this.setLastChunk(newest);
                Cursor<String, String> cursor = this.layout.cursor("chunk.");
                while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                    c = Chunk.fromString(cursor.getValue());
                    assert (c.version <= this.currentVersion);
                    this.chunks.putIfAbsent(c.id, c);
                    chunksToVerify.offer(c);
                    if (chunksToVerify.size() != 20) continue;
                    chunksToVerify.poll();
                }
                while (assumeCleanShutdown && (c = (Chunk)chunksToVerify.poll()) != null) {
                    Chunk chunk = this.readChunkHeaderAndFooter(c.block, c.id);
                    assumeCleanShutdown = chunk != null;
                    if (!assumeCleanShutdown) continue;
                    validChunksByLocation.put(chunk.block, chunk);
                }
            }
            catch (MVStoreException ignored) {
                assumeCleanShutdown = false;
            }
        }
        if (!assumeCleanShutdown) {
            boolean quickRecovery = false;
            if (!this.recoveryMode) {
                Chunk[] lastChunkCandidates = validChunksByLocation.values().toArray(new Chunk[0]);
                Arrays.sort(lastChunkCandidates, chunkComparator);
                HashMap<Integer, Chunk> validChunksById = new HashMap<Integer, Chunk>();
                for (Chunk chunk : lastChunkCandidates) {
                    validChunksById.put(chunk.id, chunk);
                }
                quickRecovery = this.findLastChunkWithCompleteValidChunkSet(lastChunkCandidates, validChunksByLocation, validChunksById, false);
            }
            if (!quickRecovery) {
                Chunk chunk;
                long block = blocksInStore;
                while ((chunk = this.discoverChunk(block)) != null) {
                    block = chunk.block;
                    validChunksByLocation.put(block, chunk);
                }
                Chunk[] lastChunkCandidates = validChunksByLocation.values().toArray(new Chunk[0]);
                Arrays.sort(lastChunkCandidates, chunkComparator);
                HashMap<Integer, Chunk> validChunksById = new HashMap<Integer, Chunk>();
                for (Chunk chunk2 : lastChunkCandidates) {
                    validChunksById.put(chunk2.id, chunk2);
                }
                if (!this.findLastChunkWithCompleteValidChunkSet(lastChunkCandidates, validChunksByLocation, validChunksById, true) && this.lastChunk != null) {
                    throw DataUtils.newMVStoreException(6, "File is corrupted - unable to recover a valid set of chunks", new Object[0]);
                }
            }
        }
        this.fileStore.clear();
        for (Chunk c : this.chunks.values()) {
            if (c.isSaved()) {
                long start = c.block * 4096L;
                int length = c.len * 4096;
                this.fileStore.markUsed(start, length);
            }
            if (c.isLive()) continue;
            this.deadChunks.offer(c);
        }
        assert (this.validateFileLength("on open"));
    }

    private MVStoreException getUnsupportedWriteFormatException(long format, int expectedFormat, String s) {
        if ((format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, format)) >= 2L && format <= 2L) {
            s = s + ", and the file was not opened in read-only mode";
        }
        return DataUtils.newMVStoreException(5, s, format, expectedFormat);
    }

    private boolean findLastChunkWithCompleteValidChunkSet(Chunk[] lastChunkCandidates, Map<Long, Chunk> validChunksByLocation, Map<Integer, Chunk> validChunksById, boolean afterFullScan) {
        for (Chunk chunk : lastChunkCandidates) {
            boolean verified = true;
            try {
                this.setLastChunk(chunk);
                Cursor<String, String> cursor = this.layout.cursor("chunk.");
                while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                    Chunk c = Chunk.fromString(cursor.getValue());
                    assert (c.version <= this.currentVersion);
                    Chunk test = this.chunks.putIfAbsent(c.id, c);
                    if (test != null) {
                        c = test;
                    }
                    assert (this.chunks.get(c.id) == c);
                    test = validChunksByLocation.get(c.block);
                    if (test == null || test.id != c.id) {
                        test = validChunksById.get(c.id);
                        if (test != null) {
                            c.block = test.block;
                        } else if (c.isLive() && (afterFullScan || this.readChunkHeaderAndFooter(c.block, c.id) == null)) {
                            verified = false;
                            break;
                        }
                    }
                    if (c.isLive()) continue;
                    c.block = Long.MAX_VALUE;
                    c.len = Integer.MAX_VALUE;
                    if (c.unused == 0L) {
                        c.unused = this.creationTime;
                    }
                    if (c.unusedAtVersion != 0L) continue;
                    c.unusedAtVersion = -1L;
                }
            }
            catch (Exception ignored) {
                verified = false;
            }
            if (!verified) continue;
            return true;
        }
        return false;
    }

    void adoptMetaFrom(MVStore source) {
        this.currentVersion = source.currentVersion;
        this.lastMapId.set(source.lastMapId.get());
    }

    private void setLastChunk(Chunk last) {
        this.chunks.clear();
        this.lastChunk = last;
        this.lastChunkId = 0;
        this.currentVersion = this.lastChunkVersion();
        long layoutRootPos = 0L;
        int mapId = 0;
        if (last != null) {
            this.lastChunkId = last.id;
            this.currentVersion = last.version;
            layoutRootPos = last.layoutRootPos;
            mapId = last.mapId;
            this.chunks.put(last.id, last);
        }
        this.lastMapId.set(mapId);
        this.layout.setRootPos(layoutRootPos, this.currentVersion - 1L);
    }

    private Chunk discoverChunk(long block) {
        long candidateLocation = Long.MAX_VALUE;
        Chunk candidate = null;
        while (block != candidateLocation) {
            if (block == 2L) {
                return null;
            }
            Chunk test = this.readChunkFooter(block);
            if (test != null) {
                candidateLocation = Long.MAX_VALUE;
                test = this.readChunkHeaderOptionally(test.block, test.id);
                if (test != null) {
                    candidate = test;
                    candidateLocation = test.block;
                }
            }
            if (--block <= candidateLocation || this.readChunkHeaderOptionally(block) == null) continue;
            candidateLocation = Long.MAX_VALUE;
        }
        return candidate;
    }

    private Chunk readChunkHeaderAndFooter(long block, int expectedId) {
        Chunk footer;
        Chunk header = this.readChunkHeaderOptionally(block, expectedId);
        if (header != null && ((footer = this.readChunkFooter(block + (long)header.len)) == null || footer.id != expectedId || footer.block != header.block)) {
            return null;
        }
        return header;
    }

    private Chunk readChunkFooter(long block) {
        try {
            long pos = block * 4096L - 128L;
            if (pos < 0L) {
                return null;
            }
            ByteBuffer lastBlock = this.fileStore.readFully(pos, 128);
            byte[] buff = new byte[128];
            lastBlock.get(buff);
            HashMap<String, String> m = DataUtils.parseChecksummedMap(buff);
            if (m != null) {
                return new Chunk(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        Chunk lastChunk = this.lastChunk;
        if (lastChunk != null) {
            this.storeHeader.put(HDR_BLOCK, lastChunk.block);
            this.storeHeader.put(HDR_CHUNK, lastChunk.id);
            this.storeHeader.put(HDR_VERSION, lastChunk.version);
        }
        StringBuilder buff = new StringBuilder(112);
        DataUtils.appendMap(buff, this.storeHeader);
        byte[] bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        int checksum = DataUtils.getFletcher32(bytes, 0, bytes.length);
        DataUtils.appendMap(buff, HDR_FLETCHER, checksum);
        buff.append('\n');
        bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer header = ByteBuffer.allocate(8192);
        header.put(bytes);
        header.position(4096);
        header.put(bytes);
        header.rewind();
        this.write(0L, header);
    }

    private void write(long pos, ByteBuffer buffer) {
        try {
            this.fileStore.writeFully(pos, buffer);
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
    }

    @Override
    public void close() {
        this.closeStore(true, 0);
    }

    public void close(int allowedCompactionTime) {
        this.closeStore(true, allowedCompactionTime);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false, 0);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean normalShutdown, int allowedCompactionTime) {
        while (!this.isClosed()) {
            this.stopBackgroundThread(normalShutdown);
            this.setOldestVersionTracker(null);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (normalShutdown && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> map : this.maps.values()) {
                                if (!map.isClosed()) continue;
                                this.deregisterMapRoot(map.getId());
                            }
                            this.setRetentionTime(0);
                            this.commit();
                            if (allowedCompactionTime > 0) {
                                this.compactFile(allowedCompactionTime);
                            } else if (allowedCompactionTime < 0) {
                                this.doMaintenance(this.autoCompactFillRate);
                            }
                            this.saveChunkLock.lock();
                            try {
                                this.shrinkFileIfPossible(0);
                                this.storeHeader.put(HDR_CLEAN, 1);
                                this.writeStoreHeader();
                                this.sync();
                                assert (this.validateFileLength("on close"));
                            }
                            finally {
                                this.saveChunkLock.unlock();
                            }
                        }
                        this.state = 2;
                        this.clearCaches();
                        for (MVMap<?, ?> m : new ArrayList(this.maps.values())) {
                            m.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || !this.fileStoreShallBeClosed) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private Chunk getChunk(long pos) {
        int chunkId = DataUtils.getPageChunkId(pos);
        Chunk c = this.chunks.get(chunkId);
        if (c == null) {
            this.checkOpen();
            String s = this.layout.get(Chunk.getMetaKey(chunkId));
            if (s == null) {
                throw DataUtils.newMVStoreException(9, "Chunk {0} not found", chunkId);
            }
            c = Chunk.fromString(s);
            if (!c.isSaved()) {
                throw DataUtils.newMVStoreException(6, "Chunk {0} is invalid", chunkId);
            }
            this.chunks.put(c.id, c);
        }
        return c;
    }

    private void setWriteVersion(long version) {
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            assert (map != this.layout && map != this.meta);
            if (map.setWriteVersion(version) != null) continue;
            iter.remove();
        }
        this.meta.setWriteVersion(version);
        this.layout.setWriteVersion(version);
        this.onVersionChange(version);
    }

    public long tryCommit() {
        return this.tryCommit(x -> true);
    }

    private long tryCommit(Predicate<MVStore> check) {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                if (check.test(this)) {
                    this.store(false);
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return this.currentVersion;
    }

    public long commit() {
        return this.commit(x -> true);
    }

    private long commit(Predicate<MVStore> check) {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            this.storeLock.lock();
            try {
                if (check.test(this)) {
                    this.store(true);
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return this.currentVersion;
    }

    private void store(boolean syncWrite) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (!this.saveChunkLock.isHeldByCurrentThread());
        if (this.isOpenOrStopping() && this.hasUnsavedChanges()) {
            this.dropUnusedChunks();
            try {
                this.currentStoreVersion = this.currentVersion++;
                if (this.fileStore == null) {
                    this.setWriteVersion(this.currentVersion);
                    this.metaChanged = false;
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newMVStoreException(2, "This store is read-only", new Object[0]);
                    }
                    this.storeNow(syncWrite, 0L, () -> this.reuseSpace ? 0L : this.getAfterLastBlock());
                }
            }
            finally {
                this.currentStoreVersion = -1L;
            }
        }
    }

    private void storeNow(boolean syncWrite, long reservedLow, Supplier<Long> reservedHighSupplier) {
        try {
            this.lastCommitTime = this.getTimeSinceCreation();
            int currentUnsavedPageCount = this.unsavedMemory;
            long version = ++this.currentVersion;
            ArrayList<Page<?, ?>> changed = this.collectChangedMapRoots(version);
            assert (this.storeLock.isHeldByCurrentThread());
            MVStore.submitOrRun(this.serializationExecutor, () -> this.serializeAndStore(syncWrite, reservedLow, reservedHighSupplier, changed, this.lastCommitTime, version), syncWrite);
            this.saveNeeded = false;
            this.unsavedMemory = Math.max(0, this.unsavedMemory - currentUnsavedPageCount);
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
        }
    }

    private static void submitOrRun(ThreadPoolExecutor executor, Runnable action, boolean syncRun) throws ExecutionException {
        if (executor != null) {
            try {
                Future<?> future = executor.submit(action);
                if (syncRun || executor.getQueue().size() > 1) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (RejectedExecutionException ex) {
                assert (executor.isShutdown());
                Utils.shutdownExecutor(executor);
            }
        }
        action.run();
    }

    private ArrayList<Page<?, ?>> collectChangedMapRoots(long version) {
        long lastStoredVersion = version - 2L;
        ArrayList changed = new ArrayList();
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            RootReference<?, ?> rootReference = map.setWriteVersion(version);
            if (rootReference == null) {
                iter.remove();
                continue;
            }
            if (map.getCreateVersion() >= version || map.isVolatile() || !map.hasChangesSince(lastStoredVersion)) continue;
            assert (rootReference.version <= version) : rootReference.version + " > " + version;
            Page rootPage = rootReference.root;
            if (rootPage.isSaved() && !rootPage.isLeaf()) continue;
            changed.add(rootPage);
        }
        RootReference<String, String> rootReference = this.meta.setWriteVersion(version);
        if (this.meta.hasChangesSince(lastStoredVersion) || this.metaChanged) {
            assert (rootReference != null && rootReference.version <= version) : rootReference == null ? "null" : rootReference.version + " > " + version;
            Page rootPage = rootReference.root;
            if (!rootPage.isSaved() || rootPage.isLeaf()) {
                changed.add(rootPage);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeAndStore(boolean syncRun, long reservedLow, Supplier<Long> reservedHighSupplier, ArrayList<Page<?, ?>> changed, long time, long version) {
        this.serializationLock.lock();
        try {
            Chunk c = this.createChunk(time, version);
            this.chunks.put(c.id, c);
            WriteBuffer buff = this.getWriteBuffer();
            this.serializeToBuffer(buff, changed, c, reservedLow, reservedHighSupplier);
            MVStore.submitOrRun(this.bufferSaveExecutor, () -> this.storeBuffer(c, buff, changed), syncRun);
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    private Chunk createChunk(long time, long version) {
        int newChunkId;
        Chunk old;
        int chunkId = this.lastChunkId;
        if (chunkId != 0) {
            Chunk lastChunk = this.chunks.get(chunkId &= 0x3FFFFFF);
            assert (lastChunk != null);
            assert (lastChunk.isSaved());
            assert (lastChunk.version + 1L == version) : lastChunk.version + " " + version;
            this.layout.put(Chunk.getMetaKey(chunkId), lastChunk.asString());
            time = Math.max(lastChunk.time, time);
        }
        while ((old = this.chunks.get(newChunkId = ++this.lastChunkId & 0x3FFFFFF)) != null) {
            if (old.isSaved()) continue;
            MVStoreException e = DataUtils.newMVStoreException(3, "Last block {0} not stored, possibly due to out-of-memory", old);
            this.panic(e);
        }
        Chunk c = new Chunk(newChunkId);
        c.pageCount = 0;
        c.pageCountLive = 0;
        c.maxLen = 0L;
        c.maxLenLive = 0L;
        c.layoutRootPos = Long.MAX_VALUE;
        c.block = Long.MAX_VALUE;
        c.len = Integer.MAX_VALUE;
        c.time = time;
        c.version = version;
        c.next = Long.MAX_VALUE;
        c.occupancy = new BitSet();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeToBuffer(WriteBuffer buff, ArrayList<Page<?, ?>> changed, Chunk c, long reservedLow, Supplier<Long> reservedHighSupplier) {
        c.writeChunkHeader(buff, 0);
        int headerLength = buff.position() + 44;
        buff.position(headerLength);
        long version = c.version;
        ArrayList<Long> toc = new ArrayList<Long>();
        for (Page<?, ?> p : changed) {
            String key = MVMap.getMapRootKey(p.getMapId());
            if (p.getTotalCount() == 0L) {
                this.layout.remove(key);
                continue;
            }
            p.writeUnsavedRecursive(c, buff, toc);
            long root = p.getPos();
            this.layout.put(key, Long.toHexString(root));
        }
        this.acceptChunkOccupancyChanges(c.time, version);
        RootReference<String, String> layoutRootReference = this.layout.setWriteVersion(version);
        assert (layoutRootReference != null);
        assert (layoutRootReference.version == version) : layoutRootReference.version + " != " + version;
        this.metaChanged = false;
        this.acceptChunkOccupancyChanges(c.time, version);
        this.onVersionChange(version);
        Page layoutRoot = layoutRootReference.root;
        layoutRoot.writeUnsavedRecursive(c, buff, toc);
        c.layoutRootPos = layoutRoot.getPos();
        changed.add(layoutRoot);
        c.mapId = this.lastMapId.get();
        c.tocPos = buff.position();
        long[] tocArray = new long[toc.size()];
        int index = 0;
        Iterator iterator = toc.iterator();
        while (iterator.hasNext()) {
            long tocElement = (Long)iterator.next();
            tocArray[index++] = tocElement;
            buff.putLong(tocElement);
            if (DataUtils.isLeafPosition(tocElement)) {
                ++this.leafCount;
                continue;
            }
            ++this.nonLeafCount;
        }
        this.chunksToC.put(c.id, tocArray);
        int chunkLength = buff.position();
        int length = MathUtils.roundUpInt(chunkLength + 128, 4096);
        buff.limit(length);
        this.saveChunkLock.lock();
        try {
            Long reservedHigh = reservedHighSupplier.get();
            long filePos = this.fileStore.allocate(buff.limit(), reservedLow, reservedHigh);
            c.len = buff.limit() / 4096;
            c.block = filePos / 4096L;
            assert (this.validateFileLength(c.asString()));
            c.next = reservedLow > 0L || reservedHigh == reservedLow ? this.fileStore.predictAllocation(c.len, 0L, 0L) : 0L;
            assert (c.pageCountLive == c.pageCount) : c;
            assert (c.occupancy.cardinality() == 0) : c;
            buff.position(0);
            assert (c.pageCountLive == c.pageCount) : c;
            assert (c.occupancy.cardinality() == 0) : c;
            c.writeChunkHeader(buff, headerLength);
            buff.position(buff.limit() - 128);
            buff.put(c.getFooterBytes());
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBuffer(Chunk c, WriteBuffer buff, ArrayList<Page<?, ?>> changed) {
        this.saveChunkLock.lock();
        try {
            buff.position(0);
            long filePos = c.block * 4096L;
            this.write(filePos, buff.getBuffer());
            this.releaseWriteBuffer(buff);
            boolean storeAtEndOfFile = filePos + (long)buff.limit() >= this.fileStore.size();
            boolean writeStoreHeader = this.isWriteStoreHeader(c, storeAtEndOfFile);
            this.lastChunk = c;
            if (writeStoreHeader) {
                this.writeStoreHeader();
            }
            if (!storeAtEndOfFile) {
                this.shrinkFileIfPossible(1);
            }
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
        }
        finally {
            this.saveChunkLock.unlock();
        }
        for (Page<?, ?> p : changed) {
            p.releaseSavedPages();
        }
    }

    private boolean isWriteStoreHeader(Chunk c, boolean storeAtEndOfFile) {
        boolean writeStoreHeader = false;
        if (!storeAtEndOfFile) {
            Chunk lastChunk = this.lastChunk;
            if (lastChunk == null) {
                writeStoreHeader = true;
            } else if (lastChunk.next != c.block) {
                writeStoreHeader = true;
            } else {
                long headerVersion = DataUtils.readHexLong(this.storeHeader, HDR_VERSION, 0L);
                if (lastChunk.version - headerVersion > 20L) {
                    writeStoreHeader = true;
                } else {
                    for (int chunkId = DataUtils.readHexInt(this.storeHeader, HDR_CHUNK, 0); !writeStoreHeader && chunkId <= lastChunk.id; ++chunkId) {
                        writeStoreHeader = !this.chunks.containsKey(chunkId);
                    }
                }
            }
        }
        if (this.storeHeader.remove(HDR_CLEAN) != null) {
            writeStoreHeader = true;
        }
        return writeStoreHeader;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer buff = this.writeBufferPool.poll();
        if (buff != null) {
            buff.clear();
        } else {
            buff = new WriteBuffer();
        }
        return buff;
    }

    private void releaseWriteBuffer(WriteBuffer buff) {
        if (buff.capacity() <= 0x400000) {
            this.writeBufferPool.offer(buff);
        }
    }

    private static boolean canOverwriteChunk(Chunk c, long oldestVersionToKeep) {
        return !c.isLive() && c.unusedAtVersion < oldestVersionToKeep;
    }

    private boolean isSeasonedChunk(Chunk chunk, long time) {
        return this.retentionTime < 0 || chunk.time + (long)this.retentionTime <= time;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long now = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && now < this.lastTimeAbsolute) {
            now = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = now;
        }
        return now;
    }

    private void acceptChunkOccupancyChanges(long time, long version) {
        assert (this.serializationLock.isHeldByCurrentThread());
        if (this.lastChunk != null) {
            HashSet<Chunk> modifiedChunks = new HashSet<Chunk>();
            while (true) {
                RemovedPageInfo rpi;
                if ((rpi = this.removedPages.peek()) != null && rpi.version < version) {
                    rpi = this.removedPages.poll();
                    assert (rpi != null);
                    assert (rpi.version < version) : rpi + " < " + version;
                    int chunkId = rpi.getPageChunkId();
                    Chunk chunk = this.chunks.get(chunkId);
                    assert (!this.isOpen() || chunk != null) : chunkId;
                    if (chunk == null) continue;
                    modifiedChunks.add(chunk);
                    if (!chunk.accountForRemovedPage(rpi.getPageNo(), rpi.getPageLength(), rpi.isPinned(), time, rpi.version)) continue;
                    this.deadChunks.offer(chunk);
                    continue;
                }
                if (modifiedChunks.isEmpty()) {
                    return;
                }
                for (Chunk chunk : modifiedChunks) {
                    int chunkId = chunk.id;
                    this.layout.put(Chunk.getMetaKey(chunkId), chunk.asString());
                }
                modifiedChunks.clear();
            }
        }
    }

    private void shrinkFileIfPossible(int minPercent) {
        long fileSize;
        assert (this.saveChunkLock.isHeldByCurrentThread());
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long end = this.getFileLengthInUse();
        if (end >= (fileSize = this.fileStore.size())) {
            return;
        }
        if (minPercent > 0 && fileSize - end < 4096L) {
            return;
        }
        int savedPercent = (int)(100L - end * 100L / fileSize);
        if (savedPercent < minPercent) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(end);
    }

    private long getFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long result = this.fileStore.getFileLengthInUse();
        assert (result == this.measureFileLengthInUse()) : result + " != " + this.measureFileLengthInUse();
        return result;
    }

    private long getAfterLastBlock() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        return this.fileStore.getAfterLastBlock();
    }

    private long measureFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long size = 2L;
        for (Chunk c : this.chunks.values()) {
            if (!c.isSaved()) continue;
            size = Math.max(size, c.block + (long)c.len);
        }
        return size * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        long lastStoredVersion = this.currentVersion - 1L;
        for (MVMap<?, ?> m : this.maps.values()) {
            if (m.isClosed() || !m.hasChangesSince(lastStoredVersion)) continue;
            return true;
        }
        return this.layout.hasChangesSince(lastStoredVersion) && lastStoredVersion > -1L;
    }

    private Chunk readChunkHeader(long block) {
        long p = block * 4096L;
        ByteBuffer buff = this.fileStore.readFully(p, 1024);
        return Chunk.readChunkHeader(buff, p);
    }

    private Chunk readChunkHeaderOptionally(long block) {
        try {
            Chunk chunk = this.readChunkHeader(block);
            return chunk.block != block ? null : chunk;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private Chunk readChunkHeaderOptionally(long block, int expectedId) {
        Chunk chunk = this.readChunkHeaderOptionally(block);
        return chunk == null || chunk.id != expectedId ? null : chunk;
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compactMoveChunks(int targetFillRate, long moveSize) {
        boolean res = false;
        this.storeLock.lock();
        try {
            this.checkOpen();
            Utils.flushExecutor(this.serializationExecutor);
            this.serializationLock.lock();
            try {
                Utils.flushExecutor(this.bufferSaveExecutor);
                this.saveChunkLock.lock();
                try {
                    if (this.lastChunk != null && this.reuseSpace && this.getFillRate() <= targetFillRate) {
                        res = this.compactMoveChunks(moveSize);
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            finally {
                this.serializationLock.unlock();
            }
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
        return res;
    }

    private boolean compactMoveChunks(long moveSize) {
        assert (this.storeLock.isHeldByCurrentThread());
        this.dropUnusedChunks();
        long start = this.fileStore.getFirstFree() / 4096L;
        Iterable<Chunk> chunksToMove = this.findChunksToMove(start, moveSize);
        if (chunksToMove == null) {
            return false;
        }
        this.compactMoveChunks(chunksToMove);
        return true;
    }

    private Iterable<Chunk> findChunksToMove(long startBlock, long moveSize) {
        long maxBlocksToMove = moveSize / 4096L;
        ArrayList<Chunk> result = null;
        if (maxBlocksToMove > 0L) {
            PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 2 + 1, (o1, o2) -> {
                int res = Integer.compare(o2.collectPriority, o1.collectPriority);
                if (res != 0) {
                    return res;
                }
                return Long.signum(o2.block - o1.block);
            });
            long size = 0L;
            for (Chunk chunk : this.chunks.values()) {
                Chunk removed;
                if (!chunk.isSaved() || chunk.block <= startBlock) continue;
                chunk.collectPriority = this.getMovePriority(chunk);
                queue.offer(chunk);
                size += (long)chunk.len;
                while (size > maxBlocksToMove && (removed = (Chunk)queue.poll()) != null) {
                    size -= (long)removed.len;
                }
            }
            if (!queue.isEmpty()) {
                ArrayList<Chunk> list = new ArrayList<Chunk>(queue);
                list.sort(Chunk.PositionComparator.INSTANCE);
                result = list;
            }
        }
        return result;
    }

    private int getMovePriority(Chunk chunk) {
        return this.fileStore.getMovePriority((int)chunk.block);
    }

    private void compactMoveChunks(Iterable<Chunk> move) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.serializationLock.isHeldByCurrentThread());
        assert (this.saveChunkLock.isHeldByCurrentThread());
        if (move != null) {
            this.writeStoreHeader();
            this.sync();
            Iterator<Chunk> iterator = move.iterator();
            assert (iterator.hasNext());
            long leftmostBlock = iterator.next().block;
            long originalBlockCount = this.getAfterLastBlock();
            for (Chunk chunk : move) {
                this.moveChunk(chunk, leftmostBlock, originalBlockCount);
            }
            this.store(leftmostBlock, originalBlockCount);
            this.sync();
            Chunk chunkToMove = this.lastChunk;
            assert (chunkToMove != null);
            long postEvacuationBlockCount = this.getAfterLastBlock();
            boolean chunkToMoveIsAlreadyInside = chunkToMove.block < leftmostBlock;
            boolean movedToEOF = !chunkToMoveIsAlreadyInside;
            for (Chunk c : move) {
                if (c.block < originalBlockCount || !this.moveChunk(c, originalBlockCount, postEvacuationBlockCount)) continue;
                assert (c.block < originalBlockCount);
                movedToEOF = true;
            }
            assert (postEvacuationBlockCount >= this.getAfterLastBlock());
            if (movedToEOF) {
                boolean moved = this.moveChunkInside(chunkToMove, originalBlockCount);
                this.store(originalBlockCount, postEvacuationBlockCount);
                this.sync();
                long lastBoundary = moved || chunkToMoveIsAlreadyInside ? postEvacuationBlockCount : chunkToMove.block;
                boolean bl = moved = !moved && this.moveChunkInside(chunkToMove, lastBoundary);
                if (this.moveChunkInside(this.lastChunk, lastBoundary) || moved) {
                    this.store(lastBoundary, -1L);
                }
            }
            this.shrinkFileIfPossible(0);
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(long reservedLow, long reservedHigh) {
        this.saveChunkLock.unlock();
        try {
            this.serializationLock.unlock();
            try {
                this.storeNow(true, reservedLow, () -> reservedHigh);
            }
            finally {
                this.serializationLock.lock();
            }
        }
        finally {
            this.saveChunkLock.lock();
        }
    }

    private boolean moveChunkInside(Chunk chunkToMove, long boundary) {
        boolean res;
        boolean bl = res = chunkToMove.block >= boundary && this.fileStore.predictAllocation(chunkToMove.len, boundary, -1L) < boundary && this.moveChunk(chunkToMove, boundary, -1L);
        assert (!res || chunkToMove.block + (long)chunkToMove.len <= boundary);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveChunk(Chunk chunk, long reservedAreaLow, long reservedAreaHigh) {
        long block;
        if (!this.chunks.containsKey(chunk.id)) {
            return false;
        }
        long start = chunk.block * 4096L;
        int length = chunk.len * 4096;
        WriteBuffer buff = this.getWriteBuffer();
        try {
            buff.limit(length);
            ByteBuffer readBuff = this.fileStore.readFully(start, length);
            Chunk chunkFromFile = Chunk.readChunkHeader(readBuff, start);
            int chunkHeaderLen = readBuff.position();
            buff.position(chunkHeaderLen);
            buff.put(readBuff);
            long pos = this.fileStore.allocate(length, reservedAreaLow, reservedAreaHigh);
            block = pos / 4096L;
            assert (reservedAreaHigh > 0L || block <= chunk.block) : block + " " + chunk;
            buff.position(0);
            chunkFromFile.block = block;
            chunkFromFile.next = 0L;
            chunkFromFile.writeChunkHeader(buff, chunkHeaderLen);
            buff.position(length - 128);
            buff.put(chunkFromFile.getFooterBytes());
            buff.position(0);
            this.write(pos, buff.getBuffer());
        }
        finally {
            this.releaseWriteBuffer(buff);
        }
        this.fileStore.free(start, length);
        chunk.block = block;
        chunk.next = 0L;
        this.layout.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        return true;
    }

    public void sync() {
        this.checkOpen();
        FileStore f = this.fileStore;
        if (f != null) {
            f.sync();
        }
    }

    public void compactFile(int maxCompactTime) {
        this.setRetentionTime(0);
        long stopAt = System.nanoTime() + (long)maxCompactTime * 1000000L;
        while (this.compact(95, 0x1000000)) {
            this.sync();
            this.compactMoveChunks(95, 0x1000000L);
            if (System.nanoTime() - stopAt <= 0L) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int targetFillRate, int write) {
        block7: {
            if (this.reuseSpace && this.lastChunk != null) {
                this.checkOpen();
                if (targetFillRate > 0 && this.getChunksFillRate() < targetFillRate) {
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break block7;
                    try {
                        boolean bl = this.rewriteChunks(write, 100);
                        this.storeLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.storeLock.unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteChunks(int writeLimit, int targetFillRate) {
        this.serializationLock.lock();
        try {
            TxCounter txCounter = this.registerVersionUsage();
            try {
                this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
                Iterable<Chunk> old = this.findOldChunks(writeLimit, targetFillRate);
                if (old != null) {
                    HashSet<Integer> idSet = MVStore.createIdSet(old);
                    boolean bl = !idSet.isEmpty() && this.compactRewrite(idSet) > 0;
                    return bl;
                }
            }
            finally {
                this.deregisterVersionUsage(txCounter);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public int getChunksFillRate() {
        return this.getChunksFillRate(true);
    }

    public int getRewritableChunksFillRate() {
        return this.getChunksFillRate(false);
    }

    private int getChunksFillRate(boolean all) {
        long maxLengthSum = 1L;
        long maxLengthLiveSum = 1L;
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            if (!all && !this.isRewritable(c, time)) continue;
            assert (c.maxLen >= 0L);
            maxLengthSum += c.maxLen;
            maxLengthLiveSum += c.maxLenLive;
        }
        int fillRate = (int)(100L * maxLengthLiveSum / maxLengthSum);
        return fillRate;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public int getPageCount() {
        int count = 0;
        for (Chunk chunk : this.chunks.values()) {
            count += chunk.pageCount;
        }
        return count;
    }

    public int getLivePageCount() {
        int count = 0;
        for (Chunk chunk : this.chunks.values()) {
            count += chunk.pageCountLive;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getProjectedFillRate(int thresholdChunkFillRate) {
        this.saveChunkLock.lock();
        try {
            int fillRate;
            int vacatedBlocks = 0;
            long maxLengthSum = 1L;
            long maxLengthLiveSum = 1L;
            long time = this.getTimeSinceCreation();
            for (Chunk c : this.chunks.values()) {
                assert (c.maxLen >= 0L);
                if (!this.isRewritable(c, time) || c.getFillRate() > thresholdChunkFillRate) continue;
                assert (c.maxLen >= c.maxLenLive);
                vacatedBlocks += c.len;
                maxLengthSum += c.maxLen;
                maxLengthLiveSum += c.maxLenLive;
            }
            int additionalBlocks = (int)((long)vacatedBlocks * maxLengthLiveSum / maxLengthSum);
            int n = fillRate = this.fileStore.getProjectedFillRate(vacatedBlocks - additionalBlocks);
            return n;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    public int getFillRate() {
        this.saveChunkLock.lock();
        try {
            int n = this.fileStore.getFillRate();
            return n;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    private Iterable<Chunk> findOldChunks(int writeLimit, int targetFillRate) {
        assert (this.lastChunk != null);
        long time = this.getTimeSinceCreation();
        PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 4 + 1, (o1, o2) -> {
            int comp = Integer.compare(o2.collectPriority, o1.collectPriority);
            if (comp == 0) {
                comp = Long.compare(o2.maxLenLive, o1.maxLenLive);
            }
            return comp;
        });
        long totalSize = 0L;
        long latestVersion = this.lastChunk.version + 1L;
        for (Chunk chunk : this.chunks.values()) {
            Chunk removed;
            int fillRate = chunk.getFillRate();
            if (!this.isRewritable(chunk, time) || fillRate > targetFillRate) continue;
            long age = Math.max(1L, latestVersion - chunk.version);
            chunk.collectPriority = (int)((long)(fillRate * 1000) / age);
            totalSize += chunk.maxLenLive;
            queue.offer(chunk);
            while (totalSize > (long)writeLimit && (removed = queue.poll()) != null) {
                totalSize -= removed.maxLenLive;
            }
        }
        return queue.isEmpty() ? null : queue;
    }

    private boolean isRewritable(Chunk chunk, long time) {
        return chunk.isRewritable() && this.isSeasonedChunk(chunk, time);
    }

    private int compactRewrite(Set<Integer> set) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.currentStoreVersion < 0L);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
        int rewrittenPageCount = this.rewriteChunks(set, false);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
        return rewrittenPageCount += this.rewriteChunks(set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rewriteChunks(Set<Integer> set, boolean secondPass) {
        int rewrittenPageCount = 0;
        for (int chunkId : set) {
            Chunk chunk = this.chunks.get(chunkId);
            long[] toc = this.getToC(chunk);
            if (toc == null) continue;
            int pageNo = 0;
            while ((pageNo = chunk.occupancy.nextClearBit(pageNo)) < chunk.pageCount) {
                MVMap<String, String> map;
                long tocElement = toc[pageNo];
                int mapId = DataUtils.getPageMapId(tocElement);
                MVMap<String, String> mVMap = mapId == this.layout.getId() ? this.layout : (map = mapId == this.meta.getId() ? this.meta : this.getMap(mapId));
                if (map != null && !map.isClosed()) {
                    assert (!map.isSingleWriter());
                    if (secondPass || DataUtils.isLeafPosition(tocElement)) {
                        long pagePos = DataUtils.getPagePos(chunkId, tocElement);
                        this.serializationLock.unlock();
                        try {
                            if (map.rewritePage(pagePos)) {
                                ++rewrittenPageCount;
                                if (map == this.meta) {
                                    this.markMetaChanged();
                                }
                            }
                        }
                        finally {
                            this.serializationLock.lock();
                        }
                    }
                }
                ++pageNo;
            }
        }
        return rewrittenPageCount;
    }

    private static HashSet<Integer> createIdSet(Iterable<Chunk> toCompact) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Chunk c : toCompact) {
            set.add(c.id);
        }
        return set;
    }

    <K, V> Page<K, V> readPage(MVMap<K, V> map, long pos) {
        try {
            if (!DataUtils.isPageSaved(pos)) {
                throw DataUtils.newMVStoreException(6, "Position 0", new Object[0]);
            }
            Page<K, V> p = this.readPageFromCache(pos);
            if (p == null) {
                Chunk chunk = this.getChunk(pos);
                int pageOffset = DataUtils.getPageOffset(pos);
                try {
                    ByteBuffer buff = chunk.readBufferForPage(this.fileStore, pageOffset, pos);
                    p = Page.read(buff, pos, map);
                }
                catch (MVStoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw DataUtils.newMVStoreException(6, "Unable to read the page at position {0}, chunk {1}, offset {2}", pos, chunk.id, pageOffset, e);
                }
                this.cachePage(p);
            }
            return p;
        }
        catch (MVStoreException e) {
            if (this.recoveryMode) {
                return map.createEmptyLeaf();
            }
            throw e;
        }
    }

    private long[] getToC(Chunk chunk) {
        if (chunk.tocPos == 0) {
            return null;
        }
        long[] toc = this.chunksToC.get(chunk.id);
        if (toc == null) {
            toc = chunk.readToC(this.fileStore);
            this.chunksToC.put(chunk.id, toc, toc.length * 8);
        }
        assert (toc.length == chunk.pageCount) : toc.length + " != " + chunk.pageCount;
        return toc;
    }

    private <K, V> Page<K, V> readPageFromCache(long pos) {
        return this.cache == null ? null : this.cache.get(pos);
    }

    void accountForRemovedPage(long pos, long version, boolean pinned, int pageNo) {
        assert (DataUtils.isPageSaved(pos));
        if (pageNo < 0) {
            pageNo = this.calculatePageNo(pos);
        }
        RemovedPageInfo rpi = new RemovedPageInfo(pos, pinned, version, pageNo);
        this.removedPages.add(rpi);
    }

    private int calculatePageNo(long pos) {
        int pageNo = -1;
        Chunk chunk = this.getChunk(pos);
        long[] toC = this.getToC(chunk);
        if (toC != null) {
            int offset = DataUtils.getPageOffset(pos);
            int low = 0;
            int high = toC.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                long midVal = DataUtils.getPageOffset(toC[mid]);
                if (midVal < (long)offset) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > (long)offset) {
                    high = mid - 1;
                    continue;
                }
                pageNo = mid;
                break;
            }
        }
        return pageNo;
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.cache == null ? Long.MAX_VALUE : this.cache.getMaxItemSize() >> 4;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean reuseSpace) {
        this.reuseSpace = reuseSpace;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int ms) {
        this.retentionTime = ms;
    }

    public boolean isVersioningRequired() {
        return this.fileStore != null || this.versionsToKeep > 0;
    }

    public void setVersionsToKeep(int count) {
        this.versionsToKeep = count;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long storeVersion;
        long v = this.oldestVersionToKeep.get();
        v = Math.max(v - (long)this.versionsToKeep, -1L);
        if (this.fileStore != null && (storeVersion = this.lastChunkVersion() - 1L) != -1L && storeVersion < v) {
            v = storeVersion;
        }
        return v;
    }

    private void setOldestVersionToKeep(long version) {
        long current;
        boolean success;
        while (!(success = version <= (current = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(current, version))) {
        }
        if (this.oldestVersionTracker != null) {
            this.oldestVersionTracker.accept(version);
        }
    }

    public void setOldestVersionTracker(LongConsumer callback) {
        this.oldestVersionTracker = callback;
    }

    private long lastChunkVersion() {
        Chunk chunk = this.lastChunk;
        return chunk == null ? 0L : chunk.version;
    }

    private boolean isKnownVersion(long version) {
        if (version > this.currentVersion || version < 0L) {
            return false;
        }
        if (version == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk c = this.getChunkForVersion(version);
        if (c == null) {
            return false;
        }
        MVMap<String, String> oldLayoutMap = this.getLayoutMap(version);
        try {
            String chunkKey;
            Iterator<String> it = oldLayoutMap.keyIterator("chunk.");
            while (it.hasNext() && (chunkKey = it.next()).startsWith("chunk.")) {
                if (this.layout.containsKey(chunkKey)) continue;
                String s = oldLayoutMap.get(chunkKey);
                Chunk c2 = Chunk.fromString(s);
                Chunk test = this.readChunkHeaderAndFooter(c2.block, c2.id);
                if (test != null) continue;
                return false;
            }
        }
        catch (MVStoreException e) {
            return false;
        }
        return true;
    }

    public void registerUnsavedMemory(int memory) {
        this.unsavedMemory += memory;
        int newValue = this.unsavedMemory;
        if (newValue > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> map) {
        if (this.saveNeeded && this.fileStore != null && this.isOpenOrStopping() && (this.storeLock.isHeldByCurrentThread() || !map.getRoot().isLockedByCurrentThread()) && map != this.layout) {
            this.saveNeeded = false;
            if (this.autoCommitMemory > 0 && this.needStore()) {
                if (this.requireStore() && !map.isSingleWriter()) {
                    this.commit(MVStore::requireStore);
                } else {
                    this.tryCommit(MVStore::needStore);
                }
            }
        }
    }

    private boolean requireStore() {
        return 3 * this.unsavedMemory > 4 * this.autoCommitMemory;
    }

    private boolean needStore() {
        return this.unsavedMemory > this.autoCommitMemory;
    }

    public int getStoreVersion() {
        this.checkOpen();
        String x = this.meta.get("setting.storeVersion");
        return x == null ? 0 : DataUtils.parseHexInt(x);
    }

    public void setStoreVersion(int version) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(version));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long version) {
        this.storeLock.lock();
        try {
            block23: {
                TxCounter txCounter;
                this.checkOpen();
                this.currentVersion = version;
                if (version == 0L) {
                    this.layout.setInitialRoot(this.layout.createEmptyLeaf(), -1L);
                    this.meta.setInitialRoot(this.meta.createEmptyLeaf(), -1L);
                    this.layout.put(META_ID_KEY, Integer.toHexString(this.meta.getId()));
                    this.deadChunks.clear();
                    this.removedPages.clear();
                    this.chunks.clear();
                    this.clearCaches();
                    if (this.fileStore != null) {
                        this.saveChunkLock.lock();
                        try {
                            this.fileStore.clear();
                        }
                        finally {
                            this.saveChunkLock.unlock();
                        }
                    }
                    this.lastChunk = null;
                    this.versions.clear();
                    this.setWriteVersion(version);
                    this.metaChanged = false;
                    for (MVMap<?, ?> m : this.maps.values()) {
                        m.close();
                    }
                    return;
                }
                DataUtils.checkArgument(this.isKnownVersion(version), "Unknown version {0}", version);
                while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= version) {
                    this.versions.removeLast();
                }
                this.currentTxCounter = new TxCounter(version);
                if (!this.layout.rollbackRoot(version)) {
                    MVMap<String, String> layoutMap = this.getLayoutMap(version);
                    this.layout.setInitialRoot(layoutMap.getRootPage(), version);
                }
                if (!this.meta.rollbackRoot(version)) {
                    this.meta.setRootPos(this.getRootPos(this.meta.getId()), version - 1L);
                }
                this.metaChanged = false;
                for (MVMap mVMap : new ArrayList(this.maps.values())) {
                    int id = mVMap.getId();
                    if (mVMap.getCreateVersion() >= version) {
                        mVMap.close();
                        this.maps.remove(id);
                        continue;
                    }
                    if (mVMap.rollbackRoot(version)) continue;
                    mVMap.setRootPos(this.getRootPos(id), version - 1L);
                }
                this.deadChunks.clear();
                this.removedPages.clear();
                this.clearCaches();
                this.serializationLock.lock();
                try {
                    Chunk keep = this.getChunkForVersion(version);
                    if (keep == null) break block23;
                    this.saveChunkLock.lock();
                    try {
                        this.setLastChunk(keep);
                        this.storeHeader.put(HDR_CLEAN, 1);
                        this.writeStoreHeader();
                        this.readStoreHeader();
                    }
                    finally {
                        this.saveChunkLock.unlock();
                    }
                }
                finally {
                    this.serializationLock.unlock();
                }
            }
            this.onVersionChange(this.currentVersion);
            assert (!this.hasUnsavedChanges());
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
    }

    private void clearCaches() {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.chunksToC != null) {
            this.chunksToC.clear();
        }
    }

    private long getRootPos(int mapId) {
        String root = this.layout.get(MVMap.getMapRootKey(mapId));
        return root == null ? 0L : DataUtils.parseHexLong(root);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newMVStoreException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> map, String newName) {
        this.checkOpen();
        DataUtils.checkArgument(map != this.layout && map != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int id = map.getId();
        String oldName = this.getMapName(id);
        if (oldName != null && !oldName.equals(newName)) {
            String idHexStr = Integer.toHexString(id);
            String existingIdHexStr = this.meta.putIfAbsent("name." + newName, idHexStr);
            DataUtils.checkArgument(existingIdHexStr == null || existingIdHexStr.equals(idHexStr), "A map named {0} already exists", newName);
            this.meta.put(MVMap.getMapKey(id), map.asString(newName));
            this.meta.remove("name." + oldName);
            this.markMetaChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> map) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(this.layout != this.meta && map != this.meta, "Removing the meta map is not allowed", new Object[0]);
            RootReference<?, ?> rootReference = map.clearIt();
            map.close();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int id = map.getId();
            String name = this.getMapName(id);
            if (this.meta.remove(MVMap.getMapKey(id)) != null) {
                this.markMetaChanged();
            }
            if (this.meta.remove("name." + name) != null) {
                this.markMetaChanged();
            }
            if (!this.isVersioningRequired()) {
                this.maps.remove(id);
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    void deregisterMapRoot(int mapId) {
        if (this.layout.remove(MVMap.getMapRootKey(mapId)) != null) {
            this.markMetaChanged();
        }
    }

    public void removeMap(String name) {
        int id = this.getMapId(name);
        if (id > 0) {
            MVMap map = this.getMap(id);
            if (map == null) {
                map = this.openMap(name, MVStoreTool.getGenericMapBuilder());
            }
            this.removeMap(map);
        }
    }

    public String getMapName(int id) {
        String m = this.meta.get(MVMap.getMapKey(id));
        return m == null ? null : DataUtils.getMapName(m);
    }

    private int getMapId(String name) {
        String m = this.meta.get("name." + name);
        return m == null ? -1 : DataUtils.parseHexInt(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInBackground() {
        block21: {
            try {
                if (!this.isOpenOrStopping() || this.isReadOnly()) {
                    return;
                }
                long time = this.getTimeSinceCreation();
                if (time > this.lastCommitTime + (long)this.autoCommitDelay) {
                    this.tryCommit();
                    if (this.autoCompactFillRate < 0) {
                        this.compact(-this.getTargetFillRate(), this.autoCommitMemory);
                    }
                }
                int fillRate = this.getFillRate();
                if (this.fileStore.isFragmented() && fillRate < this.autoCompactFillRate) {
                    if (this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int moveSize = this.autoCommitMemory;
                            if (this.isIdle()) {
                                moveSize *= 4;
                            }
                            this.compactMoveChunks(101, moveSize);
                        }
                        finally {
                            this.unlockAndCheckPanicCondition();
                        }
                    }
                } else if (fillRate >= this.autoCompactFillRate && this.lastChunk != null) {
                    int chunksFillRate = this.getRewritableChunksFillRate();
                    int n = chunksFillRate = this.isIdle() ? 100 - (100 - chunksFillRate) / 2 : chunksFillRate;
                    if (chunksFillRate < this.getTargetFillRate() && this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int writeLimit = this.autoCommitMemory * fillRate / Math.max(chunksFillRate, 1);
                            if (!this.isIdle()) {
                                writeLimit /= 4;
                            }
                            if (this.rewriteChunks(writeLimit, chunksFillRate)) {
                                this.dropUnusedChunks();
                            }
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                }
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
            catch (InterruptedException time) {
            }
            catch (Throwable e) {
                this.handleException(e);
                if (this.backgroundExceptionHandler != null) break block21;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaintenance(int targetFillRate) {
        if (this.autoCompactFillRate > 0 && this.lastChunk != null && this.reuseSpace) {
            try {
                int lastProjectedFillRate = -1;
                for (int cnt = 0; cnt < 5; ++cnt) {
                    int fillRate;
                    int projectedFillRate = fillRate = this.getFillRate();
                    if (fillRate > targetFillRate && ((projectedFillRate = this.getProjectedFillRate(100)) > targetFillRate || projectedFillRate <= lastProjectedFillRate)) break;
                    lastProjectedFillRate = projectedFillRate;
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break;
                    try {
                        int writeLimit = this.autoCommitMemory * targetFillRate / Math.max(projectedFillRate, 1);
                        if ((projectedFillRate >= fillRate || this.rewriteChunks(writeLimit, targetFillRate) && this.dropUnusedChunks() != 0 || cnt <= 0) && this.compactMoveChunks(101, writeLimit)) continue;
                        break;
                    }
                    finally {
                        this.unlockAndCheckPanicCondition();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int getTargetFillRate() {
        int targetRate = this.autoCompactFillRate;
        if (!this.isIdle()) {
            targetRate /= 2;
        }
        return targetRate;
    }

    private boolean isIdle() {
        return this.autoCompactLastFileOpCount == this.fileStore.getWriteCount() + this.fileStore.getReadCount();
    }

    private void handleException(Throwable ex) {
        block3: {
            if (this.backgroundExceptionHandler != null) {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), ex);
                }
                catch (Throwable e) {
                    if (ex == e) break block3;
                    ex.addSuppressed(e);
                }
            }
        }
    }

    public void setCacheSize(int mb) {
        long bytes = (long)mb * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(bytes);
            this.cache.clear();
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            boolean bl = this.state == 3;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean waitForIt) {
        BackgroundWriterThread t;
        while ((t = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(t, null)) continue;
            if (t != Thread.currentThread()) {
                Object object = t.sync;
                synchronized (object) {
                    t.sync.notifyAll();
                }
                if (waitForIt) {
                    try {
                        t.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Utils.shutdownExecutor(this.serializationExecutor);
            this.serializationExecutor = null;
            Utils.shutdownExecutor(this.bufferSaveExecutor);
            this.bufferSaveExecutor = null;
            break;
        }
    }

    public void setAutoCommitDelay(int millis) {
        int sleep;
        BackgroundWriterThread t;
        if (this.autoCommitDelay == millis) {
            return;
        }
        this.autoCommitDelay = millis;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread(true);
        if (millis > 0 && this.isOpen() && this.backgroundWriterThread.compareAndSet(null, t = new BackgroundWriterThread(this, sleep = Math.max(1, millis / 10), this.fileStore.toString()))) {
            t.start();
            this.serializationExecutor = Utils.createSingleThreadExecutor("H2-serialization");
            this.bufferSaveExecutor = Utils.createSingleThreadExecutor("H2-save");
        }
    }

    public boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page<?, ?> page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public CacheLongKeyLIRS<Page<?, ?>> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public int getCacheHitRatio() {
        return MVStore.getCacheHitRatio(this.cache);
    }

    public int getTocCacheHitRatio() {
        return MVStore.getCacheHitRatio(this.chunksToC);
    }

    private static int getCacheHitRatio(CacheLongKeyLIRS<?> cache) {
        if (cache == null) {
            return 0;
        }
        long hits = cache.getHits();
        return (int)(100L * hits / (hits + cache.getMisses() + 1L));
    }

    public int getLeafRatio() {
        return (int)(this.leafCount * 100L / Math.max(1L, this.leafCount + this.nonLeafCount));
    }

    public double getUpdateFailureRatio() {
        long updateCounter = this.updateCounter;
        long updateAttemptCounter = this.updateAttemptCounter;
        RootReference<String, String> rootReference = this.layout.getRoot();
        updateCounter += rootReference.updateCounter;
        updateAttemptCounter += rootReference.updateAttemptCounter;
        rootReference = this.meta.getRoot();
        updateCounter += rootReference.updateCounter;
        updateAttemptCounter += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> map : this.maps.values()) {
            RootReference<?, ?> root = map.getRoot();
            updateCounter += root.updateCounter;
            updateAttemptCounter += root.updateAttemptCounter;
        }
        return updateAttemptCounter == 0L ? 0.0 : 1.0 - (double)updateCounter / (double)updateAttemptCounter;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while ((txCounter = this.currentTxCounter).incrementAndGet() <= 0) {
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (this.decrementVersionUsageCounter(txCounter)) {
            if (this.storeLock.isHeldByCurrentThread()) {
                this.dropUnusedVersions();
            } else if (this.storeLock.tryLock()) {
                try {
                    this.dropUnusedVersions();
                }
                finally {
                    this.storeLock.unlock();
                }
            }
        }
    }

    public boolean decrementVersionUsageCounter(TxCounter txCounter) {
        return txCounter != null && txCounter.decrementAndGet() <= 0;
    }

    private void onVersionChange(long version) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(version);
        txCounter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        while ((txCounter = this.versions.peek()) != null && txCounter.get() < 0) {
            this.versions.poll();
        }
        long oldestVersionToKeep = (txCounter != null ? txCounter : this.currentTxCounter).version;
        this.setOldestVersionToKeep(oldestVersionToKeep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dropUnusedChunks() {
        assert (this.storeLock.isHeldByCurrentThread());
        int count = 0;
        if (!this.deadChunks.isEmpty()) {
            long oldestVersionToKeep = this.getOldestVersionToKeep();
            long time = this.getTimeSinceCreation();
            this.saveChunkLock.lock();
            try {
                Chunk chunk;
                while ((chunk = this.deadChunks.poll()) != null && (this.isSeasonedChunk(chunk, time) && MVStore.canOverwriteChunk(chunk, oldestVersionToKeep) || !this.deadChunks.offerFirst(chunk))) {
                    if (this.chunks.remove(chunk.id) == null) continue;
                    long[] toc = this.chunksToC.remove(chunk.id);
                    if (toc != null && this.cache != null) {
                        for (long tocElement : toc) {
                            long pagePos = DataUtils.getPagePos(chunk.id, tocElement);
                            this.cache.remove(pagePos);
                        }
                    }
                    if (this.layout.remove(Chunk.getMetaKey(chunk.id)) != null) {
                        this.markMetaChanged();
                    }
                    if (chunk.isSaved()) {
                        this.freeChunkSpace(chunk);
                    }
                    ++count;
                }
            }
            finally {
                this.saveChunkLock.unlock();
            }
        }
        return count;
    }

    private void freeChunkSpace(Chunk chunk) {
        long start = chunk.block * 4096L;
        int length = chunk.len * 4096;
        this.freeFileSpace(start, length);
    }

    private void freeFileSpace(long start, int length) {
        this.fileStore.free(start, length);
        assert (this.validateFileLength(start + ":" + length));
    }

    private boolean validateFileLength(String msg) {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + msg;
        return true;
    }

    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> config) {
            this.config = config;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int kb) {
            return this.set("autoCommitBufferSize", kb);
        }

        public Builder autoCompactFillRate(int percent) {
            return this.set("autoCompactFillRate", percent);
        }

        public Builder fileName(String fileName) {
            return this.set("fileName", fileName);
        }

        public Builder encryptionKey(char[] password) {
            return this.set("encryptionKey", password);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder keysPerPage(int keyCount) {
            return this.set("keysPerPage", keyCount);
        }

        public Builder recoveryMode() {
            return this.set("recoveryMode", 1);
        }

        public Builder cacheSize(int mb) {
            return this.set("cacheSize", mb);
        }

        public Builder cacheConcurrency(int concurrency) {
            return this.set("cacheConcurrency", concurrency);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int pageSplitSize) {
            return this.set("pageSplitSize", pageSplitSize);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            return this.set("backgroundExceptionHandler", exceptionHandler);
        }

        public Builder fileStore(FileStore store) {
            return this.set("fileStore", store);
        }

        public Builder adoptFileStore(FileStore store) {
            this.set("fileStoreIsAdopted", true);
            return this.set("fileStore", store);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String s) {
            return new Builder(DataUtils.parseMap(s));
        }
    }

    private static class RemovedPageInfo
    implements Comparable<RemovedPageInfo> {
        final long version;
        final long removedPageInfo;

        RemovedPageInfo(long pagePos, boolean pinned, long version, int pageNo) {
            this.removedPageInfo = RemovedPageInfo.createRemovedPageInfo(pagePos, pinned, pageNo);
            this.version = version;
        }

        @Override
        public int compareTo(RemovedPageInfo other) {
            return Long.compare(this.version, other.version);
        }

        int getPageChunkId() {
            return DataUtils.getPageChunkId(this.removedPageInfo);
        }

        int getPageNo() {
            return DataUtils.getPageOffset(this.removedPageInfo);
        }

        int getPageLength() {
            return DataUtils.getPageMaxLength(this.removedPageInfo);
        }

        boolean isPinned() {
            return (this.removedPageInfo & 1L) == 1L;
        }

        private static long createRemovedPageInfo(long pagePos, boolean isPinned, int pageNo) {
            long result = pagePos & 0xFFFFFFC00000003EL | (long)pageNo << 6 & 0xFFFFFFFFL;
            if (isPinned) {
                result |= 1L;
            }
            return result;
        }

        public String toString() {
            return "RemovedPageInfo{version=" + this.version + ", chunk=" + this.getPageChunkId() + ", pageNo=" + this.getPageNo() + ", len=" + this.getPageLength() + (this.isPinned() ? ", pinned" : "") + '}';
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore store, int sleep, String fileStoreName) {
            super("MVStore background writer " + fileStoreName);
            this.store = store;
            this.sleep = sleep;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    public static final class TxCounter {
        public final long version;
        private volatile int counter;
        private static final AtomicIntegerFieldUpdater<TxCounter> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(TxCounter.class, "counter");

        TxCounter(long version) {
            this.version = version;
        }

        int get() {
            return this.counter;
        }

        int incrementAndGet() {
            return counterUpdater.incrementAndGet(this);
        }

        int decrementAndGet() {
            return counterUpdater.decrementAndGet(this);
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }
}

