/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.NullValueDataType;
import org.h2.mvstore.db.RowDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.type.DataType;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.VersionedValue;

public final class MVSecondaryIndex
extends MVIndex<SearchRow, Value> {
    private final MVTable mvTable;
    private final TransactionMap<SearchRow, Value> dataMap;

    public MVSecondaryIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, int uniqueColumnCount, IndexType indexType) {
        super(table, id, indexName, columns, uniqueColumnCount, indexType);
        this.mvTable = table;
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(columns);
        }
        String mapName = "index." + this.getId();
        RowDataType keyType = this.getRowFactory().getRowDataType();
        Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMap(mapName, keyType, NullValueDataType.INSTANCE);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        if (!db.isStarting()) {
            this.dataMap.clear();
        }
        t.commit();
        if (!keyType.equals(this.dataMap.getKeyType())) {
            throw DbException.getInternalError("Incompatible key type, expected " + keyType + " but got " + this.dataMap.getKeyType() + " for index " + indexName);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        MVMap<SearchRow, Value> map = this.openMap(bufferName);
        for (Row row : rows) {
            SearchRow r = this.getRowFactory().createRow();
            r.copyFrom(row);
            map.append(r, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> bufferNames) {
        int buffersCount = bufferNames.size();
        PriorityQueue<Source> queue = new PriorityQueue<Source>(buffersCount, new Source.Comparator(this.getRowFactory().getRowDataType()));
        for (String bufferName : bufferNames) {
            Iterator<Object> iter = this.openMap(bufferName).keyIterator(null);
            if (!iter.hasNext()) continue;
            queue.offer(new Source(iter));
        }
        try {
            while (!queue.isEmpty()) {
                Source s = (Source)queue.poll();
                SearchRow row = s.next();
                if (this.uniqueColumnColumn > 0 && !this.mayHaveNullDuplicates(row)) {
                    this.checkUnique(false, this.dataMap, row, Long.MIN_VALUE);
                }
                this.dataMap.putCommitted(row, ValueNull.INSTANCE);
                if (!s.hasNext()) continue;
                queue.offer(s);
            }
        }
        finally {
            MVStore mvStore = this.database.getStore().getMvStore();
            for (String tempMapName : bufferNames) {
                mvStore.removeMap(tempMapName);
            }
        }
    }

    private MVMap<SearchRow, Value> openMap(String mapName) {
        RowDataType keyType = this.getRowFactory().getRowDataType();
        MVMap.BasicBuilder builder = ((MVMap.Builder)new MVMap.Builder().singleWriter().keyType((DataType)keyType)).valueType((DataType)NullValueDataType.INSTANCE);
        Object map = this.database.getStore().getMvStore().openMap(mapName, builder);
        if (!keyType.equals(((MVMap)map).getKeyType())) {
            throw DbException.getInternalError("Incompatible key type, expected " + keyType + " but got " + ((MVMap)map).getKeyType() + " for map " + mapName);
        }
        return map;
    }

    @Override
    public void close(SessionLocal session) {
    }

    @Override
    public void add(SessionLocal session, Row row) {
        boolean checkRequired;
        TransactionMap<SearchRow, Value> map = this.getMap(session);
        SearchRow key = this.convertToKey(row, null);
        boolean bl = checkRequired = this.uniqueColumnColumn > 0 && !this.mayHaveNullDuplicates(row);
        if (checkRequired) {
            boolean repeatableRead = !session.getTransaction().allowNonRepeatableRead();
            this.checkUnique(repeatableRead, map, row, Long.MIN_VALUE);
        }
        try {
            map.put(key, ValueNull.INSTANCE);
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
        if (checkRequired) {
            this.checkUnique(false, map, row, row.getKey());
        }
    }

    private void checkUnique(boolean repeatableRead, TransactionMap<SearchRow, Value> map, SearchRow row, long newKey) {
        SearchRow k;
        TransactionMap.TMIterator<SearchRow, Value, SearchRow> it;
        RowFactory uniqueRowFactory = this.getUniqueRowFactory();
        SearchRow from = uniqueRowFactory.createRow();
        from.copyFrom(row);
        from.setKey(Long.MIN_VALUE);
        SearchRow to = uniqueRowFactory.createRow();
        to.copyFrom(row);
        to.setKey(Long.MAX_VALUE);
        if (repeatableRead) {
            it = map.keyIterator(from, to);
            while ((k = it.fetchNext()) != null) {
                if (newKey == k.getKey() || map.isDeletedByCurrentTransaction(k)) continue;
                throw this.getDuplicateKeyException(k.toString());
            }
        }
        it = map.keyIteratorUncommitted(from, to);
        while ((k = it.fetchNext()) != null) {
            if (newKey == k.getKey()) continue;
            if (map.getImmediate(k) != null) {
                throw this.getDuplicateKeyException(k.toString());
            }
            throw DbException.get(90131, this.table.getName());
        }
    }

    @Override
    public void remove(SessionLocal session, Row row) {
        SearchRow searchRow = this.convertToKey(row, null);
        TransactionMap<SearchRow, Value> map = this.getMap(session);
        try {
            if (map.remove(searchRow) == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public void update(SessionLocal session, Row oldRow, Row newRow) {
        SearchRow searchRowNew;
        SearchRow searchRowOld = this.convertToKey(oldRow, null);
        if (!this.rowsAreEqual(searchRowOld, searchRowNew = this.convertToKey(newRow, null))) {
            super.update(session, oldRow, newRow);
        }
    }

    private boolean rowsAreEqual(SearchRow rowOne, SearchRow rowTwo) {
        if (rowOne == rowTwo) {
            return true;
        }
        for (int index : this.columnIds) {
            Value v2;
            Value v1 = rowOne.getValue(index);
            if (Objects.equals(v1, v2 = rowTwo.getValue(index))) continue;
            return false;
        }
        return rowOne.getKey() == rowTwo.getKey();
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last) {
        return this.find(session, first, false, last);
    }

    private Cursor find(SessionLocal session, SearchRow first, boolean bigger, SearchRow last) {
        SearchRow min = this.convertToKey(first, bigger);
        SearchRow max = this.convertToKey(last, Boolean.TRUE);
        return new MVStoreCursor(session, this.getMap(session).keyIterator(min, max), this.mvTable);
    }

    private SearchRow convertToKey(SearchRow r, Boolean minMax) {
        if (r == null) {
            return null;
        }
        SearchRow row = this.getRowFactory().createRow();
        row.copyFrom(r);
        if (minMax != null) {
            row.setKey(minMax != false ? Long.MAX_VALUE : Long.MIN_VALUE);
        }
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, false, allColumnsSet);
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public void remove(SessionLocal session) {
        TransactionMap<SearchRow, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(SessionLocal session) {
        TransactionMap<SearchRow, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(SessionLocal session, boolean first) {
        SearchRow key;
        TransactionMap.TMIterator<SearchRow, Value, SearchRow> iter = this.getMap(session).keyIterator(null, (SearchRow)(!first ? 1 : 0));
        while ((key = iter.fetchNext()) != null) {
            if (key.getValue(this.columnIds[0]) == ValueNull.INSTANCE) continue;
            return new SingleRowCursor(this.mvTable.getRow(session, key.getKey()));
        }
        return new SingleRowCursor(null);
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(SessionLocal session) {
        TransactionMap<SearchRow, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(SessionLocal session, SearchRow higherThan, SearchRow last) {
        return this.find(session, higherThan, true, last);
    }

    private TransactionMap<SearchRow, Value> getMap(SessionLocal session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t);
    }

    @Override
    public MVMap<SearchRow, VersionedValue<Value>> getMVMap() {
        return this.dataMap.map;
    }

    static final class MVStoreCursor
    implements Cursor {
        private final SessionLocal session;
        private final TransactionMap.TMIterator<SearchRow, Value, SearchRow> it;
        private final MVTable mvTable;
        private SearchRow current;
        private Row row;

        MVStoreCursor(SessionLocal session, TransactionMap.TMIterator<SearchRow, Value, SearchRow> it, MVTable mvTable) {
            this.session = session;
            this.it = it;
            this.mvTable = mvTable;
        }

        @Override
        public Row get() {
            SearchRow r;
            if (this.row == null && (r = this.getSearchRow()) != null) {
                this.row = this.mvTable.getRow(this.session, r.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.current;
        }

        @Override
        public boolean next() {
            this.current = this.it.fetchNext();
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }

    private static final class Source {
        private final Iterator<SearchRow> iterator;
        SearchRow currentRowData;

        public Source(Iterator<SearchRow> iterator) {
            assert (iterator.hasNext());
            this.iterator = iterator;
            this.currentRowData = iterator.next();
        }

        public boolean hasNext() {
            boolean result = this.iterator.hasNext();
            if (result) {
                this.currentRowData = this.iterator.next();
            }
            return result;
        }

        public SearchRow next() {
            return this.currentRowData;
        }

        static final class Comparator
        implements java.util.Comparator<Source> {
            private final DataType<SearchRow> type;

            public Comparator(DataType<SearchRow> type) {
                this.type = type;
            }

            @Override
            public int compare(Source one, Source two) {
                return this.type.compare(one.currentRowData, two.currentRowData);
            }
        }
    }
}

