/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Iterator;
import java.util.List;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.Page;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.NullValueDataType;
import org.h2.mvstore.db.SpatialKey;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.Spatial;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.tx.VersionedValueType;
import org.h2.mvstore.type.DataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;
import org.h2.value.VersionedValue;

public class MVSpatialIndex
extends MVIndex<Spatial, Value>
implements SpatialIndex {
    final MVTable mvTable;
    private final TransactionMap<Spatial, Value> dataMap;
    private final MVRTreeMap<VersionedValue<Value>> spatialMap;

    public MVSpatialIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, int uniqueColumnCount, IndexType indexType) {
        super(table, id, indexName, columns, uniqueColumnCount, indexType);
        if (columns.length != 1) {
            throw DbException.getUnsupportedException("Can only index one column");
        }
        IndexColumn col = columns[0];
        if ((col.sortType & 1) != 0) {
            throw DbException.getUnsupportedException("Cannot index in descending order");
        }
        if ((col.sortType & 2) != 0) {
            throw DbException.getUnsupportedException("Nulls first is not supported");
        }
        if ((col.sortType & 4) != 0) {
            throw DbException.getUnsupportedException("Nulls last is not supported");
        }
        if (col.column.getType().getValueType() != 37) {
            throw DbException.getUnsupportedException("Spatial index on non-geometry column, " + col.column.getCreateSQL());
        }
        this.mvTable = table;
        if (!this.database.isStarting()) {
            MVSpatialIndex.checkIndexColumnTypes(columns);
        }
        String mapName = "index." + this.getId();
        VersionedValueType valueType = new VersionedValueType(NullValueDataType.INSTANCE);
        MVMap.BasicBuilder mapBuilder = new MVRTreeMap.Builder().valueType((DataType)valueType);
        this.spatialMap = (MVRTreeMap)db.getStore().getMvStore().openMap(mapName, mapBuilder);
        Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMapX(this.spatialMap);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        t.commit();
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw DbException.getInternalError();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw DbException.getInternalError();
    }

    @Override
    public void close(SessionLocal session) {
    }

    @Override
    public void add(SessionLocal session, Row row) {
        Spatial k;
        SpatialKeyIterator it;
        MVRTreeMap.RTreeCursor<VersionedValue<Value>> cursor;
        TransactionMap<Spatial, Value> map = this.getMap(session);
        SpatialKey key = this.getKey(row);
        if (key.isNull()) {
            return;
        }
        if (this.uniqueColumnColumn > 0) {
            cursor = this.spatialMap.findContainedKeys(key);
            it = new SpatialKeyIterator(map, cursor, false);
            while (it.hasNext()) {
                k = (Spatial)it.next();
                if (!k.equalsIgnoringId(key)) continue;
                throw this.getDuplicateKeyException(key.toString());
            }
        }
        try {
            map.put(key, ValueNull.INSTANCE);
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
        if (this.uniqueColumnColumn > 0) {
            cursor = this.spatialMap.findContainedKeys(key);
            it = new SpatialKeyIterator(map, cursor, true);
            while (it.hasNext()) {
                k = (Spatial)it.next();
                if (!k.equalsIgnoringId(key) || map.isSameTransaction(k)) continue;
                map.remove(key);
                if (map.getImmediate(k) != null) {
                    throw this.getDuplicateKeyException(k.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    @Override
    public void remove(SessionLocal session, Row row) {
        SpatialKey key = this.getKey(row);
        if (key.isNull()) {
            return;
        }
        TransactionMap<Spatial, Value> map = this.getMap(session);
        try {
            Value old = map.remove(key);
            if (old == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last) {
        Iterator<Object> cursor = this.spatialMap.keyIterator(null);
        TransactionMap<Spatial, Value> map = this.getMap(session);
        SpatialKeyIterator it = new SpatialKeyIterator(map, cursor, false);
        return new MVStoreCursor(session, it, this.mvTable);
    }

    @Override
    public Cursor findByGeometry(SessionLocal session, SearchRow first, SearchRow last, SearchRow intersection) {
        if (intersection == null) {
            return this.find(session, first, last);
        }
        MVRTreeMap.RTreeCursor<VersionedValue<Value>> cursor = this.spatialMap.findIntersectingKeys(this.getKey(intersection));
        TransactionMap<Spatial, Value> map = this.getMap(session);
        SpatialKeyIterator it = new SpatialKeyIterator(map, cursor, false);
        return new MVStoreCursor(session, it, this.mvTable);
    }

    public Value getBounds(SessionLocal session) {
        FindBoundsCursor cursor = new FindBoundsCursor(this.spatialMap.getRootPage(), new SpatialKey(0L, new float[0]), session, this.getMap(session), this.columnIds[0]);
        while (cursor.hasNext()) {
            cursor.next();
        }
        return cursor.getBounds();
    }

    public Value getEstimatedBounds(SessionLocal session) {
        Page p = this.spatialMap.getRootPage();
        int count = p.getKeyCount();
        if (count > 0) {
            Spatial key = (Spatial)p.getKey(0);
            float bminxf = key.min(0);
            float bmaxxf = key.max(0);
            float bminyf = key.min(1);
            float bmaxyf = key.max(1);
            for (int i = 1; i < count; ++i) {
                key = (Spatial)p.getKey(i);
                float minxf = key.min(0);
                float maxxf = key.max(0);
                float minyf = key.min(1);
                float maxyf = key.max(1);
                if (minxf < bminxf) {
                    bminxf = minxf;
                }
                if (maxxf > bmaxxf) {
                    bmaxxf = maxxf;
                }
                if (minyf < bminyf) {
                    bminyf = minyf;
                }
                if (!(maxyf > bmaxyf)) continue;
                bmaxyf = maxyf;
            }
            return ValueGeometry.fromEnvelope(new double[]{bminxf, bmaxxf, bminyf, bmaxyf});
        }
        return ValueNull.INSTANCE;
    }

    private SpatialKey getKey(SearchRow row) {
        double[] env;
        Value v = row.getValue(this.columnIds[0]);
        if (v == ValueNull.INSTANCE || (env = v.convertToGeometry(null).getEnvelopeNoCopy()) == null) {
            return new SpatialKey(row.getKey(), new float[0]);
        }
        return new SpatialKey(row.getKey(), (float)env[0], (float)env[1], (float)env[2], (float)env[3]);
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return MVSpatialIndex.getCostRangeIndex(masks, this.columns);
    }

    public static long getCostRangeIndex(int[] masks, Column[] columns) {
        if (columns.length == 0) {
            return Long.MAX_VALUE;
        }
        for (Column column : columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 0x10) == 16) continue;
            return Long.MAX_VALUE;
        }
        return 2L;
    }

    @Override
    public void remove(SessionLocal session) {
        TransactionMap<Spatial, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(SessionLocal session) {
        TransactionMap<Spatial, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(SessionLocal session) {
        TransactionMap<Spatial, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    private TransactionMap<Spatial, Value> getMap(SessionLocal session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t);
    }

    @Override
    public MVMap<Spatial, VersionedValue<Value>> getMVMap() {
        return this.dataMap.map;
    }

    private final class FindBoundsCursor
    extends MVRTreeMap.RTreeCursor<VersionedValue<Value>> {
        private final SessionLocal session;
        private final TransactionMap<Spatial, Value> map;
        private final int columnId;
        private boolean hasBounds;
        private float bminxf;
        private float bmaxxf;
        private float bminyf;
        private float bmaxyf;
        private double bminxd;
        private double bmaxxd;
        private double bminyd;
        private double bmaxyd;

        FindBoundsCursor(Page<Spatial, VersionedValue<Value>> root, Spatial filter, SessionLocal session, TransactionMap<Spatial, Value> map, int columnId) {
            super(root, filter);
            this.session = session;
            this.map = map;
            this.columnId = columnId;
        }

        @Override
        protected boolean check(boolean leaf, Spatial key, Spatial test) {
            float minxf = key.min(0);
            float maxxf = key.max(0);
            float minyf = key.min(1);
            float maxyf = key.max(1);
            if (leaf) {
                if (this.hasBounds) {
                    if ((minxf <= this.bminxf || maxxf >= this.bmaxxf || minyf <= this.bminyf || maxyf >= this.bmaxyf) && this.map.containsKey(key)) {
                        double[] env = ((ValueGeometry)MVSpatialIndex.this.mvTable.getRow(this.session, key.getId()).getValue(this.columnId)).getEnvelopeNoCopy();
                        double minxd = env[0];
                        double maxxd = env[1];
                        double minyd = env[2];
                        double maxyd = env[3];
                        if (minxd < this.bminxd) {
                            this.bminxf = minxf;
                            this.bminxd = minxd;
                        }
                        if (maxxd > this.bmaxxd) {
                            this.bmaxxf = maxxf;
                            this.bmaxxd = maxxd;
                        }
                        if (minyd < this.bminyd) {
                            this.bminyf = minyf;
                            this.bminyd = minyd;
                        }
                        if (maxyd > this.bmaxyd) {
                            this.bmaxyf = maxyf;
                            this.bmaxyd = maxyd;
                        }
                    }
                } else if (this.map.containsKey(key)) {
                    this.hasBounds = true;
                    double[] env = ((ValueGeometry)MVSpatialIndex.this.mvTable.getRow(this.session, key.getId()).getValue(this.columnId)).getEnvelopeNoCopy();
                    this.bminxf = minxf;
                    this.bminxd = env[0];
                    this.bmaxxf = maxxf;
                    this.bmaxxd = env[1];
                    this.bminyf = minyf;
                    this.bminyd = env[2];
                    this.bmaxyf = maxyf;
                    this.bmaxyd = env[3];
                }
            } else if (this.hasBounds) {
                if (minxf <= this.bminxf || maxxf >= this.bmaxxf || minyf <= this.bminyf || maxyf >= this.bmaxyf) {
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        Value getBounds() {
            return this.hasBounds ? ValueGeometry.fromEnvelope(new double[]{this.bminxd, this.bmaxxd, this.bminyd, this.bmaxyd}) : ValueNull.INSTANCE;
        }
    }

    private static class SpatialKeyIterator
    implements Iterator<Spatial> {
        private final TransactionMap<Spatial, Value> map;
        private final Iterator<Spatial> iterator;
        private final boolean includeUncommitted;
        private Spatial current;

        SpatialKeyIterator(TransactionMap<Spatial, Value> map, Iterator<Spatial> iterator, boolean includeUncommitted) {
            this.map = map;
            this.iterator = iterator;
            this.includeUncommitted = includeUncommitted;
            this.fetchNext();
        }

        private void fetchNext() {
            while (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (!this.includeUncommitted && !this.map.containsKey(this.current)) continue;
                return;
            }
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Spatial next() {
            Spatial result = this.current;
            this.fetchNext();
            return result;
        }
    }

    private static class MVStoreCursor
    implements Cursor {
        private final SessionLocal session;
        private final Iterator<Spatial> it;
        private final MVTable mvTable;
        private Spatial current;
        private SearchRow searchRow;
        private Row row;

        MVStoreCursor(SessionLocal session, Iterator<Spatial> it, MVTable mvTable) {
            this.session = session;
            this.it = it;
            this.mvTable = mvTable;
        }

        @Override
        public Row get() {
            SearchRow r;
            if (this.row == null && (r = this.getSearchRow()) != null) {
                this.row = this.mvTable.getRow(this.session, r.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = this.mvTable.getTemplateRow();
                this.searchRow.setKey(this.current.getId());
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

