/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collection;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVPlainTempResult;
import org.h2.mvstore.db.MVSortedTempResult;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.store.fs.FileUtils;
import org.h2.util.TempFileDeleter;
import org.h2.value.Value;

public abstract class MVTempResult
implements ResultExternal {
    private final Database database;
    final MVStore store;
    final Expression[] expressions;
    final int visibleColumnCount;
    final int resultColumnCount;
    int rowCount;
    final MVTempResult parent;
    int childCount;
    boolean closed;
    private final TempFileDeleter tempFileDeleter;
    private final CloseImpl closeable;
    private final Reference<?> fileRef;

    public static ResultExternal of(Database database, Expression[] expressions, boolean distinct, int[] distinctIndexes, int visibleColumnCount, int resultColumnCount, SortOrder sort) {
        return distinct || distinctIndexes != null || sort != null ? new MVSortedTempResult(database, expressions, distinct, distinctIndexes, visibleColumnCount, resultColumnCount, sort) : new MVPlainTempResult(database, expressions, visibleColumnCount, resultColumnCount);
    }

    MVTempResult(MVTempResult parent) {
        this.parent = parent;
        this.database = parent.database;
        this.store = parent.store;
        this.expressions = parent.expressions;
        this.visibleColumnCount = parent.visibleColumnCount;
        this.resultColumnCount = parent.resultColumnCount;
        this.tempFileDeleter = null;
        this.closeable = null;
        this.fileRef = null;
    }

    MVTempResult(Database database, Expression[] expressions, int visibleColumnCount, int resultColumnCount) {
        this.database = database;
        try {
            String fileName = FileUtils.createTempFile("h2tmp", ".temp.db", true);
            FileStore fileStore = database.getStore().getMvStore().getFileStore().open(fileName, false);
            MVStore.Builder builder = new MVStore.Builder().adoptFileStore(fileStore).cacheSize(0).autoCommitDisabled();
            this.store = builder.open();
            this.expressions = expressions;
            this.visibleColumnCount = visibleColumnCount;
            this.resultColumnCount = resultColumnCount;
            this.tempFileDeleter = database.getTempFileDeleter();
            this.closeable = new CloseImpl(this.store, fileName);
            this.fileRef = this.tempFileDeleter.addFile(this.closeable, this);
        }
        catch (IOException e) {
            throw DbException.convert(e);
        }
        this.parent = null;
    }

    @Override
    public int addRows(Collection<Value[]> rows) {
        for (Value[] row : rows) {
            this.addRow(row);
        }
        return this.rowCount;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent != null) {
            this.parent.closeChild();
        } else if (this.childCount == 0) {
            this.delete();
        }
    }

    private synchronized void closeChild() {
        if (--this.childCount == 0 && this.closed) {
            this.delete();
        }
    }

    private void delete() {
        this.tempFileDeleter.deleteFile(this.fileRef, this.closeable);
    }

    private static final class CloseImpl
    implements AutoCloseable {
        private final MVStore store;
        private final String fileName;

        CloseImpl(MVStore store, String fileName) {
            this.store = store;
            this.fileName = fileName;
        }

        @Override
        public void close() throws Exception {
            this.store.closeImmediately();
            FileUtils.tryDelete(this.fileName);
        }
    }
}

