/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class NullValueDataType
implements DataType<Value> {
    public static final NullValueDataType INSTANCE = new NullValueDataType();

    private NullValueDataType() {
    }

    @Override
    public int compare(Value a, Value b) {
        return 0;
    }

    @Override
    public int binarySearch(Value key, Object storage, int size, int initialGuess) {
        return 0;
    }

    @Override
    public int getMemory(Value obj) {
        return 0;
    }

    @Override
    public boolean isMemoryEstimationAllowed() {
        return true;
    }

    @Override
    public void write(WriteBuffer buff, Value obj) {
    }

    @Override
    public void write(WriteBuffer buff, Object storage, int len) {
    }

    @Override
    public Value read(ByteBuffer buff) {
        return ValueNull.INSTANCE;
    }

    @Override
    public void read(ByteBuffer buff, Object storage, int len) {
        Arrays.fill((Value[])storage, 0, len, ValueNull.INSTANCE);
    }

    public Value[] createStorage(int size) {
        return new Value[size];
    }
}

