/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.db.MVInDoubtTransaction;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.MetaType;
import org.h2.store.InDoubtTransaction;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileUtils;
import org.h2.util.HasSQL;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;

public final class Store {
    private final ConcurrentHashMap<String, MVTable> tableMap = new ConcurrentHashMap();
    private final MVStore mvStore;
    private final TransactionStore transactionStore;
    private long statisticsStart;
    private int temporaryMapId;
    private final boolean encrypted;
    private final String fileName;

    static char[] decodePassword(byte[] key) {
        char[] password = new char[key.length / 2];
        for (int i = 0; i < password.length; ++i) {
            password[i] = (char)((key[i + i] & 0xFF) << 16 | key[i + i + 1] & 0xFF);
        }
        return password;
    }

    public Store(Database db, byte[] key) {
        String dbPath = db.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        boolean encrypted = false;
        if (dbPath != null) {
            String fileName;
            this.fileName = fileName = dbPath + ".mv.db";
            MVStoreTool.compactCleanUp(fileName);
            builder.fileName(fileName);
            builder.pageSplitSize(db.getPageSize());
            if (db.isReadOnly()) {
                builder.readOnly();
            } else {
                boolean exists = FileUtils.exists(fileName);
                if (!exists || FileUtils.canWrite(fileName)) {
                    String dir = FileUtils.getParent(fileName);
                    FileUtils.createDirectories(dir);
                }
                int autoCompactFillRate = db.getSettings().autoCompactFillRate;
                if (autoCompactFillRate <= 100) {
                    builder.autoCompactFillRate(autoCompactFillRate);
                }
            }
            if (key != null) {
                encrypted = true;
                builder.encryptionKey(Store.decodePassword(key));
            }
            if (db.getSettings().compressData) {
                builder.compress();
                builder.pageSplitSize(65536);
            }
            builder.backgroundExceptionHandler((t, e) -> db.setBackgroundException(DbException.convert(e)));
            builder.autoCommitDisabled();
        } else {
            this.fileName = null;
        }
        this.encrypted = encrypted;
        try {
            this.mvStore = builder.open();
            if (!db.getSettings().reuseSpace) {
                this.mvStore.setReuseSpace(false);
            }
            this.mvStore.setVersionsToKeep(0);
            this.transactionStore = new TransactionStore(this.mvStore, new MetaType<Database>(db, this.mvStore.backgroundExceptionHandler), new ValueDataType(db, null), db.getLockTimeout());
        }
        catch (MVStoreException e2) {
            throw this.convertMVStoreException(e2);
        }
    }

    DbException convertMVStoreException(MVStoreException e) {
        switch (e.getErrorCode()) {
            case 4: {
                throw DbException.get(90098, e, this.fileName);
            }
            case 5: {
                throw DbException.get(90048, e, this.fileName);
            }
            case 6: {
                if (this.encrypted) {
                    throw DbException.get(90049, e, this.fileName);
                }
                throw DbException.get(90030, e, this.fileName);
            }
            case 7: {
                throw DbException.get(90020, e, this.fileName);
            }
            case 1: 
            case 2: {
                throw DbException.get(90028, e, this.fileName);
            }
        }
        throw DbException.get(50000, e, e.getMessage());
    }

    public static DbException getInvalidExpressionTypeException(String param, Typed e) {
        TypeInfo type = e.getType();
        if (type.getValueType() == -1) {
            return DbException.get(50004, (e instanceof HasSQL ? (HasSQL)((Object)e) : type).getTraceSQL());
        }
        return DbException.get(90008, type.getTraceSQL(), param);
    }

    public MVStore getMvStore() {
        return this.mvStore;
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public MVTable getTable(String tableName) {
        return this.tableMap.get(tableName);
    }

    public MVTable createTable(CreateTableData data) {
        try {
            MVTable table = new MVTable(data, this);
            this.tableMap.put(table.getMapName(), table);
            return table;
        }
        catch (MVStoreException e) {
            throw this.convertMVStoreException(e);
        }
    }

    public void removeTable(MVTable table) {
        try {
            this.tableMap.remove(table.getMapName());
        }
        catch (MVStoreException e) {
            throw this.convertMVStoreException(e);
        }
    }

    public void flush() {
        FileStore s = this.mvStore.getFileStore();
        if (s == null || s.isReadOnly()) {
            return;
        }
        if (!this.mvStore.compact(50, 0x400000)) {
            this.mvStore.commit();
        }
    }

    public void closeImmediately() {
        if (!this.mvStore.isClosed()) {
            this.mvStore.closeImmediately();
        }
    }

    public void removeTemporaryMaps(BitSet objectIds) {
        for (String mapName : this.mvStore.getMapNames()) {
            int id;
            if (mapName.startsWith("temp.")) {
                this.mvStore.removeMap(mapName);
                continue;
            }
            if (!mapName.startsWith("table.") && !mapName.startsWith("index.") || objectIds.get(id = StringUtils.parseUInt31(mapName, mapName.indexOf(46) + 1, mapName.length()))) continue;
            this.mvStore.removeMap(mapName);
        }
    }

    public synchronized String nextTemporaryMapName() {
        return "temp." + this.temporaryMapId++;
    }

    public void prepareCommit(SessionLocal session, String transactionName) {
        Transaction t = session.getTransaction();
        t.setName(transactionName);
        t.prepare();
        this.mvStore.commit();
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        List<Transaction> list = this.transactionStore.getOpenTransactions();
        ArrayList<InDoubtTransaction> result = Utils.newSmallArrayList();
        for (Transaction t : list) {
            if (t.getStatus() != 2) continue;
            result.add(new MVInDoubtTransaction(this.mvStore, t));
        }
        return result;
    }

    public void setCacheSize(int kb) {
        this.mvStore.setCacheSize(Math.max(1, kb / 1024));
    }

    public InputStream getInputStream() {
        FileChannel fc = this.mvStore.getFileStore().getEncryptedFile();
        if (fc == null) {
            fc = this.mvStore.getFileStore().getFile();
        }
        return new FileChannelInputStream(fc, false);
    }

    public void sync() {
        this.flush();
        this.mvStore.sync();
    }

    public void compactFile(int maxCompactTime) {
        this.mvStore.compactFile(maxCompactTime);
    }

    public void close(int allowedCompactionTime) {
        try {
            FileStore fileStore = this.mvStore.getFileStore();
            if (!this.mvStore.isClosed() && fileStore != null) {
                boolean compactFully;
                boolean bl = compactFully = allowedCompactionTime == -1;
                if (fileStore.isReadOnly()) {
                    compactFully = false;
                } else {
                    this.transactionStore.close();
                }
                if (compactFully) {
                    allowedCompactionTime = 0;
                }
                String fileName = null;
                FileStore targetFileStore = null;
                if (compactFully) {
                    fileName = fileStore.getFileName();
                    String tempName = fileName + ".tempFile";
                    FileUtils.delete(tempName);
                    targetFileStore = fileStore.open(tempName, false);
                }
                this.mvStore.close(allowedCompactionTime);
                if (compactFully && FileUtils.exists(fileName)) {
                    Store.compact(fileName, targetFileStore);
                }
            }
        }
        catch (MVStoreException e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 2 || errorCode == 6) {
                // empty if block
            }
            this.mvStore.closeImmediately();
            throw DbException.get(90028, e, "Closing");
        }
    }

    private static void compact(String sourceFilename, FileStore targetFileStore) {
        MVStore.Builder targetBuilder = new MVStore.Builder().compress().adoptFileStore(targetFileStore);
        try (MVStore targetMVStore = targetBuilder.open();){
            FileStore sourceFileStore = targetFileStore.open(sourceFilename, true);
            MVStore.Builder sourceBuilder = new MVStore.Builder();
            sourceBuilder.readOnly().adoptFileStore(sourceFileStore);
            try (MVStore sourceMVStore = sourceBuilder.open();){
                MVStoreTool.compact(sourceMVStore, targetMVStore);
            }
        }
        MVStoreTool.moveAtomicReplace(targetFileStore.getFileName(), sourceFilename);
    }

    public void statisticsStart() {
        FileStore fs = this.mvStore.getFileStore();
        this.statisticsStart = fs == null ? 0L : fs.getReadCount();
    }

    public Map<String, Integer> statisticsEnd() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        FileStore fs = this.mvStore.getFileStore();
        int reads = fs == null ? 0 : (int)(fs.getReadCount() - this.statisticsStart);
        map.put("reads", reads);
        return map;
    }
}

