/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.util.Arrays;
import org.h2.mvstore.rtree.Spatial;

final class DefaultSpatial
implements Spatial {
    private final long id;
    private final float[] minMax;

    public DefaultSpatial(long id, float ... minMax) {
        this.id = id;
        this.minMax = minMax;
    }

    private DefaultSpatial(long id, DefaultSpatial other) {
        this.id = id;
        this.minMax = (float[])other.minMax.clone();
    }

    @Override
    public float min(int dim) {
        return this.minMax[dim + dim];
    }

    @Override
    public void setMin(int dim, float x) {
        this.minMax[dim + dim] = x;
    }

    @Override
    public float max(int dim) {
        return this.minMax[dim + dim + 1];
    }

    @Override
    public void setMax(int dim, float x) {
        this.minMax[dim + dim + 1] = x;
    }

    @Override
    public Spatial clone(long id) {
        return new DefaultSpatial(id, this);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isNull() {
        return this.minMax.length == 0;
    }

    @Override
    public boolean equalsIgnoringId(Spatial o) {
        return Arrays.equals(this.minMax, ((DefaultSpatial)o).minMax);
    }
}

