/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.DefaultSpatial;
import org.h2.mvstore.rtree.Spatial;
import org.h2.mvstore.type.BasicDataType;

public class SpatialDataType
extends BasicDataType<Spatial> {
    private final int dimensions;

    public SpatialDataType(int dimensions) {
        DataUtils.checkArgument(dimensions >= 1 && dimensions < 32, "Dimensions must be between 1 and 31, is {0}", dimensions);
        this.dimensions = dimensions;
    }

    protected Spatial create(long id, float ... minMax) {
        return new DefaultSpatial(id, minMax);
    }

    public Spatial[] createStorage(int size) {
        return new Spatial[size];
    }

    @Override
    public int compare(Spatial a, Spatial b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        long la = a.getId();
        long lb = b.getId();
        return Long.compare(la, lb);
    }

    public boolean equals(Spatial a, Spatial b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getId() == b.getId();
    }

    @Override
    public int getMemory(Spatial obj) {
        return 40 + this.dimensions * 4;
    }

    @Override
    public void write(WriteBuffer buff, Spatial k) {
        int i;
        if (k.isNull()) {
            buff.putVarInt(-1);
            buff.putVarLong(k.getId());
            return;
        }
        int flags = 0;
        for (i = 0; i < this.dimensions; ++i) {
            if (k.min(i) != k.max(i)) continue;
            flags |= 1 << i;
        }
        buff.putVarInt(flags);
        for (i = 0; i < this.dimensions; ++i) {
            buff.putFloat(k.min(i));
            if ((flags & 1 << i) != 0) continue;
            buff.putFloat(k.max(i));
        }
        buff.putVarLong(k.getId());
    }

    @Override
    public Spatial read(ByteBuffer buff) {
        int flags = DataUtils.readVarInt(buff);
        if (flags == -1) {
            long id = DataUtils.readVarLong(buff);
            return this.create(id, new float[0]);
        }
        float[] minMax = new float[this.dimensions * 2];
        for (int i = 0; i < this.dimensions; ++i) {
            float min = buff.getFloat();
            float max = (flags & 1 << i) != 0 ? min : buff.getFloat();
            minMax[i + i] = min;
            minMax[i + i + 1] = max;
        }
        long id = DataUtils.readVarLong(buff);
        return this.create(id, minMax);
    }

    public boolean isOverlap(Spatial a, Spatial b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(a.max(i) < b.min(i)) && !(a.min(i) > b.max(i))) continue;
            return false;
        }
        return true;
    }

    public void increaseBounds(Spatial bounds, Spatial add) {
        if (add.isNull() || bounds.isNull()) {
            return;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            float v = add.min(i);
            if (v < bounds.min(i)) {
                bounds.setMin(i, v);
            }
            if (!((v = add.max(i)) > bounds.max(i))) continue;
            bounds.setMax(i, v);
        }
    }

    public float getAreaIncrease(Spatial bounds, Spatial add) {
        if (bounds.isNull() || add.isNull()) {
            return 0.0f;
        }
        float min = bounds.min(0);
        float max = bounds.max(0);
        float areaOld = max - min;
        min = Math.min(min, add.min(0));
        max = Math.max(max, add.max(0));
        float areaNew = max - min;
        for (int i = 1; i < this.dimensions; ++i) {
            min = bounds.min(i);
            max = bounds.max(i);
            areaOld *= max - min;
            min = Math.min(min, add.min(i));
            max = Math.max(max, add.max(i));
            areaNew *= max - min;
        }
        return areaNew - areaOld;
    }

    float getCombinedArea(Spatial a, Spatial b) {
        if (a.isNull()) {
            return this.getArea(b);
        }
        if (b.isNull()) {
            return this.getArea(a);
        }
        float area = 1.0f;
        for (int i = 0; i < this.dimensions; ++i) {
            float min = Math.min(a.min(i), b.min(i));
            float max = Math.max(a.max(i), b.max(i));
            area *= max - min;
        }
        return area;
    }

    private float getArea(Spatial a) {
        if (a.isNull()) {
            return 0.0f;
        }
        float area = 1.0f;
        for (int i = 0; i < this.dimensions; ++i) {
            area *= a.max(i) - a.min(i);
        }
        return area;
    }

    public boolean contains(Spatial bounds, Spatial object) {
        if (bounds.isNull() || object.isNull()) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(bounds.min(i) > object.min(i)) && !(bounds.max(i) < object.max(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Spatial object, Spatial bounds) {
        if (object.isNull() || bounds.isNull()) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(object.min(i) <= bounds.min(i)) && !(object.max(i) >= bounds.max(i))) continue;
            return false;
        }
        return true;
    }

    Spatial createBoundingBox(Spatial object) {
        if (object.isNull()) {
            return object;
        }
        return object.clone(0L);
    }

    public int[] getExtremes(ArrayList<Spatial> list) {
        if ((list = SpatialDataType.getNotNull(list)).isEmpty()) {
            return null;
        }
        Spatial bounds = this.createBoundingBox(list.get(0));
        Spatial boundsInner = this.createBoundingBox(bounds);
        for (int i = 0; i < this.dimensions; ++i) {
            float t = boundsInner.min(i);
            boundsInner.setMin(i, boundsInner.max(i));
            boundsInner.setMax(i, t);
        }
        for (Spatial o : list) {
            this.increaseBounds(bounds, o);
            this.increaseMaxInnerBounds(boundsInner, o);
        }
        double best = 0.0;
        int bestDim = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            float outer;
            float d;
            float inner = boundsInner.max(i) - boundsInner.min(i);
            if (inner < 0.0f || !((double)(d = inner / (outer = bounds.max(i) - bounds.min(i))) > best)) continue;
            best = d;
            bestDim = i;
        }
        if (best <= 0.0) {
            return null;
        }
        float min = boundsInner.min(bestDim);
        float max = boundsInner.max(bestDim);
        int firstIndex = -1;
        int lastIndex = -1;
        for (int i = 0; i < list.size() && (firstIndex < 0 || lastIndex < 0); ++i) {
            Spatial o = list.get(i);
            if (firstIndex < 0 && o.max(bestDim) == min) {
                firstIndex = i;
                continue;
            }
            if (lastIndex >= 0 || o.min(bestDim) != max) continue;
            lastIndex = i;
        }
        return new int[]{firstIndex, lastIndex};
    }

    private static ArrayList<Spatial> getNotNull(ArrayList<Spatial> list) {
        boolean foundNull = false;
        for (Spatial o : list) {
            if (!o.isNull()) continue;
            foundNull = true;
            break;
        }
        if (!foundNull) {
            return list;
        }
        ArrayList<Spatial> result = new ArrayList<Spatial>();
        for (Spatial o : list) {
            if (o.isNull()) continue;
            result.add(o);
        }
        return result;
    }

    private void increaseMaxInnerBounds(Spatial bounds, Spatial add) {
        for (int i = 0; i < this.dimensions; ++i) {
            bounds.setMin(i, Math.min(bounds.min(i), add.max(i)));
            bounds.setMax(i, Math.max(bounds.max(i), add.min(i)));
        }
    }
}

