/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.BasicDataType;
import org.h2.value.VersionedValue;

final class Record<K, V> {
    static final Record<?, ?> COMMIT_MARKER = new Record(-1, null, null);
    final int mapId;
    final K key;
    final VersionedValue<V> oldValue;

    Record(int mapId, K key, VersionedValue<V> oldValue) {
        this.mapId = mapId;
        this.key = key;
        this.oldValue = oldValue;
    }

    public String toString() {
        return "mapId=" + this.mapId + ", key=" + this.key + ", value=" + this.oldValue;
    }

    static final class Type<K, V>
    extends BasicDataType<Record<K, V>> {
        private final TransactionStore transactionStore;

        Type(TransactionStore transactionStore) {
            this.transactionStore = transactionStore;
        }

        @Override
        public int getMemory(Record<K, V> record) {
            int result = 52;
            if (record.mapId >= 0) {
                MVMap map = this.transactionStore.getMap(record.mapId);
                result += map.getKeyType().getMemory(record.key) + map.getValueType().getMemory(record.oldValue);
            }
            return result;
        }

        @Override
        public int compare(Record<K, V> aObj, Record<K, V> bObj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(WriteBuffer buff, Record<K, V> record) {
            buff.putVarInt(record.mapId);
            if (record.mapId >= 0) {
                MVMap map = this.transactionStore.getMap(record.mapId);
                map.getKeyType().write(buff, record.key);
                VersionedValue oldValue = record.oldValue;
                if (oldValue == null) {
                    buff.put((byte)0);
                } else {
                    buff.put((byte)1);
                    map.getValueType().write(buff, oldValue);
                }
            }
        }

        @Override
        public Record<K, V> read(ByteBuffer buff) {
            int mapId = DataUtils.readVarInt(buff);
            if (mapId < 0) {
                return COMMIT_MARKER;
            }
            MVMap map = this.transactionStore.getMap(mapId);
            Object key = map.getKeyType().read(buff);
            VersionedValue oldValue = null;
            if (buff.get() == 1) {
                oldValue = map.getValueType().read(buff);
            }
            return new Record(mapId, key, oldValue);
        }

        public Record<K, V>[] createStorage(int size) {
            return new Record[size];
        }
    }
}

