/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.engine.IsolationLevel;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.tx.Record;
import org.h2.mvstore.tx.Snapshot;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.DataType;
import org.h2.value.VersionedValue;

public final class Transaction {
    public static final int STATUS_CLOSED = 0;
    public static final int STATUS_OPEN = 1;
    public static final int STATUS_PREPARED = 2;
    public static final int STATUS_COMMITTED = 3;
    private static final int STATUS_ROLLING_BACK = 4;
    private static final int STATUS_ROLLED_BACK = 5;
    private static final String[] STATUS_NAMES = new String[]{"CLOSED", "OPEN", "PREPARED", "COMMITTED", "ROLLING_BACK", "ROLLED_BACK"};
    static final int LOG_ID_BITS = 40;
    private static final int LOG_ID_BITS1 = 41;
    private static final long LOG_ID_LIMIT = 0x10000000000L;
    private static final long LOG_ID_MASK = 0x1FFFFFFFFFFL;
    private static final int STATUS_BITS = 4;
    private static final int STATUS_MASK = 15;
    final TransactionStore store;
    final TransactionStore.RollbackListener listener;
    final int transactionId;
    final long sequenceNum;
    private final AtomicLong statusAndLogId;
    private MVStore.TxCounter txCounter;
    private String name;
    boolean wasStored;
    int timeoutMillis;
    private final int ownerId;
    private volatile Transaction blockingTransaction;
    private String blockingMapName;
    private Object blockingKey;
    private volatile boolean notificationRequested;
    private RootReference<Long, Record<?, ?>>[] undoLogRootReferences;
    private final Map<Integer, TransactionMap<?, ?>> transactionMaps = new HashMap();
    final IsolationLevel isolationLevel;

    Transaction(TransactionStore store, int transactionId, long sequenceNum, int status, String name, long logId, int timeoutMillis, int ownerId, IsolationLevel isolationLevel, TransactionStore.RollbackListener listener) {
        this.store = store;
        this.transactionId = transactionId;
        this.sequenceNum = sequenceNum;
        this.statusAndLogId = new AtomicLong(Transaction.composeState(status, logId, false));
        this.name = name;
        this.setTimeoutMillis(timeoutMillis);
        this.ownerId = ownerId;
        this.isolationLevel = isolationLevel;
        this.listener = listener;
    }

    public int getId() {
        return this.transactionId;
    }

    public long getSequenceNum() {
        return this.sequenceNum;
    }

    public int getStatus() {
        return Transaction.getStatus(this.statusAndLogId.get());
    }

    RootReference<Long, Record<?, ?>>[] getUndoLogRootReferences() {
        return this.undoLogRootReferences;
    }

    private long setStatus(int status) {
        long logId;
        long newState;
        long currentState;
        do {
            boolean valid;
            currentState = this.statusAndLogId.get();
            logId = Transaction.getLogId(currentState);
            int currentStatus = Transaction.getStatus(currentState);
            switch (status) {
                case 4: {
                    valid = currentStatus == 1;
                    break;
                }
                case 2: {
                    valid = currentStatus == 1;
                    break;
                }
                case 3: {
                    valid = currentStatus == 1 || currentStatus == 2 || currentStatus == 3;
                    break;
                }
                case 5: {
                    valid = currentStatus == 1 || currentStatus == 2 || currentStatus == 4;
                    break;
                }
                case 0: {
                    valid = currentStatus == 3 || currentStatus == 5;
                    break;
                }
                default: {
                    valid = false;
                }
            }
            if (valid) continue;
            throw DataUtils.newMVStoreException(103, "Transaction was illegally transitioned from {0} to {1}", Transaction.getStatusName(currentStatus), Transaction.getStatusName(status));
        } while (!this.statusAndLogId.compareAndSet(currentState, newState = Transaction.composeState(status, logId, Transaction.hasRollback(currentState))));
        return currentState;
    }

    public boolean hasChanges() {
        return Transaction.hasChanges(this.statusAndLogId.get());
    }

    public void setName(String name) {
        this.checkNotClosed();
        this.name = name;
        this.store.storeTransaction(this);
    }

    public String getName() {
        return this.name;
    }

    public int getBlockerId() {
        Transaction blocker = this.blockingTransaction;
        return blocker == null ? 0 : blocker.ownerId;
    }

    public long setSavepoint() {
        return this.getLogId();
    }

    public boolean hasStatementDependencies() {
        return !this.transactionMaps.isEmpty();
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    boolean isReadCommitted() {
        return this.isolationLevel == IsolationLevel.READ_COMMITTED;
    }

    public boolean allowNonRepeatableRead() {
        return this.isolationLevel.allowNonRepeatableRead();
    }

    public void markStatementStart(HashSet<MVMap<Object, VersionedValue<Object>>> maps) {
        this.markStatementEnd();
        if (this.txCounter == null && this.store.store.isVersioningRequired()) {
            this.txCounter = this.store.store.registerVersionUsage();
        }
        if (maps != null && !maps.isEmpty()) {
            TransactionMap<Object, Object> txMap;
            BitSet committingTransactions;
            do {
                committingTransactions = this.store.committingTransactions.get();
                for (MVMap<Object, VersionedValue<Object>> map : maps) {
                    txMap = this.openMapX(map);
                    txMap.setStatementSnapshot(new Snapshot<Object, VersionedValue<Object>>(map.flushAndGetRoot(), committingTransactions));
                }
                if (!this.isReadCommitted()) continue;
                this.undoLogRootReferences = this.store.collectUndoLogRootReferences();
            } while (committingTransactions != this.store.committingTransactions.get());
            for (MVMap<Object, VersionedValue<Object>> map : maps) {
                txMap = this.openMapX(map);
                txMap.promoteSnapshot();
            }
        }
    }

    public void markStatementEnd() {
        if (this.allowNonRepeatableRead()) {
            this.releaseSnapshot();
        }
        for (TransactionMap<?, ?> transactionMap : this.transactionMaps.values()) {
            transactionMap.setStatementSnapshot(null);
        }
    }

    private void markTransactionEnd() {
        if (!this.allowNonRepeatableRead()) {
            this.releaseSnapshot();
        }
    }

    private void releaseSnapshot() {
        this.transactionMaps.clear();
        this.undoLogRootReferences = null;
        MVStore.TxCounter counter = this.txCounter;
        if (counter != null) {
            this.txCounter = null;
            this.store.store.deregisterVersionUsage(counter);
        }
    }

    long log(Record<?, ?> logRecord) {
        long currentState = this.statusAndLogId.getAndIncrement();
        long logId = Transaction.getLogId(currentState);
        if (logId >= 0x10000000000L) {
            throw DataUtils.newMVStoreException(104, "Transaction {0} has too many changes", this.transactionId);
        }
        int currentStatus = Transaction.getStatus(currentState);
        this.checkOpen(currentStatus);
        long undoKey = this.store.addUndoLogRecord(this.transactionId, logId, logRecord);
        return undoKey;
    }

    void logUndo() {
        long currentState = this.statusAndLogId.decrementAndGet();
        long logId = Transaction.getLogId(currentState);
        if (logId >= 0x10000000000L) {
            throw DataUtils.newMVStoreException(100, "Transaction {0} has internal error", this.transactionId);
        }
        int currentStatus = Transaction.getStatus(currentState);
        this.checkOpen(currentStatus);
        this.store.removeUndoLogRecord(this.transactionId);
    }

    public <K, V> TransactionMap<K, V> openMap(String name) {
        return this.openMap(name, null, null);
    }

    public <K, V> TransactionMap<K, V> openMap(String name, DataType<K> keyType, DataType<V> valueType) {
        MVMap<K, VersionedValue<V>> map = this.store.openVersionedMap(name, keyType, valueType);
        return this.openMapX(map);
    }

    public <K, V> TransactionMap<K, V> openMapX(MVMap<K, VersionedValue<V>> map) {
        this.checkNotClosed();
        int id = map.getId();
        TransactionMap<Object, Object> transactionMap = this.transactionMaps.get(id);
        if (transactionMap == null) {
            transactionMap = new TransactionMap<K, V>(this, map);
            this.transactionMaps.put(id, transactionMap);
        }
        return transactionMap;
    }

    public void prepare() {
        this.setStatus(2);
        this.store.storeTransaction(this);
    }

    public void commit() {
        assert (this.store.openTransactions.get().get(this.transactionId));
        this.markTransactionEnd();
        Throwable ex = null;
        boolean hasChanges = false;
        int previousStatus = 1;
        try {
            long state = this.setStatus(3);
            hasChanges = Transaction.hasChanges(state);
            previousStatus = Transaction.getStatus(state);
            if (hasChanges) {
                this.store.commit(this, previousStatus == 3);
            }
        }
        catch (Throwable e) {
            ex = e;
            throw e;
        }
        finally {
            if (Transaction.isActive(previousStatus)) {
                try {
                    this.store.endTransaction(this, hasChanges);
                }
                catch (Throwable e) {
                    if (ex == null) {
                        throw e;
                    }
                    ex.addSuppressed(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackToSavepoint(long savepointId) {
        boolean success;
        long lastState = this.setStatus(4);
        long logId = Transaction.getLogId(lastState);
        try {
            this.store.rollbackTo(this, logId, savepointId);
        }
        finally {
            this.notifyAllWaitingTransactions();
            long expectedState = Transaction.composeState(4, logId, Transaction.hasRollback(lastState));
            long newState = Transaction.composeState(1, savepointId, true);
            while (!(success = this.statusAndLogId.compareAndSet(expectedState, newState)) && this.statusAndLogId.get() == expectedState) {
            }
        }
        if (!success) {
            throw DataUtils.newMVStoreException(103, "Transaction {0} concurrently modified while rollback to savepoint was in progress", this.transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this.markTransactionEnd();
        Throwable ex = null;
        int status = 1;
        try {
            long lastState = this.setStatus(5);
            status = Transaction.getStatus(lastState);
            long logId = Transaction.getLogId(lastState);
            if (logId > 0L) {
                this.store.rollbackTo(this, logId, 0L);
            }
        }
        catch (Throwable e) {
            status = this.getStatus();
            if (Transaction.isActive(status)) {
                ex = e;
                throw e;
            }
        }
        finally {
            try {
                if (Transaction.isActive(status)) {
                    this.store.endTransaction(this, true);
                }
            }
            catch (Throwable e) {
                if (ex == null) {
                    throw e;
                }
                ex.addSuppressed(e);
            }
        }
    }

    private static boolean isActive(int status) {
        return status != 0 && status != 3 && status != 5;
    }

    public Iterator<TransactionStore.Change> getChanges(long savepointId) {
        return this.store.getChanges(this, this.getLogId(), savepointId);
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis > 0 ? timeoutMillis : this.store.timeoutMillis;
    }

    private long getLogId() {
        return Transaction.getLogId(this.statusAndLogId.get());
    }

    private void checkOpen(int status) {
        if (status != 1) {
            throw DataUtils.newMVStoreException(103, "Transaction {0} has status {1}, not OPEN", this.transactionId, Transaction.getStatusName(status));
        }
    }

    private void checkNotClosed() {
        if (this.getStatus() == 0) {
            throw DataUtils.newMVStoreException(4, "Transaction {0} is closed", this.transactionId);
        }
    }

    void closeIt() {
        this.transactionMaps.clear();
        long lastState = this.setStatus(0);
        this.store.store.deregisterVersionUsage(this.txCounter);
        if (Transaction.hasChanges(lastState) || Transaction.hasRollback(lastState)) {
            this.notifyAllWaitingTransactions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllWaitingTransactions() {
        if (this.notificationRequested) {
            Transaction transaction = this;
            synchronized (transaction) {
                this.notifyAll();
            }
        }
    }

    public boolean waitFor(Transaction toWaitFor, String mapName, Object key) {
        this.blockingTransaction = toWaitFor;
        this.blockingMapName = mapName;
        this.blockingKey = key;
        if (this.isDeadlocked(toWaitFor)) {
            this.tryThrowDeadLockException(false);
        }
        boolean result = toWaitFor.waitForThisToEnd(this.timeoutMillis, this);
        this.blockingMapName = null;
        this.blockingKey = null;
        this.blockingTransaction = null;
        return result;
    }

    private boolean isDeadlocked(Transaction toWaitFor) {
        Transaction nextTx;
        Transaction youngest = toWaitFor;
        Transaction tx = toWaitFor;
        for (int backstop = this.store.getMaxTransactionId(); (nextTx = tx.blockingTransaction) != null && tx.getStatus() == 1 && backstop > 0; --backstop) {
            if (nextTx.sequenceNum > youngest.sequenceNum) {
                youngest = nextTx;
            }
            if (nextTx == this) {
                if (youngest == this) {
                    return true;
                }
                Transaction btx = youngest.blockingTransaction;
                if (btx != null) {
                    youngest.setStatus(4);
                    btx.notifyAllWaitingTransactions();
                    return false;
                }
            }
            tx = nextTx;
        }
        return false;
    }

    private void tryThrowDeadLockException(boolean throwIt) {
        Transaction nextTx;
        BitSet visited = new BitSet();
        StringBuilder details = new StringBuilder(String.format("Transaction %d has been chosen as a deadlock victim. Details:%n", this.transactionId));
        Transaction tx = this;
        while (!visited.get(tx.transactionId) && (nextTx = tx.blockingTransaction) != null) {
            visited.set(tx.transactionId);
            details.append(String.format("Transaction %d attempts to update map <%s> entry with key <%s> modified by transaction %s%n", tx.transactionId, tx.blockingMapName, tx.blockingKey, tx.blockingTransaction));
            if (nextTx == this) {
                throwIt = true;
            }
            tx = nextTx;
        }
        if (throwIt) {
            throw DataUtils.newMVStoreException(105, "{0}", details.toString());
        }
    }

    private synchronized boolean waitForThisToEnd(int millis, Transaction waiter) {
        long state;
        int status;
        long until = System.currentTimeMillis() + (long)millis;
        this.notificationRequested = true;
        while ((status = Transaction.getStatus(state = this.statusAndLogId.get())) != 0 && status != 5 && !Transaction.hasRollback(state)) {
            long dur;
            if (waiter.getStatus() != 1) {
                waiter.tryThrowDeadLockException(true);
            }
            if ((dur = until - System.currentTimeMillis()) <= 0L) {
                return false;
            }
            try {
                this.wait(dur);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return true;
    }

    public <K, V> void removeMap(TransactionMap<K, V> map) {
        this.store.removeMap(map);
    }

    public String toString() {
        return this.transactionId + "(" + this.sequenceNum + ") " + this.stateToString();
    }

    private String stateToString() {
        return Transaction.stateToString(this.statusAndLogId.get());
    }

    private static String stateToString(long state) {
        return Transaction.getStatusName(Transaction.getStatus(state)) + (Transaction.hasRollback(state) ? "<" : "") + " " + Transaction.getLogId(state);
    }

    private static int getStatus(long state) {
        return (int)(state >>> 41) & 0xF;
    }

    private static long getLogId(long state) {
        return state & 0x1FFFFFFFFFFL;
    }

    private static boolean hasRollback(long state) {
        return (state & 0x200000000000L) != 0L;
    }

    private static boolean hasChanges(long state) {
        return Transaction.getLogId(state) != 0L;
    }

    private static long composeState(int status, long logId, boolean hasRollback) {
        assert (logId < 0x10000000000L) : logId;
        assert ((status & 0xFFFFFFF0) == 0) : status;
        if (hasRollback) {
            status |= 0x10;
        }
        return (long)status << 41 | logId;
    }

    private static String getStatusName(int status) {
        return status >= 0 && status < STATUS_NAMES.length ? STATUS_NAMES[status] : "UNKNOWN_STATUS_" + status;
    }
}

