/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;

public final class ByteArrayDataType
extends BasicDataType<byte[]> {
    public static final ByteArrayDataType INSTANCE = new ByteArrayDataType();

    private ByteArrayDataType() {
    }

    @Override
    public int getMemory(byte[] data) {
        return data.length;
    }

    @Override
    public void write(WriteBuffer buff, byte[] data) {
        buff.putVarInt(data.length);
        buff.put(data);
    }

    @Override
    public byte[] read(ByteBuffer buff) {
        int size = DataUtils.readVarInt(buff);
        byte[] data = new byte[size];
        buff.get(data);
        return data;
    }

    public byte[][] createStorage(int size) {
        return new byte[size][];
    }
}

