/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StatefulDataType;

public final class MetaType<D>
extends BasicDataType<DataType<?>> {
    private final D database;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Map<String, Object> cache = new HashMap<String, Object>();

    public MetaType(D database, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.database = database;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public int compare(DataType<?> a, DataType<?> b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemory(DataType<?> obj) {
        return 24;
    }

    @Override
    public void write(WriteBuffer buff, DataType<?> obj) {
        StatefulDataType.Factory factory;
        Class<?> clazz = obj.getClass();
        StatefulDataType statefulDataType = null;
        if (obj instanceof StatefulDataType && (factory = (statefulDataType = (StatefulDataType)((Object)obj)).getFactory()) != null) {
            clazz = factory.getClass();
        }
        String className = clazz.getName();
        int len = className.length();
        buff.putVarInt(len).putStringData(className, len);
        if (statefulDataType != null) {
            statefulDataType.save(buff, this);
        }
    }

    @Override
    public DataType<?> read(ByteBuffer buff) {
        int len = DataUtils.readVarInt(buff);
        String className = DataUtils.readString(buff, len);
        try {
            Object obj;
            Object o = this.cache.get(className);
            if (o != null) {
                if (o instanceof StatefulDataType.Factory) {
                    return ((StatefulDataType.Factory)o).create(buff, this, this.database);
                }
                return (DataType)o;
            }
            Class<?> clazz = Class.forName(className);
            boolean singleton = false;
            try {
                obj = clazz.getDeclaredField("INSTANCE").get(null);
                singleton = true;
            }
            catch (NullPointerException | ReflectiveOperationException e) {
                obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (obj instanceof StatefulDataType.Factory) {
                StatefulDataType.Factory factory = (StatefulDataType.Factory)obj;
                this.cache.put(className, factory);
                return factory.create(buff, this, this.database);
            }
            if (singleton) {
                this.cache.put(className, obj);
            }
            return (DataType)obj;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
            throw new RuntimeException(e);
        }
    }

    public DataType<?>[] createStorage(int size) {
        return new DataType[size];
    }
}

