/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

public class ResultWithPaddedStrings
implements ResultInterface {
    private final ResultInterface source;

    public static ResultInterface get(ResultInterface source) {
        int count = source.getVisibleColumnCount();
        for (int i = 0; i < count; ++i) {
            if (source.getColumnType(i).getValueType() != 1) continue;
            return new ResultWithPaddedStrings(source);
        }
        return source;
    }

    private ResultWithPaddedStrings(ResultInterface source) {
        this.source = source;
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public Value[] currentRow() {
        int count = this.source.getVisibleColumnCount();
        Value[] row = Arrays.copyOf(this.source.currentRow(), count);
        for (int i = 0; i < count; ++i) {
            String s;
            TypeInfo type = this.source.getColumnType(i);
            if (type.getValueType() != 1) continue;
            long precision = type.getPrecision();
            if (precision == Integer.MAX_VALUE) {
                precision = 1L;
            }
            if ((s = row[i].getString()) == null || (long)s.length() >= precision) continue;
            row[i] = ValueVarchar.get(ResultWithPaddedStrings.rightPadWithSpaces(s, MathUtils.convertLongToInt(precision)));
        }
        return row;
    }

    private static String rightPadWithSpaces(String s, int length) {
        int used = s.length();
        if (length <= used) {
            return s;
        }
        char[] res = new char[length];
        s.getChars(0, used, res, 0);
        Arrays.fill(res, used, length, ' ');
        return new String(res);
    }

    @Override
    public boolean next() {
        return this.source.next();
    }

    @Override
    public long getRowId() {
        return this.source.getRowId();
    }

    @Override
    public boolean isAfterLast() {
        return this.source.isAfterLast();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.source.getVisibleColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.source.getRowCount();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public boolean needToClose() {
        return this.source.needToClose();
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public String getAlias(int i) {
        return this.source.getAlias(i);
    }

    @Override
    public String getSchemaName(int i) {
        return this.source.getSchemaName(i);
    }

    @Override
    public String getTableName(int i) {
        return this.source.getTableName(i);
    }

    @Override
    public String getColumnName(int i) {
        return this.source.getColumnName(i);
    }

    @Override
    public TypeInfo getColumnType(int i) {
        return this.source.getColumnType(i);
    }

    @Override
    public boolean isIdentity(int i) {
        return this.source.isIdentity(i);
    }

    @Override
    public int getNullable(int i) {
        return this.source.getNullable(i);
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.source.setFetchSize(fetchSize);
    }

    @Override
    public int getFetchSize() {
        return this.source.getFetchSize();
    }

    @Override
    public boolean isLazy() {
        return this.source.isLazy();
    }

    @Override
    public boolean isClosed() {
        return this.source.isClosed();
    }

    @Override
    public ResultInterface createShallowCopy(Session targetSession) {
        ResultInterface copy = this.source.createShallowCopy(targetSession);
        return copy != null ? new ResultWithPaddedStrings(copy) : null;
    }
}

