/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.engine.CastDataProvider;
import org.h2.mvstore.db.RowDataType;
import org.h2.result.DefaultRow;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRowValue;
import org.h2.result.Sparse;
import org.h2.store.DataHandler;
import org.h2.table.IndexColumn;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.Value;

public abstract class RowFactory {
    public static DefaultRowFactory getDefaultRowFactory() {
        return DefaultRowFactory.INSTANCE;
    }

    public static RowFactory getRowFactory() {
        return Holder.EFFECTIVE;
    }

    public RowFactory createRowFactory(CastDataProvider provider, CompareMode compareMode, DataHandler handler, Typed[] columns, IndexColumn[] indexColumns, boolean storeKeys) {
        return this;
    }

    public abstract Row createRow(Value[] var1, int var2);

    public abstract SearchRow createRow();

    public abstract RowDataType getRowDataType();

    public abstract int[] getIndexes();

    public abstract TypeInfo[] getColumnTypes();

    public abstract int getColumnCount();

    public abstract boolean getStoreKeys();

    public static final class DefaultRowFactory
    extends RowFactory {
        private final RowDataType dataType;
        private final int columnCount;
        private final int[] indexes;
        private TypeInfo[] columnTypes;
        private final int[] map;
        public static final DefaultRowFactory INSTANCE = new DefaultRowFactory();

        DefaultRowFactory() {
            this(new RowDataType(null, CompareMode.getInstance(null, 0), null, null, null, 0, true), 0, null, null);
        }

        private DefaultRowFactory(RowDataType dataType, int columnCount, int[] indexes, TypeInfo[] columnTypes) {
            this.dataType = dataType;
            this.columnCount = columnCount;
            this.indexes = indexes;
            if (indexes == null) {
                this.map = null;
            } else {
                this.map = new int[columnCount];
                int i = 0;
                int l = indexes.length;
                while (i < l) {
                    this.map[indexes[i]] = ++i;
                }
            }
            this.columnTypes = columnTypes;
        }

        @Override
        public RowFactory createRowFactory(CastDataProvider provider, CompareMode compareMode, DataHandler handler, Typed[] columns, IndexColumn[] indexColumns, boolean storeKeys) {
            int[] indexes = null;
            int[] sortTypes = null;
            TypeInfo[] columnTypes = null;
            int columnCount = 0;
            if (columns != null) {
                int i;
                columnCount = columns.length;
                if (indexColumns == null) {
                    sortTypes = new int[columnCount];
                    for (i = 0; i < columnCount; ++i) {
                        sortTypes[i] = 0;
                    }
                } else {
                    int len = indexColumns.length;
                    indexes = new int[len];
                    sortTypes = new int[len];
                    for (int i2 = 0; i2 < len; ++i2) {
                        IndexColumn indexColumn = indexColumns[i2];
                        indexes[i2] = indexColumn.column.getColumnId();
                        sortTypes[i2] = indexColumn.sortType;
                    }
                }
                columnTypes = new TypeInfo[columnCount];
                for (i = 0; i < columnCount; ++i) {
                    columnTypes[i] = columns[i].getType();
                }
            }
            return this.createRowFactory(provider, compareMode, handler, sortTypes, indexes, columnTypes, columnCount, storeKeys);
        }

        public RowFactory createRowFactory(CastDataProvider provider, CompareMode compareMode, DataHandler handler, int[] sortTypes, int[] indexes, TypeInfo[] columnTypes, int columnCount, boolean storeKeys) {
            RowDataType rowDataType = new RowDataType(provider, compareMode, handler, sortTypes, indexes, columnCount, storeKeys);
            DefaultRowFactory rowFactory = new DefaultRowFactory(rowDataType, columnCount, indexes, columnTypes);
            rowDataType.setRowFactory(rowFactory);
            return rowFactory;
        }

        @Override
        public Row createRow(Value[] data, int memory) {
            return new DefaultRow(data, memory);
        }

        @Override
        public SearchRow createRow() {
            if (this.indexes == null) {
                return new DefaultRow(this.columnCount);
            }
            if (this.indexes.length == 1) {
                return new SimpleRowValue(this.columnCount, this.indexes[0]);
            }
            return new Sparse(this.columnCount, this.indexes.length, this.map);
        }

        @Override
        public RowDataType getRowDataType() {
            return this.dataType;
        }

        @Override
        public int[] getIndexes() {
            return this.indexes;
        }

        @Override
        public TypeInfo[] getColumnTypes() {
            return this.columnTypes;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public boolean getStoreKeys() {
            return this.dataType.isStoreKeys();
        }
    }

    private static final class Holder {
        static final RowFactory EFFECTIVE = DefaultRowFactory.INSTANCE;

        private Holder() {
        }
    }
}

