/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.command.query.QueryOrderBy;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.mode.DefaultNullOrdering;
import org.h2.table.Column;
import org.h2.table.TableFilter;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

public final class SortOrder
implements Comparator<Value[]> {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private final SessionLocal session;
    private final int[] queryColumnIndexes;
    private final int[] sortTypes;
    private final ArrayList<QueryOrderBy> orderList;

    public SortOrder(SessionLocal session, int[] queryColumnIndexes) {
        this(session, queryColumnIndexes, new int[queryColumnIndexes.length], null);
    }

    public SortOrder(SessionLocal session, int[] queryColumnIndexes, int[] sortType, ArrayList<QueryOrderBy> orderList) {
        this.session = session;
        this.queryColumnIndexes = queryColumnIndexes;
        this.sortTypes = sortType;
        this.orderList = orderList;
    }

    public StringBuilder getSQL(StringBuilder builder, Expression[] list, int visible, int sqlFlags) {
        int i = 0;
        for (int idx : this.queryColumnIndexes) {
            if (i > 0) {
                builder.append(", ");
            }
            if (idx < visible) {
                builder.append(idx + 1);
            } else {
                list[idx].getUnenclosedSQL(builder, sqlFlags);
            }
            SortOrder.typeToString(builder, this.sortTypes[i++]);
        }
        return builder;
    }

    public static void typeToString(StringBuilder builder, int type) {
        if ((type & 1) != 0) {
            builder.append(" DESC");
        }
        if ((type & 2) != 0) {
            builder.append(" NULLS FIRST");
        } else if ((type & 4) != 0) {
            builder.append(" NULLS LAST");
        }
    }

    @Override
    public int compare(Value[] a, Value[] b) {
        int len = this.queryColumnIndexes.length;
        for (int i = 0; i < len; ++i) {
            boolean bNull;
            int idx = this.queryColumnIndexes[i];
            int type = this.sortTypes[i];
            Value ao = a[idx];
            Value bo = b[idx];
            boolean aNull = ao == ValueNull.INSTANCE;
            boolean bl = bNull = bo == ValueNull.INSTANCE;
            if (aNull || bNull) {
                if (aNull == bNull) continue;
                return this.session.getDatabase().getDefaultNullOrdering().compareNull(aNull, type);
            }
            int comp = this.session.compare(ao, bo);
            if (comp == 0) continue;
            return (type & 1) == 0 ? comp : -comp;
        }
        return 0;
    }

    public void sort(ArrayList<Value[]> rows) {
        rows.sort(this);
    }

    public void sort(ArrayList<Value[]> rows, int fromInclusive, int toExclusive) {
        if (toExclusive == 1 && fromInclusive == 0) {
            rows.set(0, Collections.min(rows, this));
            return;
        }
        Value[][] arr = (Value[][])rows.toArray((T[])new Value[0][]);
        Utils.sortTopN(arr, fromInclusive, toExclusive, this);
        for (int i = fromInclusive; i < toExclusive; ++i) {
            rows.set(i, arr[i]);
        }
    }

    public int[] getQueryColumnIndexes() {
        return this.queryColumnIndexes;
    }

    public Column getColumn(int index, TableFilter filter) {
        if (this.orderList == null) {
            return null;
        }
        QueryOrderBy order = this.orderList.get(index);
        Expression expr = order.expression;
        if (expr == null) {
            return null;
        }
        if ((expr = expr.getNonAliasExpression()).isConstant()) {
            return null;
        }
        if (!(expr instanceof ExpressionColumn)) {
            return null;
        }
        ExpressionColumn exprCol = (ExpressionColumn)expr;
        if (exprCol.getTableFilter() != filter) {
            return null;
        }
        return exprCol.getColumn();
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }

    public ArrayList<QueryOrderBy> getOrderList() {
        return this.orderList;
    }

    public int[] getSortTypesWithNullOrdering() {
        return SortOrder.addNullOrdering(this.session.getDatabase(), (int[])this.sortTypes.clone());
    }

    public static int[] addNullOrdering(Database database, int[] sortTypes) {
        DefaultNullOrdering defaultNullOrdering = database.getDefaultNullOrdering();
        int length = sortTypes.length;
        for (int i = 0; i < length; ++i) {
            sortTypes[i] = defaultNullOrdering.addExplicitNullOrdering(sortTypes[i]);
        }
        return sortTypes;
    }

    public Comparator<Value> getRowValueComparator() {
        return (o1, o2) -> this.compare(((ValueRow)o1).getList(), ((ValueRow)o2).getList());
    }
}

