/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.ArrayList;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintDomain;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.ColumnTemplate;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class Domain
extends SchemaObject
implements ColumnTemplate {
    private TypeInfo type;
    private Domain domain;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private ArrayList<ConstraintDomain> constraints;

    public Domain(Schema schema, int id, String name) {
        super(schema, id, name, 8);
    }

    @Override
    public String getDropSQL() {
        StringBuilder builder = new StringBuilder("DROP DOMAIN IF EXISTS ");
        return this.getSQL(builder, 0).toString();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder builder = this.getSQL(new StringBuilder("CREATE DOMAIN "), 0).append(" AS ");
        if (this.domain != null) {
            this.domain.getSQL(builder, 0);
        } else {
            this.type.getSQL(builder, 0);
        }
        if (this.defaultExpression != null) {
            this.defaultExpression.getUnenclosedSQL(builder.append(" DEFAULT "), 0);
        }
        if (this.onUpdateExpression != null) {
            this.onUpdateExpression.getUnenclosedSQL(builder.append(" ON UPDATE "), 0);
        }
        return builder.toString();
    }

    public void setDataType(TypeInfo type) {
        this.type = type;
    }

    public TypeInfo getDataType() {
        return this.type;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void setDefaultExpression(SessionLocal session, Expression defaultExpression) {
        if (defaultExpression != null && (defaultExpression = defaultExpression.optimize(session)).isConstant()) {
            defaultExpression = ValueExpression.get(defaultExpression.getValue(session));
        }
        this.defaultExpression = defaultExpression;
    }

    @Override
    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public Expression getEffectiveDefaultExpression() {
        return this.defaultExpression != null ? this.defaultExpression : (this.domain != null ? this.domain.getEffectiveDefaultExpression() : null);
    }

    @Override
    public String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getUnenclosedSQL(new StringBuilder(), 0).toString();
    }

    @Override
    public void setOnUpdateExpression(SessionLocal session, Expression onUpdateExpression) {
        if (onUpdateExpression != null && (onUpdateExpression = onUpdateExpression.optimize(session)).isConstant()) {
            onUpdateExpression = ValueExpression.get(onUpdateExpression.getValue(session));
        }
        this.onUpdateExpression = onUpdateExpression;
    }

    @Override
    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    @Override
    public Expression getEffectiveOnUpdateExpression() {
        return this.onUpdateExpression != null ? this.onUpdateExpression : (this.domain != null ? this.domain.getEffectiveOnUpdateExpression() : null);
    }

    @Override
    public String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getUnenclosedSQL(new StringBuilder(), 0).toString();
    }

    @Override
    public void prepareExpressions(SessionLocal session) {
        if (this.defaultExpression != null) {
            this.defaultExpression = this.defaultExpression.optimize(session);
        }
        if (this.onUpdateExpression != null) {
            this.onUpdateExpression = this.onUpdateExpression.optimize(session);
        }
        if (this.domain != null) {
            this.domain.prepareExpressions(session);
        }
    }

    public void addConstraint(ConstraintDomain constraint) {
        if (this.constraints == null) {
            this.constraints = Utils.newSmallArrayList();
        }
        if (!this.constraints.contains(constraint)) {
            this.constraints.add(constraint);
        }
    }

    public ArrayList<ConstraintDomain> getConstraints() {
        return this.constraints;
    }

    public void removeConstraint(Constraint constraint) {
        if (this.constraints != null) {
            this.constraints.remove(constraint);
        }
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        if (this.constraints != null && !this.constraints.isEmpty()) {
            for (ConstraintDomain constraint : this.constraints.toArray(new ConstraintDomain[0])) {
                this.database.removeSchemaObject(session, constraint);
            }
            this.constraints = null;
        }
        this.database.removeMeta(session, this.getId());
    }

    public void checkConstraints(SessionLocal session, Value value) {
        if (this.constraints != null) {
            for (ConstraintDomain constraint : this.constraints) {
                constraint.check(session, value);
            }
        }
        if (this.domain != null) {
            this.domain.checkConstraints(session, value);
        }
    }
}

