/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.h2.Driver;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.Column;
import org.h2.util.JdbcUtils;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueToObjectConverter2;

public final class FunctionAlias
extends UserDefinedFunction {
    private String methodName;
    private String source;
    private JavaMethod[] javaMethods;
    private boolean deterministic;

    private FunctionAlias(Schema schema, int id, String name) {
        super(schema, id, name, 3);
    }

    public static FunctionAlias newInstance(Schema schema, int id, String name, String javaClassMethod, boolean force) {
        FunctionAlias alias = new FunctionAlias(schema, id, name);
        int paren = javaClassMethod.indexOf(40);
        int lastDot = javaClassMethod.lastIndexOf(46, paren < 0 ? javaClassMethod.length() : paren);
        if (lastDot < 0) {
            throw DbException.get(42000, javaClassMethod);
        }
        alias.className = javaClassMethod.substring(0, lastDot);
        alias.methodName = javaClassMethod.substring(lastDot + 1);
        alias.init(force);
        return alias;
    }

    public static FunctionAlias newInstanceFromSource(Schema schema, int id, String name, String source, boolean force) {
        FunctionAlias alias = new FunctionAlias(schema, id, name);
        alias.source = source;
        alias.init(force);
        return alias;
    }

    private void init(boolean force) {
        block2: {
            try {
                this.load();
            }
            catch (DbException e) {
                if (force) break block2;
                throw e;
            }
        }
    }

    private synchronized void load() {
        if (this.javaMethods != null) {
            return;
        }
        if (this.source != null) {
            this.loadFromSource();
        } else {
            this.loadClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSource() {
        SourceCompiler compiler;
        SourceCompiler sourceCompiler = compiler = this.database.getCompiler();
        synchronized (sourceCompiler) {
            String fullClassName = "org.h2.dynamic." + this.getName();
            compiler.setSource(fullClassName, this.source);
            try {
                Method m = compiler.getMethod(fullClassName);
                JavaMethod method = new JavaMethod(m, 0);
                this.javaMethods = new JavaMethod[]{method};
            }
            catch (DbException e) {
                throw e;
            }
            catch (Exception e) {
                throw DbException.get(42000, e, this.source);
            }
        }
    }

    private void loadClass() {
        Class javaClass = JdbcUtils.loadUserClass(this.className);
        Method[] methods = javaClass.getMethods();
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>(1);
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            Method m = methods[i];
            if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(this.methodName) && !FunctionAlias.getMethodSignature(m).equals(this.methodName)) continue;
            JavaMethod javaMethod = new JavaMethod(m, i);
            for (JavaMethod old : list) {
                if (old.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw DbException.get(90073, old.toString(), javaMethod.toString());
            }
            list.add(javaMethod);
        }
        if (list.isEmpty()) {
            throw DbException.get(90139, this.methodName + " (" + this.className + ")");
        }
        this.javaMethods = list.toArray(new JavaMethod[0]);
        Arrays.sort(this.javaMethods);
    }

    private static String getMethodSignature(Method m) {
        StringBuilder buff = new StringBuilder(m.getName());
        buff.append('(');
        Class<?>[] parameterTypes = m.getParameterTypes();
        int length = parameterTypes.length;
        for (int i = 0; i < length; ++i) {
            Class<?> p;
            if (i > 0) {
                buff.append(',');
            }
            if ((p = parameterTypes[i]).isArray()) {
                buff.append(p.getComponentType().getName()).append("[]");
                continue;
            }
            buff.append(p.getName());
        }
        return buff.append(')').toString();
    }

    @Override
    public String getDropSQL() {
        return this.getSQL(new StringBuilder("DROP ALIAS IF EXISTS "), 0).toString();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder builder = new StringBuilder("CREATE FORCE ALIAS ");
        this.getSQL(builder, 0);
        if (this.deterministic) {
            builder.append(" DETERMINISTIC");
        }
        if (this.source != null) {
            StringUtils.quoteStringSQL(builder.append(" AS "), this.source);
        } else {
            StringUtils.quoteStringSQL(builder.append(" FOR "), this.className + '.' + this.methodName);
        }
        return builder.toString();
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public synchronized void removeChildrenAndResources(SessionLocal session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.methodName = null;
        this.javaMethods = null;
        this.invalidate();
    }

    public JavaMethod findJavaMethod(Expression[] args) {
        this.load();
        int parameterCount = args.length;
        for (JavaMethod m : this.javaMethods) {
            int count = m.getParameterCount();
            if (count != parameterCount && (!m.isVarArgs() || count > parameterCount + 1)) continue;
            return m;
        }
        throw DbException.get(90087, this.getName() + " (" + this.className + ", parameter count: " + parameterCount + ")");
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public JavaMethod[] getJavaMethods() {
        this.load();
        return this.javaMethods;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getSource() {
        return this.source;
    }

    public static class JavaMethod
    implements Comparable<JavaMethod> {
        private final int id;
        private final Method method;
        private final TypeInfo dataType;
        private boolean hasConnectionParam;
        private boolean varArgs;
        private Class<?> varArgClass;
        private int paramCount;

        JavaMethod(Method method, int id) {
            Class<?> returnClass;
            Class<?> lastArg;
            Class<?> paramClass;
            this.method = method;
            this.id = id;
            Class<?>[] paramClasses = method.getParameterTypes();
            this.paramCount = paramClasses.length;
            if (this.paramCount > 0 && Connection.class.isAssignableFrom(paramClass = paramClasses[0])) {
                this.hasConnectionParam = true;
                --this.paramCount;
            }
            if (this.paramCount > 0 && (lastArg = paramClasses[paramClasses.length - 1]).isArray() && method.isVarArgs()) {
                this.varArgs = true;
                this.varArgClass = lastArg.getComponentType();
            }
            this.dataType = ResultSet.class.isAssignableFrom(returnClass = method.getReturnType()) ? null : ValueToObjectConverter2.classToType(returnClass);
        }

        public String toString() {
            return this.method.toString();
        }

        public boolean hasConnectionParam() {
            return this.hasConnectionParam;
        }

        public Value getValue(SessionLocal session, Expression[] args, boolean columnList) {
            Object returnValue = this.execute(session, args, columnList);
            if (Value.class.isAssignableFrom(this.method.getReturnType())) {
                return (Value)returnValue;
            }
            return ValueToObjectConverter.objectToValue(session, returnValue, this.dataType.getValueType()).convertTo(this.dataType, (CastDataProvider)session);
        }

        public ResultInterface getTableValue(SessionLocal session, Expression[] args, boolean columnList) {
            Object o = this.execute(session, args, columnList);
            if (o == null) {
                throw DbException.get(90000, this.method.getName());
            }
            if (ResultInterface.class.isAssignableFrom(this.method.getReturnType())) {
                return (ResultInterface)o;
            }
            return JavaMethod.resultSetToResult(session, (ResultSet)o, columnList ? 0 : Integer.MAX_VALUE);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ResultInterface resultSetToResult(SessionLocal session, ResultSet resultSet, int maxrows) {
            try (ResultSet rs = resultSet;){
                ResultSetMetaData meta = rs.getMetaData();
                int columnCount = meta.getColumnCount();
                Expression[] columns = new Expression[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    String alias = meta.getColumnLabel(i + 1);
                    String name = meta.getColumnName(i + 1);
                    String columnTypeName = meta.getColumnTypeName(i + 1);
                    int columnType = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1), columnTypeName);
                    int precision = meta.getPrecision(i + 1);
                    int scale = meta.getScale(i + 1);
                    TypeInfo typeInfo = columnType == 40 && columnTypeName.endsWith(" ARRAY") ? TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.getTypeInfo(DataType.getTypeByName((String)columnTypeName.substring((int)0, (int)(columnTypeName.length() - 6)), (Mode)session.getMode()).type)) : TypeInfo.getTypeInfo(columnType, precision, scale, null);
                    Expression e = new ExpressionColumn(session.getDatabase(), new Column(name, typeInfo));
                    if (!alias.equals(name)) {
                        e = new Alias(e, alias, false);
                    }
                    columns[i] = e;
                }
                LocalResult result = new LocalResult(session, columns, columnCount, columnCount);
                for (int i = 0; i < maxrows && rs.next(); ++i) {
                    Value[] list = new Value[columnCount];
                    for (int j = 0; j < columnCount; ++j) {
                        list[j] = ValueToObjectConverter.objectToValue(session, rs.getObject(j + 1), columns[j].getType().getValueType());
                    }
                    result.addRow(list);
                }
                result.done();
                LocalResult localResult = result;
                return localResult;
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object execute(SessionLocal session, Expression[] args, boolean columnList) {
            Value v;
            Class<?>[] paramClasses = this.method.getParameterTypes();
            Object[] params = new Object[paramClasses.length];
            int p = 0;
            JdbcConnection conn = session.createConnection(columnList);
            if (this.hasConnectionParam && params.length > 0) {
                params[p++] = conn;
            }
            Object varArg = null;
            if (this.varArgs) {
                int len = args.length - params.length + 1 + (this.hasConnectionParam ? 1 : 0);
                params[params.length - 1] = varArg = Array.newInstance(this.varArgClass, len);
            }
            int a = 0;
            int len = args.length;
            while (a < len) {
                Object o;
                boolean currentIsVarArg = this.varArgs && p >= paramClasses.length - 1;
                Class<?> paramClass = currentIsVarArg ? this.varArgClass : paramClasses[p];
                v = args[a].getValue(session);
                if (Value.class.isAssignableFrom(paramClass)) {
                    o = v;
                } else {
                    boolean primitive = paramClass.isPrimitive();
                    if (v == ValueNull.INSTANCE) {
                        if (primitive) {
                            if (!columnList) return null;
                            o = DataType.getDefaultForPrimitiveType(paramClass);
                        } else {
                            o = null;
                        }
                    } else {
                        o = ValueToObjectConverter.valueToObject(primitive ? Utils.getNonPrimitiveClass(paramClass) : paramClass, v, conn);
                    }
                }
                if (currentIsVarArg) {
                    Array.set(varArg, p - params.length + 1, o);
                } else {
                    params[p] = o;
                }
                ++a;
                ++p;
            }
            boolean old = session.getAutoCommit();
            Value identity = session.getLastIdentity();
            boolean defaultConnection = session.getDatabase().getSettings().defaultConnection;
            try {
                Object returnValue;
                session.setAutoCommit(false);
                try {
                    if (defaultConnection) {
                        Driver.setDefaultConnection(session.createConnection(columnList));
                    }
                    if ((returnValue = this.method.invoke(null, params)) == null) {
                        v = null;
                        return v;
                    }
                }
                catch (InvocationTargetException e) {
                    StringBuilder builder = new StringBuilder(this.method.getName()).append('(');
                    int length = params.length;
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        builder.append(params[i]);
                    }
                    builder.append(')');
                    throw DbException.convertInvocation(e, builder.toString());
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
                Object object = returnValue;
                return object;
            }
            finally {
                session.setLastIdentity(identity);
                session.setAutoCommit(old);
                if (defaultConnection) {
                    Driver.setDefaultConnection(null);
                }
            }
        }

        public Class<?>[] getColumnClasses() {
            return this.method.getParameterTypes();
        }

        public TypeInfo getDataType() {
            return this.dataType;
        }

        public int getParameterCount() {
            return this.paramCount;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        @Override
        public int compareTo(JavaMethod m) {
            if (this.varArgs != m.varArgs) {
                return this.varArgs ? 1 : -1;
            }
            if (this.paramCount != m.paramCount) {
                return this.paramCount - m.paramCount;
            }
            if (this.hasConnectionParam != m.hasConnectionParam) {
                return this.hasConnectionParam ? 1 : -1;
            }
            return this.id - m.id;
        }
    }
}

