/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.security.MessageDigest;
import java.util.Arrays;
import org.h2.util.Bits;

public final class SHA3
extends MessageDigest {
    private static final long[] ROUND_CONSTANTS;
    private final int digestLength;
    private final int rate;
    private long state00;
    private long state01;
    private long state02;
    private long state03;
    private long state04;
    private long state05;
    private long state06;
    private long state07;
    private long state08;
    private long state09;
    private long state10;
    private long state11;
    private long state12;
    private long state13;
    private long state14;
    private long state15;
    private long state16;
    private long state17;
    private long state18;
    private long state19;
    private long state20;
    private long state21;
    private long state22;
    private long state23;
    private long state24;
    private final byte[] buf;
    private int bufcnt;

    public static SHA3 getSha3_224() {
        return new SHA3("SHA3-224", 28);
    }

    public static SHA3 getSha3_256() {
        return new SHA3("SHA3-256", 32);
    }

    public static SHA3 getSha3_384() {
        return new SHA3("SHA3-384", 48);
    }

    public static SHA3 getSha3_512() {
        return new SHA3("SHA3-512", 64);
    }

    private SHA3(String algorithm, int digestLength) {
        super(algorithm);
        this.digestLength = digestLength;
        this.rate = 200 - digestLength * 2;
        this.buf = new byte[this.rate];
    }

    @Override
    protected byte[] engineDigest() {
        this.buf[this.bufcnt] = 6;
        Arrays.fill(this.buf, this.bufcnt + 1, this.rate, (byte)0);
        int n = this.rate - 1;
        this.buf[n] = (byte)(this.buf[n] | 0x80);
        this.absorbQueue();
        byte[] r = new byte[this.digestLength];
        switch (this.digestLength) {
            case 64: {
                Bits.writeLongLE(r, 56, this.state07);
                Bits.writeLongLE(r, 48, this.state06);
            }
            case 48: {
                Bits.writeLongLE(r, 40, this.state05);
                Bits.writeLongLE(r, 32, this.state04);
            }
            case 32: {
                Bits.writeLongLE(r, 24, this.state03);
                break;
            }
            case 28: {
                Bits.writeIntLE(r, 24, (int)this.state03);
            }
        }
        Bits.writeLongLE(r, 16, this.state02);
        Bits.writeLongLE(r, 8, this.state01);
        Bits.writeLongLE(r, 0, this.state00);
        this.engineReset();
        return r;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestLength;
    }

    @Override
    protected void engineReset() {
        this.state00 = 0L;
        this.state01 = 0L;
        this.state02 = 0L;
        this.state03 = 0L;
        this.state04 = 0L;
        this.state05 = 0L;
        this.state06 = 0L;
        this.state07 = 0L;
        this.state08 = 0L;
        this.state09 = 0L;
        this.state10 = 0L;
        this.state11 = 0L;
        this.state12 = 0L;
        this.state13 = 0L;
        this.state14 = 0L;
        this.state15 = 0L;
        this.state16 = 0L;
        this.state17 = 0L;
        this.state18 = 0L;
        this.state19 = 0L;
        this.state20 = 0L;
        this.state21 = 0L;
        this.state22 = 0L;
        this.state23 = 0L;
        this.state24 = 0L;
        Arrays.fill(this.buf, (byte)0);
        this.bufcnt = 0;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.buf[this.bufcnt++] = input;
        if (this.bufcnt == this.rate) {
            this.absorbQueue();
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        while (len > 0) {
            if (this.bufcnt == 0 && len >= this.rate) {
                do {
                    this.absorb(input, offset);
                    offset += this.rate;
                } while ((len -= this.rate) >= this.rate);
                continue;
            }
            int partialBlock = Math.min(len, this.rate - this.bufcnt);
            System.arraycopy(input, offset, this.buf, this.bufcnt, partialBlock);
            this.bufcnt += partialBlock;
            offset += partialBlock;
            len -= partialBlock;
            if (this.bufcnt != this.rate) continue;
            this.absorbQueue();
        }
    }

    private void absorbQueue() {
        this.absorb(this.buf, 0);
        this.bufcnt = 0;
    }

    private void absorb(byte[] data, int offset) {
        switch (this.digestLength) {
            case 28: {
                this.state17 ^= Bits.readLongLE(data, offset + 136);
            }
            case 32: {
                this.state13 ^= Bits.readLongLE(data, offset + 104);
                this.state14 ^= Bits.readLongLE(data, offset + 112);
                this.state15 ^= Bits.readLongLE(data, offset + 120);
                this.state16 ^= Bits.readLongLE(data, offset + 128);
            }
            case 48: {
                this.state09 ^= Bits.readLongLE(data, offset + 72);
                this.state10 ^= Bits.readLongLE(data, offset + 80);
                this.state11 ^= Bits.readLongLE(data, offset + 88);
                this.state12 ^= Bits.readLongLE(data, offset + 96);
            }
        }
        this.state00 ^= Bits.readLongLE(data, offset);
        this.state01 ^= Bits.readLongLE(data, offset + 8);
        this.state02 ^= Bits.readLongLE(data, offset + 16);
        this.state03 ^= Bits.readLongLE(data, offset + 24);
        this.state04 ^= Bits.readLongLE(data, offset + 32);
        this.state05 ^= Bits.readLongLE(data, offset + 40);
        this.state06 ^= Bits.readLongLE(data, offset + 48);
        this.state07 ^= Bits.readLongLE(data, offset + 56);
        this.state08 ^= Bits.readLongLE(data, offset + 64);
        for (int i = 0; i < 24; ++i) {
            long c0 = this.state00 ^ this.state05 ^ this.state10 ^ this.state15 ^ this.state20;
            long c1 = this.state01 ^ this.state06 ^ this.state11 ^ this.state16 ^ this.state21;
            long c2 = this.state02 ^ this.state07 ^ this.state12 ^ this.state17 ^ this.state22;
            long c3 = this.state03 ^ this.state08 ^ this.state13 ^ this.state18 ^ this.state23;
            long c4 = this.state04 ^ this.state09 ^ this.state14 ^ this.state19 ^ this.state24;
            long dX = (c1 << 1 | c1 >>> 63) ^ c4;
            this.state00 ^= dX;
            this.state05 ^= dX;
            this.state10 ^= dX;
            this.state15 ^= dX;
            this.state20 ^= dX;
            dX = (c2 << 1 | c2 >>> 63) ^ c0;
            this.state01 ^= dX;
            this.state06 ^= dX;
            this.state11 ^= dX;
            this.state16 ^= dX;
            this.state21 ^= dX;
            dX = (c3 << 1 | c3 >>> 63) ^ c1;
            this.state02 ^= dX;
            this.state07 ^= dX;
            this.state12 ^= dX;
            this.state17 ^= dX;
            this.state22 ^= dX;
            dX = (c4 << 1 | c4 >>> 63) ^ c2;
            this.state03 ^= dX;
            this.state08 ^= dX;
            this.state13 ^= dX;
            this.state18 ^= dX;
            this.state23 ^= dX;
            dX = (c0 << 1 | c0 >>> 63) ^ c3;
            this.state04 ^= dX;
            this.state09 ^= dX;
            this.state14 ^= dX;
            this.state19 ^= dX;
            this.state24 ^= dX;
            long s00 = this.state00;
            long s01 = this.state06 << 44 | this.state06 >>> 20;
            long s02 = this.state12 << 43 | this.state12 >>> 21;
            long s03 = this.state18 << 21 | this.state18 >>> 43;
            long s04 = this.state24 << 14 | this.state24 >>> 50;
            long s05 = this.state03 << 28 | this.state03 >>> 36;
            long s06 = this.state09 << 20 | this.state09 >>> 44;
            long s07 = this.state10 << 3 | this.state10 >>> 61;
            long s08 = this.state16 << 45 | this.state16 >>> 19;
            long s09 = this.state22 << 61 | this.state22 >>> 3;
            long s10 = this.state01 << 1 | this.state01 >>> 63;
            long s11 = this.state07 << 6 | this.state07 >>> 58;
            long s12 = this.state13 << 25 | this.state13 >>> 39;
            long s13 = this.state19 << 8 | this.state19 >>> 56;
            long s14 = this.state20 << 18 | this.state20 >>> 46;
            long s15 = this.state04 << 27 | this.state04 >>> 37;
            long s16 = this.state05 << 36 | this.state05 >>> 28;
            long s17 = this.state11 << 10 | this.state11 >>> 54;
            long s18 = this.state17 << 15 | this.state17 >>> 49;
            long s19 = this.state23 << 56 | this.state23 >>> 8;
            long s20 = this.state02 << 62 | this.state02 >>> 2;
            long s21 = this.state08 << 55 | this.state08 >>> 9;
            long s22 = this.state14 << 39 | this.state14 >>> 25;
            long s23 = this.state15 << 41 | this.state15 >>> 23;
            long s24 = this.state21 << 2 | this.state21 >>> 62;
            this.state00 = s00 ^ (s01 ^ 0xFFFFFFFFFFFFFFFFL) & s02 ^ ROUND_CONSTANTS[i];
            this.state01 = s01 ^ (s02 ^ 0xFFFFFFFFFFFFFFFFL) & s03;
            this.state02 = s02 ^ (s03 ^ 0xFFFFFFFFFFFFFFFFL) & s04;
            this.state03 = s03 ^ (s04 ^ 0xFFFFFFFFFFFFFFFFL) & s00;
            this.state04 = s04 ^ (s00 ^ 0xFFFFFFFFFFFFFFFFL) & s01;
            this.state05 = s05 ^ (s06 ^ 0xFFFFFFFFFFFFFFFFL) & s07;
            this.state06 = s06 ^ (s07 ^ 0xFFFFFFFFFFFFFFFFL) & s08;
            this.state07 = s07 ^ (s08 ^ 0xFFFFFFFFFFFFFFFFL) & s09;
            this.state08 = s08 ^ (s09 ^ 0xFFFFFFFFFFFFFFFFL) & s05;
            this.state09 = s09 ^ (s05 ^ 0xFFFFFFFFFFFFFFFFL) & s06;
            this.state10 = s10 ^ (s11 ^ 0xFFFFFFFFFFFFFFFFL) & s12;
            this.state11 = s11 ^ (s12 ^ 0xFFFFFFFFFFFFFFFFL) & s13;
            this.state12 = s12 ^ (s13 ^ 0xFFFFFFFFFFFFFFFFL) & s14;
            this.state13 = s13 ^ (s14 ^ 0xFFFFFFFFFFFFFFFFL) & s10;
            this.state14 = s14 ^ (s10 ^ 0xFFFFFFFFFFFFFFFFL) & s11;
            this.state15 = s15 ^ (s16 ^ 0xFFFFFFFFFFFFFFFFL) & s17;
            this.state16 = s16 ^ (s17 ^ 0xFFFFFFFFFFFFFFFFL) & s18;
            this.state17 = s17 ^ (s18 ^ 0xFFFFFFFFFFFFFFFFL) & s19;
            this.state18 = s18 ^ (s19 ^ 0xFFFFFFFFFFFFFFFFL) & s15;
            this.state19 = s19 ^ (s15 ^ 0xFFFFFFFFFFFFFFFFL) & s16;
            this.state20 = s20 ^ (s21 ^ 0xFFFFFFFFFFFFFFFFL) & s22;
            this.state21 = s21 ^ (s22 ^ 0xFFFFFFFFFFFFFFFFL) & s23;
            this.state22 = s22 ^ (s23 ^ 0xFFFFFFFFFFFFFFFFL) & s24;
            this.state23 = s23 ^ (s24 ^ 0xFFFFFFFFFFFFFFFFL) & s20;
            this.state24 = s24 ^ (s20 ^ 0xFFFFFFFFFFFFFFFFL) & s21;
        }
    }

    static {
        long[] rc = new long[24];
        int l = 1;
        for (int i = 0; i < 24; ++i) {
            rc[i] = 0L;
            for (int j = 0; j < 7; ++j) {
                int t = l;
                l = (byte)(t < 0 ? t << 1 ^ 0x71 : t << 1);
                if ((t & 1) == 0) continue;
                int n = i;
                rc[n] = rc[n] ^ 1L << (1 << j) - 1;
            }
        }
        ROUND_CONSTANTS = rc;
    }
}

