/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import org.h2.command.Command;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.jdbc.JdbcException;
import org.h2.jdbc.meta.DatabaseMetaServer;
import org.h2.message.DbException;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.server.TcpServer;
import org.h2.store.LobStorageInterface;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.SmallMap;
import org.h2.util.TimeZoneProvider;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class TcpServerThread
implements Runnable {
    protected final Transfer transfer;
    private final TcpServer server;
    private SessionLocal session;
    private boolean stop;
    private Thread thread;
    private Command commit;
    private final SmallMap cache = new SmallMap(SysProperties.SERVER_CACHED_OBJECTS);
    private final SmallLRUCache<Long, CachedInputStream> lobs = SmallLRUCache.newInstance(Math.max(SysProperties.SERVER_CACHED_OBJECTS, SysProperties.SERVER_RESULT_SET_FETCH_SIZE * 5));
    private final int threadId;
    private int clientVersion;
    private String sessionId;
    private long lastRemoteSettingsId;

    TcpServerThread(Socket socket, TcpServer server, int id) {
        this.server = server;
        this.threadId = id;
        this.transfer = new Transfer(null, socket);
    }

    private void trace(String s) {
        this.server.trace(this + " " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Socket socket;
            block29: {
                this.transfer.init();
                this.trace("Connect");
                socket = this.transfer.getSocket();
                if (socket != null) break block29;
                return;
            }
            try {
                String baseDir;
                if (!this.server.allow(this.transfer.getSocket())) {
                    throw DbException.get(90117);
                }
                int minClientVersion = this.transfer.readInt();
                if (minClientVersion < 6) {
                    throw DbException.get(90047, Integer.toString(minClientVersion), "17");
                }
                int maxClientVersion = this.transfer.readInt();
                if (maxClientVersion < 17) {
                    throw DbException.get(90047, Integer.toString(maxClientVersion), "17");
                }
                if (minClientVersion > 20) {
                    throw DbException.get(90047, Integer.toString(minClientVersion), "20");
                }
                this.clientVersion = maxClientVersion >= 20 ? 20 : maxClientVersion;
                this.transfer.setVersion(this.clientVersion);
                String db = this.transfer.readString();
                String originalURL = this.transfer.readString();
                if (db == null && originalURL == null) {
                    String targetSessionId = this.transfer.readString();
                    int command = this.transfer.readInt();
                    this.stop = true;
                    if (command == 13) {
                        int statementId = this.transfer.readInt();
                        this.server.cancelStatement(targetSessionId, statementId);
                    } else if (command == 14) {
                        db = this.server.checkKeyAndGetDatabaseName(targetSessionId);
                        if (!targetSessionId.equals(db)) {
                            this.transfer.writeInt(1);
                        } else {
                            this.transfer.writeInt(0);
                        }
                    }
                }
                if ((baseDir = this.server.getBaseDir()) == null) {
                    baseDir = SysProperties.getBaseDir();
                }
                db = this.server.checkKeyAndGetDatabaseName(db);
                ConnectionInfo ci = new ConnectionInfo(db);
                ci.setOriginalURL(originalURL);
                ci.setUserName(this.transfer.readString());
                ci.setUserPasswordHash(this.transfer.readBytes());
                ci.setFilePasswordHash(this.transfer.readBytes());
                int len = this.transfer.readInt();
                for (int i = 0; i < len; ++i) {
                    ci.setProperty(this.transfer.readString(), this.transfer.readString());
                }
                if (baseDir != null) {
                    ci.setBaseDir(baseDir);
                }
                if (this.server.getIfExists()) {
                    ci.setProperty("FORBID_CREATION", "TRUE");
                }
                this.transfer.writeInt(1);
                this.transfer.writeInt(this.clientVersion);
                this.transfer.flush();
                if (ci.getFilePasswordHash() != null) {
                    ci.setFileEncryptionKey(this.transfer.readBytes());
                }
                ci.setNetworkConnectionInfo(new NetworkConnectionInfo(NetUtils.ipToShortForm(new StringBuilder(this.server.getSSL() ? "ssl://" : "tcp://"), socket.getLocalAddress().getAddress(), true).append(':').append(socket.getLocalPort()).toString(), socket.getInetAddress().getAddress(), socket.getPort(), "" + 'P' + this.clientVersion));
                if (this.clientVersion < 20) {
                    ci.setProperty("OLD_INFORMATION_SCHEMA", "TRUE");
                    ci.setProperty("NON_KEYWORDS", "VALUE");
                }
                this.session = Engine.createSession(ci);
                this.transfer.setSession(this.session);
                this.server.addConnection(this.threadId, originalURL, ci.getUserName());
                this.trace("Connected");
                this.lastRemoteSettingsId = this.session.getDatabase().getRemoteSettingsId();
            }
            catch (OutOfMemoryError e) {
                this.server.traceError(e);
                this.sendError(e, true);
                this.stop = true;
            }
            catch (Throwable e) {
                this.sendError(e, true);
                this.stop = true;
            }
            while (!this.stop) {
                try {
                    this.process();
                }
                catch (Throwable e) {
                    this.sendError(e, true);
                }
            }
            this.trace("Disconnect");
        }
        catch (Throwable e) {
            this.server.traceError(e);
        }
        finally {
            this.close();
        }
    }

    private void closeSession() {
        if (this.session != null) {
            RuntimeException closeError = null;
            try {
                this.session.close();
                this.server.removeConnection(this.threadId);
            }
            catch (RuntimeException e) {
                closeError = e;
                this.server.traceError(e);
            }
            catch (Exception e) {
                this.server.traceError(e);
            }
            finally {
                this.session = null;
            }
            if (closeError != null) {
                throw closeError;
            }
        }
    }

    void close() {
        try {
            this.stop = true;
            this.closeSession();
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        finally {
            this.transfer.close();
            this.trace("Close");
            this.server.remove(this);
        }
    }

    private void sendError(Throwable t, boolean withStatus) {
        try {
            String sql;
            String message;
            SQLException e = DbException.convert(t).getSQLException();
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            if (e instanceof JdbcException) {
                JdbcException j = (JdbcException)((Object)e);
                message = j.getOriginalMessage();
                sql = j.getSQL();
            } else {
                message = e.getMessage();
                sql = null;
            }
            if (withStatus) {
                this.transfer.writeInt(0);
            }
            this.transfer.writeString(e.getSQLState()).writeString(message).writeString(sql).writeInt(e.getErrorCode()).writeString(trace).flush();
        }
        catch (Exception e2) {
            if (!this.transfer.isClosed()) {
                this.server.traceError(e2);
            }
            this.stop = true;
        }
    }

    private void setParameters(Command command) throws IOException {
        int len = this.transfer.readInt();
        ArrayList<? extends ParameterInterface> params = command.getParameters();
        for (int i = 0; i < len; ++i) {
            Parameter p = (Parameter)params.get(i);
            p.setValue(this.transfer.readValue(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException {
        int operation = this.transfer.readInt();
        switch (operation) {
            case 0: 
            case 18: {
                int id = this.transfer.readInt();
                String sql = this.transfer.readString();
                int old = this.session.getModificationId();
                Command command = this.session.prepareLocal(sql);
                boolean readonly = command.isReadOnly();
                this.cache.addObject(id, command);
                boolean isQuery = command.isQuery();
                this.transfer.writeInt(this.getState(old)).writeBoolean(isQuery).writeBoolean(readonly);
                if (operation != 0) {
                    this.transfer.writeInt(command.getCommandType());
                }
                ArrayList<? extends ParameterInterface> params = command.getParameters();
                this.transfer.writeInt(params.size());
                if (operation != 0) {
                    for (ParameterInterface parameterInterface : params) {
                        ParameterRemote.writeMetaData(this.transfer, parameterInterface);
                    }
                }
                this.transfer.flush();
                break;
            }
            case 1: {
                this.stop = true;
                this.closeSession();
                this.transfer.writeInt(1).flush();
                this.close();
                break;
            }
            case 8: {
                if (this.commit == null) {
                    this.commit = this.session.prepareLocal("COMMIT");
                }
                int old = this.session.getModificationId();
                this.commit.executeUpdate(null);
                this.transfer.writeInt(this.getState(old)).flush();
                break;
            }
            case 10: {
                int id = this.transfer.readInt();
                int objectId = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                ResultInterface result = command.getMetaData();
                this.cache.addObject(objectId, result);
                int columnCount = result.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(columnCount).writeRowCount(0L);
                for (int i = 0; i < columnCount; ++i) {
                    ResultColumn.writeColumn(this.transfer, result, i);
                }
                this.transfer.flush();
                break;
            }
            case 2: {
                ResultInterface result;
                int id = this.transfer.readInt();
                int objectId = this.transfer.readInt();
                long maxRows = this.transfer.readRowCount();
                int fetchSize = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                this.setParameters(command);
                int old = this.session.getModificationId();
                SessionLocal sessionLocal = this.session;
                synchronized (sessionLocal) {
                    result = command.executeQuery(maxRows, false);
                }
                this.cache.addObject(objectId, result);
                int n = result.getVisibleColumnCount();
                int state = this.getState(old);
                this.transfer.writeInt(state).writeInt(n);
                long rowCount = result.isLazy() ? -1L : result.getRowCount();
                this.transfer.writeRowCount(rowCount);
                for (int i = 0; i < n; ++i) {
                    ResultColumn.writeColumn(this.transfer, result, i);
                }
                this.sendRows(result, rowCount >= 0L ? Math.min(rowCount, (long)fetchSize) : (long)fetchSize);
                this.transfer.flush();
                break;
            }
            case 3: {
                int status;
                ResultWithGeneratedKeys result;
                Object generatedKeysRequest;
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                this.setParameters(command);
                boolean writeGeneratedKeys = true;
                int mode = this.transfer.readInt();
                switch (mode) {
                    case 0: {
                        generatedKeysRequest = false;
                        writeGeneratedKeys = false;
                        break;
                    }
                    case 1: {
                        generatedKeysRequest = true;
                        break;
                    }
                    case 2: {
                        int i;
                        int len = this.transfer.readInt();
                        Object[] keys = new int[len];
                        for (i = 0; i < len; ++i) {
                            keys[i] = this.transfer.readInt();
                        }
                        generatedKeysRequest = keys;
                        break;
                    }
                    case 3: {
                        int i;
                        int len = this.transfer.readInt();
                        Object[] keys = new String[len];
                        for (i = 0; i < len; ++i) {
                            keys[i] = (int)this.transfer.readString();
                        }
                        generatedKeysRequest = keys;
                        break;
                    }
                    default: {
                        throw DbException.get(90067, "Unsupported generated keys' mode " + mode);
                    }
                }
                int old = this.session.getModificationId();
                SessionLocal i = this.session;
                synchronized (i) {
                    result = command.executeUpdate(generatedKeysRequest);
                }
                if (this.session.isClosed()) {
                    status = 2;
                    this.stop = true;
                } else {
                    status = this.getState(old);
                }
                this.transfer.writeInt(status);
                this.transfer.writeRowCount(result.getUpdateCount());
                this.transfer.writeBoolean(this.session.getAutoCommit());
                if (writeGeneratedKeys) {
                    ResultInterface resultInterface = result.getGeneratedKeys();
                    int columnCount = resultInterface.getVisibleColumnCount();
                    this.transfer.writeInt(columnCount);
                    long rowCount = resultInterface.getRowCount();
                    this.transfer.writeRowCount(rowCount);
                    for (int i2 = 0; i2 < columnCount; ++i2) {
                        ResultColumn.writeColumn(this.transfer, resultInterface, i2);
                    }
                    this.sendRows(resultInterface, rowCount);
                    resultInterface.close();
                }
                this.transfer.flush();
                break;
            }
            case 4: {
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, true);
                if (command == null) break;
                command.close();
                this.cache.freeObject(id);
                break;
            }
            case 5: {
                int id = this.transfer.readInt();
                int count = this.transfer.readInt();
                ResultInterface result = (ResultInterface)this.cache.getObject(id, false);
                this.transfer.writeInt(1);
                this.sendRows(result, count);
                this.transfer.flush();
                break;
            }
            case 6: {
                int id = this.transfer.readInt();
                ResultInterface result = (ResultInterface)this.cache.getObject(id, false);
                result.reset();
                break;
            }
            case 7: {
                int id = this.transfer.readInt();
                ResultInterface result = (ResultInterface)this.cache.getObject(id, true);
                if (result == null) break;
                result.close();
                this.cache.freeObject(id);
                break;
            }
            case 9: {
                int oldId = this.transfer.readInt();
                int newId = this.transfer.readInt();
                Object obj = this.cache.getObject(oldId, false);
                this.cache.freeObject(oldId);
                this.cache.addObject(newId, obj);
                break;
            }
            case 12: {
                this.sessionId = this.transfer.readString();
                if (this.clientVersion >= 20) {
                    this.session.setTimeZone(TimeZoneProvider.ofId(this.transfer.readString()));
                }
                this.transfer.writeInt(1).writeBoolean(this.session.getAutoCommit()).flush();
                break;
            }
            case 15: {
                boolean autoCommit = this.transfer.readBoolean();
                this.session.setAutoCommit(autoCommit);
                this.transfer.writeInt(1).flush();
                break;
            }
            case 16: {
                this.transfer.writeInt(1).writeInt(this.session.hasPendingTransaction() ? 1 : 0).flush();
                break;
            }
            case 17: {
                long lobId = this.transfer.readLong();
                byte[] hmac = this.transfer.readBytes();
                long offset = this.transfer.readLong();
                int length2 = this.transfer.readInt();
                this.transfer.verifyLobMac(hmac, lobId);
                CachedInputStream in = (CachedInputStream)this.lobs.get(lobId);
                if (in == null || in.getPos() != offset) {
                    LobStorageInterface lobStorage = this.session.getDataHandler().getLobStorage();
                    InputStream inputStream = lobStorage.getInputStream(lobId, -1L);
                    in = new CachedInputStream(inputStream);
                    this.lobs.put(lobId, in);
                    inputStream.skip(offset);
                }
                length2 = Math.min(65536, length2);
                byte[] buff = new byte[length2];
                length2 = IOUtils.readFully(in, buff, length2);
                this.transfer.writeInt(1);
                this.transfer.writeInt(length2);
                this.transfer.writeBytes(buff, 0, length2);
                this.transfer.flush();
                break;
            }
            case 19: {
                ResultInterface result;
                int code = this.transfer.readInt();
                int length = this.transfer.readInt();
                Value[] args = new Value[length];
                for (int i = 0; i < length; ++i) {
                    args[i] = this.transfer.readValue(null);
                }
                int old = this.session.getModificationId();
                SessionLocal length2 = this.session;
                synchronized (length2) {
                    result = DatabaseMetaServer.process(this.session, code, args);
                }
                int columnCount = result.getVisibleColumnCount();
                int state = this.getState(old);
                this.transfer.writeInt(state).writeInt(columnCount);
                long rowCount = result.getRowCount();
                this.transfer.writeRowCount(rowCount);
                for (int i = 0; i < columnCount; ++i) {
                    ResultColumn.writeColumn(this.transfer, result, i);
                }
                this.sendRows(result, rowCount);
                this.transfer.flush();
                break;
            }
            default: {
                this.trace("Unknown operation: " + operation);
                this.close();
            }
        }
    }

    private int getState(int oldModificationId) {
        if (this.session == null) {
            return 2;
        }
        if (this.session.getModificationId() == oldModificationId) {
            long remoteSettingsId = this.session.getDatabase().getRemoteSettingsId();
            if (this.lastRemoteSettingsId == remoteSettingsId) {
                return 1;
            }
            this.lastRemoteSettingsId = remoteSettingsId;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRows(ResultInterface result, long count) throws IOException {
        int columnCount = result.getVisibleColumnCount();
        boolean lazy = result.isLazy();
        Session oldSession = lazy ? this.session.setThreadLocalSession() : null;
        try {
            while (count-- > 0L) {
                boolean hasNext;
                try {
                    hasNext = result.next();
                }
                catch (Exception e) {
                    this.transfer.writeByte((byte)-1);
                    this.sendError(e, false);
                    break;
                }
                if (hasNext) {
                    this.transfer.writeByte((byte)1);
                    Value[] values = result.currentRow();
                    for (int i = 0; i < columnCount; ++i) {
                        ValueLob v2;
                        Value v = values[i];
                        if (lazy && v instanceof ValueLob && (v2 = ((ValueLob)v).copyToResult()) != v) {
                            v = this.session.addTemporaryLob(v2);
                        }
                        this.transfer.writeValue(v);
                    }
                    continue;
                }
                this.transfer.writeByte((byte)0);
                break;
            }
        }
        finally {
            if (lazy) {
                this.session.resetThreadLocalSession(oldSession);
            }
        }
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void cancelStatement(String targetSessionId, int statementId) {
        if (Objects.equals(targetSessionId, this.sessionId)) {
            Command cmd = (Command)this.cache.getObject(statementId, false);
            cmd.cancel();
        }
    }

    static class CachedInputStream
    extends FilterInputStream {
        private static final ByteArrayInputStream DUMMY = new ByteArrayInputStream(new byte[0]);
        private long pos;

        CachedInputStream(InputStream in) {
            super(in == null ? DUMMY : in);
            if (in == null) {
                this.pos = -1L;
            }
        }

        @Override
        public int read(byte[] buff, int off, int len) throws IOException {
            if ((len = super.read(buff, off, len)) > 0) {
                this.pos += (long)len;
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            int x = this.in.read();
            if (x >= 0) {
                ++this.pos;
            }
            return x;
        }

        @Override
        public long skip(long n) throws IOException {
            if ((n = super.skip(n)) > 0L) {
                this.pos += n;
            }
            return n;
        }

        public long getPos() {
            return this.pos;
        }
    }
}

