/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Pattern;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.server.pg.PgServer;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.util.Utils10;
import org.h2.value.CaseInsensitiveMap;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public final class PgServerThread
implements Runnable {
    private static final boolean INTEGER_DATE_TYPES = false;
    private static final Pattern SHOULD_QUOTE = Pattern.compile(".*[\",\\\\{}].*");
    private final PgServer server;
    private Socket socket;
    private SessionLocal session;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private final int secret;
    private CommandInterface activeRequest;
    private String clientEncoding = SysProperties.PG_DEFAULT_CLIENT_ENCODING;
    private String dateStyle = "ISO, MDY";
    private TimeZoneProvider timeZone = DateTimeUtils.getTimeZone();
    private final HashMap<String, Prepared> prepared = new CaseInsensitiveMap<Prepared>();
    private final HashMap<String, Portal> portals = new CaseInsensitiveMap<Portal>();
    private static final int[] POWERS10 = new int[]{1, 10, 100, 1000, 10000};
    private static final int MAX_GROUP_SCALE = 4;
    private static final int MAX_GROUP_SIZE = POWERS10[4];
    private static final short NUMERIC_POSITIVE = 0;
    private static final short NUMERIC_NEGATIVE = 16384;
    private static final short NUMERIC_NAN = -16384;
    private static final BigInteger NUMERIC_CHUNK_MULTIPLIER = BigInteger.valueOf(10000L);

    private static String pgTimeZone(String value) {
        if (value.startsWith("GMT+")) {
            return PgServerThread.convertTimeZone(value, "GMT-");
        }
        if (value.startsWith("GMT-")) {
            return PgServerThread.convertTimeZone(value, "GMT+");
        }
        if (value.startsWith("UTC+")) {
            return PgServerThread.convertTimeZone(value, "UTC-");
        }
        if (value.startsWith("UTC-")) {
            return PgServerThread.convertTimeZone(value, "UTC+");
        }
        return value;
    }

    private static String convertTimeZone(String value, String prefix) {
        int length = value.length();
        return new StringBuilder(length).append(prefix).append(value, 4, length).toString();
    }

    PgServerThread(Socket socket, PgServer server) {
        this.server = server;
        this.socket = socket;
        this.secret = (int)MathUtils.secureRandomLong();
    }

    @Override
    public void run() {
        try {
            this.server.trace("Connect");
            InputStream ins = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(ins);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (EOFException ins) {
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        finally {
            this.server.trace("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int x;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        while ((x = this.dataIn.read()) > 0) {
            buff.write(x);
        }
        return Utils10.byteArrayOutputStreamToString(buff, this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private short readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] buff) throws IOException {
        this.dataIn.readFully(buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException {
        int x;
        if (this.initDone) {
            x = this.dataInRaw.read();
            if (x < 0) {
                this.stop = true;
                return;
            }
        } else {
            x = 0;
        }
        int len = this.dataInRaw.readInt();
        byte[] data = Utils.newBytes(len -= 4);
        this.dataInRaw.readFully(data, 0, len);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
        switch (x) {
            case 0: {
                String param;
                this.server.trace("Init");
                int version = this.readInt();
                if (version == 80877102) {
                    this.server.trace("CancelRequest");
                    int pid = this.readInt();
                    int key = this.readInt();
                    PgServerThread c = this.server.getThread(pid);
                    if (c != null && key == c.secret) {
                        c.cancelRequest();
                    } else {
                        this.server.trace("Invalid CancelRequest: pid=" + pid + ", key=" + key);
                    }
                    this.close();
                    break;
                }
                if (version == 80877103) {
                    this.server.trace("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.trace("StartupMessage");
                this.server.trace(" version " + version + " (" + (version >> 16) + "." + (version & 0xFF) + ")");
                while (!(param = this.readString()).isEmpty()) {
                    String value = this.readString();
                    switch (param) {
                        case "user": {
                            this.userName = value;
                            break;
                        }
                        case "database": {
                            this.databaseName = this.server.checkKeyAndGetDatabaseName(value);
                            break;
                        }
                        case "client_encoding": {
                            int length = value.length();
                            if (length >= 2 && value.charAt(0) == '\'' && value.charAt(length - 1) == '\'') {
                                value = value.substring(1, length - 1);
                            }
                            this.clientEncoding = value;
                            break;
                        }
                        case "DateStyle": {
                            if (value.indexOf(44) < 0) {
                                value = value + ", MDY";
                            }
                            this.dateStyle = value;
                            break;
                        }
                        case "TimeZone": {
                            try {
                                this.timeZone = TimeZoneProvider.ofId(PgServerThread.pgTimeZone(value));
                                break;
                            }
                            catch (Exception e) {
                                this.server.trace("Unknown TimeZone: " + value);
                            }
                        }
                    }
                    this.server.trace(" param " + param + "=" + value);
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.trace("PasswordMessage");
                String password = this.readString();
                try {
                    Properties info = new Properties();
                    info.put("MODE", "PostgreSQL");
                    info.put("DATABASE_TO_LOWER", "TRUE");
                    info.put("DEFAULT_NULL_ORDERING", "HIGH");
                    String url = "jdbc:h2:" + this.databaseName;
                    ConnectionInfo ci = new ConnectionInfo(url, info, this.userName, password);
                    String baseDir = this.server.getBaseDir();
                    if (baseDir == null) {
                        baseDir = SysProperties.getBaseDir();
                    }
                    if (baseDir != null) {
                        ci.setBaseDir(baseDir);
                    }
                    if (this.server.getIfExists()) {
                        ci.setProperty("FORBID_CREATION", "TRUE");
                    }
                    ci.setNetworkConnectionInfo(new NetworkConnectionInfo(NetUtils.ipToShortForm(new StringBuilder("pg://"), this.socket.getLocalAddress().getAddress(), true).append(':').append(this.socket.getLocalPort()).toString(), this.socket.getInetAddress().getAddress(), this.socket.getPort(), null));
                    this.session = Engine.createSession(ci);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.trace("Parse");
                Prepared p = new Prepared();
                p.name = this.readString();
                p.sql = this.getSQL(this.readString());
                int paramTypesCount = this.readShort();
                int[] paramTypes = null;
                if (paramTypesCount > 0) {
                    paramTypes = new int[paramTypesCount];
                    for (int i = 0; i < paramTypesCount; ++i) {
                        paramTypes[i] = this.readInt();
                    }
                }
                try {
                    p.prep = this.session.prepareLocal(p.sql);
                    ArrayList<? extends ParameterInterface> parameters = p.prep.getParameters();
                    int count = parameters.size();
                    p.paramType = new int[count];
                    for (int i = 0; i < count; ++i) {
                        int type;
                        if (i < paramTypesCount && paramTypes[i] != 0) {
                            type = paramTypes[i];
                            this.server.checkType(type);
                        } else {
                            type = PgServer.convertType(parameters.get(i).getType());
                        }
                        p.paramType[i] = type;
                    }
                    this.prepared.put(p.name, p);
                    this.sendParseComplete();
                }
                catch (Exception e) {
                    this.sendErrorResponse(e);
                }
                break;
            }
            case 66: {
                int i;
                this.server.trace("Bind");
                Portal portal = new Portal();
                portal.name = this.readString();
                String prepName = this.readString();
                Prepared prep = this.prepared.get(prepName);
                if (prep == null) {
                    this.sendErrorResponse("Prepared not found");
                    break;
                }
                portal.prep = prep;
                this.portals.put(portal.name, portal);
                int formatCodeCount = this.readShort();
                int[] formatCodes = new int[formatCodeCount];
                for (int i2 = 0; i2 < formatCodeCount; ++i2) {
                    formatCodes[i2] = this.readShort();
                }
                int paramCount = this.readShort();
                try {
                    ArrayList<? extends ParameterInterface> parameters = prep.prep.getParameters();
                    for (i = 0; i < paramCount; ++i) {
                        this.setParameter(parameters, prep.paramType[i], i, formatCodes);
                    }
                }
                catch (Exception e) {
                    this.sendErrorResponse(e);
                    break;
                }
                int resultCodeCount = this.readShort();
                portal.resultColumnFormat = new int[resultCodeCount];
                for (i = 0; i < resultCodeCount; ++i) {
                    portal.resultColumnFormat[i] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 67: {
                char type = (char)this.readByte();
                String name = this.readString();
                this.server.trace("Close");
                if (type == 'S') {
                    Prepared p = this.prepared.remove(name);
                    if (p != null) {
                        p.close();
                    }
                } else if (type == 'P') {
                    Portal p = this.portals.remove(name);
                    if (p != null) {
                        p.prep.closeResult();
                    }
                } else {
                    this.server.trace("expected S or P, got " + type);
                    this.sendErrorResponse("expected S or P");
                    break;
                }
                this.sendCloseComplete();
                break;
            }
            case 68: {
                char type = (char)this.readByte();
                String name = this.readString();
                this.server.trace("Describe");
                if (type == 'S') {
                    Prepared p = this.prepared.get(name);
                    if (p == null) {
                        this.sendErrorResponse("Prepared not found: " + name);
                        break;
                    }
                    try {
                        this.sendParameterDescription(p.prep.getParameters(), p.paramType);
                        this.sendRowDescription(p.prep.getMetaData(), null);
                    }
                    catch (Exception e) {
                        this.sendErrorResponse(e);
                    }
                    break;
                }
                if (type == 'P') {
                    Portal p = this.portals.get(name);
                    if (p == null) {
                        this.sendErrorResponse("Portal not found: " + name);
                        break;
                    }
                    CommandInterface prep = p.prep.prep;
                    try {
                        this.sendRowDescription(prep.getMetaData(), p.resultColumnFormat);
                    }
                    catch (Exception e) {
                        this.sendErrorResponse(e);
                    }
                    break;
                }
                this.server.trace("expected S or P, got " + type);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                String name = this.readString();
                this.server.trace("Execute");
                Portal p = this.portals.get(name);
                if (p == null) {
                    this.sendErrorResponse("Portal not found: " + name);
                    break;
                }
                int maxRows = this.readInt();
                Prepared prepared = p.prep;
                CommandInterface prep = prepared.prep;
                this.server.trace(prepared.sql);
                try {
                    this.setActiveRequest(prep);
                    if (prep.isQuery()) {
                        this.executeQuery(prepared, prep, p.resultColumnFormat, maxRows);
                        break;
                    }
                    this.sendCommandComplete(prep, prep.executeUpdate(null).getUpdateCount());
                    break;
                }
                catch (Exception e) {
                    this.sendErrorOrCancelResponse(e);
                    break;
                }
                finally {
                    this.setActiveRequest(null);
                }
            }
            case 83: {
                this.server.trace("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                String s;
                this.server.trace("Query");
                String query = this.readString();
                ScriptReader reader = new ScriptReader(new StringReader(query));
                while ((s = reader.readStatement()) != null) {
                    s = this.getSQL(s);
                    try {
                        Command command = this.session.prepareLocal(s);
                        Throwable throwable = null;
                        try {
                            this.setActiveRequest(command);
                            if (command.isQuery()) {
                                ResultInterface result = command.executeQuery(0L, false);
                                Throwable throwable2 = null;
                                try {
                                    this.sendRowDescription(result, null);
                                    while (result.next()) {
                                        this.sendDataRow(result, null);
                                    }
                                    this.sendCommandComplete(command, 0L);
                                    continue;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (result == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            result.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    result.close();
                                    continue;
                                }
                            }
                            this.sendCommandComplete(command, command.executeUpdate(null).getUpdateCount());
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (command == null) continue;
                            if (throwable != null) {
                                try {
                                    command.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            command.close();
                        }
                    }
                    catch (Exception e) {
                        this.sendErrorOrCancelResponse(e);
                        break;
                    }
                    finally {
                        this.setActiveRequest(null);
                    }
                }
                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.trace("Terminate");
                this.close();
                break;
            }
            default: {
                this.server.trace("Unsupported: " + x + " (" + (char)x + ")");
            }
        }
    }

    private void executeQuery(Prepared prepared, CommandInterface prep, int[] resultColumnFormat, int maxRows) throws Exception {
        ResultInterface result = prepared.result;
        if (result == null) {
            result = prep.executeQuery(0L, false);
        }
        try {
            if (maxRows == 0) {
                while (result.next()) {
                    this.sendDataRow(result, resultColumnFormat);
                }
            } else {
                while (maxRows > 0 && result.next()) {
                    this.sendDataRow(result, resultColumnFormat);
                    --maxRows;
                }
                if (result.hasNext()) {
                    prepared.result = result;
                    this.sendCommandSuspended();
                    return;
                }
            }
            prepared.closeResult();
            this.sendCommandComplete(prep, 0L);
        }
        catch (Exception e) {
            prepared.closeResult();
            throw e;
        }
    }

    private String getSQL(String s) {
        String lower = StringUtils.toLowerEnglish(s);
        if (lower.startsWith("show max_identifier_length")) {
            s = "CALL 63";
        } else if (lower.startsWith("set client_encoding to")) {
            s = "set DATESTYLE ISO";
        }
        if (this.server.getTrace()) {
            this.server.trace(s + ";");
        }
        return s;
    }

    private void sendCommandComplete(CommandInterface command, long updateCount) throws IOException {
        this.startMessage(67);
        switch (command.getCommandType()) {
            case 61: {
                this.writeStringPart("INSERT 0 ");
                this.writeString(Long.toString(updateCount));
                break;
            }
            case 68: {
                this.writeStringPart("UPDATE ");
                this.writeString(Long.toString(updateCount));
                break;
            }
            case 58: {
                this.writeStringPart("DELETE ");
                this.writeString(Long.toString(updateCount));
                break;
            }
            case 57: 
            case 66: {
                this.writeString("SELECT");
                break;
            }
            case 83: {
                this.writeString("BEGIN");
                break;
            }
            default: {
                this.server.trace("check CommandComplete tag for command " + command);
                this.writeStringPart("UPDATE ");
                this.writeString(Long.toString(updateCount));
            }
        }
        this.sendMessage();
    }

    private void sendCommandSuspended() throws IOException {
        this.startMessage(115);
        this.sendMessage();
    }

    private void sendDataRow(ResultInterface result, int[] formatCodes) throws IOException {
        int columns = result.getVisibleColumnCount();
        this.startMessage(68);
        this.writeShort(columns);
        Value[] row = result.currentRow();
        for (int i = 0; i < columns; ++i) {
            int pgType = PgServer.convertType(result.getColumnType(i));
            boolean text = PgServerThread.formatAsText(pgType, formatCodes, i);
            this.writeDataColumn(row[i], pgType, text);
        }
        this.sendMessage();
    }

    private static long toPostgreDays(long dateValue) {
        return DateTimeUtils.absoluteDayFromDateValue(dateValue) - 10957L;
    }

    private void writeDataColumn(Value v, int pgType, boolean text) throws IOException {
        if (v == ValueNull.INSTANCE) {
            this.writeInt(-1);
            return;
        }
        if (text) {
            switch (pgType) {
                case 16: {
                    this.writeInt(1);
                    this.dataOut.writeByte(v.getBoolean() ? 116 : 102);
                    break;
                }
                case 17: {
                    int length;
                    byte[] bytes = v.getBytesNoCopy();
                    int cnt = length = bytes.length;
                    for (int i = 0; i < length; ++i) {
                        byte b = bytes[i];
                        if (b < 32 || b > 126) {
                            cnt += 3;
                            continue;
                        }
                        if (b != 92) continue;
                        ++cnt;
                    }
                    byte[] data = new byte[cnt];
                    int j = 0;
                    for (int i = 0; i < length; ++i) {
                        byte b = bytes[i];
                        if (b < 32 || b > 126) {
                            data[j++] = 92;
                            data[j++] = (byte)((b >>> 6 & 3) + 48);
                            data[j++] = (byte)((b >>> 3 & 7) + 48);
                            data[j++] = (byte)((b & 7) + 48);
                            continue;
                        }
                        if (b == 92) {
                            data[j++] = 92;
                            data[j++] = 92;
                            continue;
                        }
                        data[j++] = b;
                    }
                    this.writeInt(data.length);
                    this.write(data);
                    break;
                }
                case 1005: 
                case 1007: 
                case 1015: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(123);
                    Value[] values = ((ValueArray)v).getList();
                    Charset encoding = this.getEncoding();
                    for (int i = 0; i < values.length; ++i) {
                        String s;
                        if (i > 0) {
                            baos.write(44);
                        }
                        if (SHOULD_QUOTE.matcher(s = values[i].getString()).matches()) {
                            ArrayList<String> ss = new ArrayList<String>();
                            for (String s0 : s.split("\\\\")) {
                                ss.add(s0.replace("\"", "\\\""));
                            }
                            s = "\"" + String.join((CharSequence)"\\\\", ss) + "\"";
                        }
                        baos.write(s.getBytes(encoding));
                    }
                    baos.write(125);
                    this.writeInt(baos.size());
                    this.write(baos);
                    break;
                }
                default: {
                    byte[] data = v.getString().getBytes(this.getEncoding());
                    this.writeInt(data.length);
                    this.write(data);
                    break;
                }
            }
        } else {
            switch (pgType) {
                case 16: {
                    this.writeInt(1);
                    this.dataOut.writeByte(v.getBoolean() ? 1 : 0);
                    break;
                }
                case 21: {
                    this.writeInt(2);
                    this.writeShort(v.getShort());
                    break;
                }
                case 23: {
                    this.writeInt(4);
                    this.writeInt(v.getInt());
                    break;
                }
                case 20: {
                    this.writeInt(8);
                    this.dataOut.writeLong(v.getLong());
                    break;
                }
                case 700: {
                    this.writeInt(4);
                    this.dataOut.writeFloat(v.getFloat());
                    break;
                }
                case 701: {
                    this.writeInt(8);
                    this.dataOut.writeDouble(v.getDouble());
                    break;
                }
                case 1700: {
                    this.writeNumericBinary(v.getBigDecimal());
                    break;
                }
                case 17: {
                    byte[] data = v.getBytesNoCopy();
                    this.writeInt(data.length);
                    this.write(data);
                    break;
                }
                case 1082: {
                    this.writeInt(4);
                    this.writeInt((int)PgServerThread.toPostgreDays(((ValueDate)v).getDateValue()));
                    break;
                }
                case 1083: {
                    this.writeTimeBinary(((ValueTime)v).getNanos(), 8);
                    break;
                }
                case 1266: {
                    ValueTimeTimeZone t = (ValueTimeTimeZone)v;
                    long m = t.getNanos();
                    this.writeTimeBinary(m, 12);
                    this.dataOut.writeInt(-t.getTimeZoneOffsetSeconds());
                    break;
                }
                case 1114: {
                    ValueTimestamp t = (ValueTimestamp)v;
                    long m = PgServerThread.toPostgreDays(t.getDateValue()) * 86400L;
                    long nanos = t.getTimeNanos();
                    this.writeTimestampBinary(m, nanos);
                    break;
                }
                case 1184: {
                    ValueTimestampTimeZone t = (ValueTimestampTimeZone)v;
                    long m = PgServerThread.toPostgreDays(t.getDateValue()) * 86400L;
                    long nanos = t.getTimeNanos() - (long)t.getTimeZoneOffsetSeconds() * 1000000000L;
                    if (nanos < 0L) {
                        --m;
                        nanos += 86400000000000L;
                    }
                    this.writeTimestampBinary(m, nanos);
                    break;
                }
                default: {
                    throw new IllegalStateException("output binary format is undefined");
                }
            }
        }
    }

    private static int divide(BigInteger[] unscaled, int divisor) {
        BigInteger[] bi = unscaled[0].divideAndRemainder(BigInteger.valueOf(divisor));
        unscaled[0] = bi[0];
        return bi[1].intValue();
    }

    private void writeNumericBinary(BigDecimal value) throws IOException {
        int groupCount;
        int weight = 0;
        ArrayList<Integer> groups = new ArrayList<Integer>();
        int scale = value.scale();
        int signum = value.signum();
        if (signum != 0) {
            BigInteger[] unscaled = new BigInteger[]{null};
            if (scale < 0) {
                unscaled[0] = value.setScale(0).unscaledValue();
                scale = 0;
            } else {
                unscaled[0] = value.unscaledValue();
            }
            if (signum < 0) {
                unscaled[0] = unscaled[0].negate();
            }
            weight = -scale / 4 - 1;
            int remainder = 0;
            int scaleChunk = scale % 4;
            if (scaleChunk > 0 && (remainder = PgServerThread.divide(unscaled, POWERS10[scaleChunk]) * POWERS10[4 - scaleChunk]) != 0) {
                --weight;
            }
            if (remainder == 0) {
                while ((remainder = PgServerThread.divide(unscaled, MAX_GROUP_SIZE)) == 0) {
                    ++weight;
                }
            }
            groups.add(remainder);
            while (unscaled[0].signum() != 0) {
                groups.add(PgServerThread.divide(unscaled, MAX_GROUP_SIZE));
            }
        }
        if ((groupCount = groups.size()) + weight > Short.MAX_VALUE || scale > Short.MAX_VALUE) {
            throw DbException.get(22003, value.toString());
        }
        this.writeInt(8 + groupCount * 2);
        this.writeShort(groupCount);
        this.writeShort(groupCount + weight);
        this.writeShort(signum < 0 ? 16384 : 0);
        this.writeShort(scale);
        for (int i = groupCount - 1; i >= 0; --i) {
            this.writeShort((Integer)groups.get(i));
        }
    }

    private void writeTimeBinary(long m, int numBytes) throws IOException {
        this.writeInt(numBytes);
        m = Double.doubleToLongBits((double)m * 1.0E-9);
        this.dataOut.writeLong(m);
    }

    private void writeTimestampBinary(long m, long nanos) throws IOException {
        this.writeInt(8);
        m = Double.doubleToLongBits((double)m + (double)nanos * 1.0E-9);
        this.dataOut.writeLong(m);
    }

    private Charset getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(this.clientEncoding);
    }

    private void setParameter(ArrayList<? extends ParameterInterface> parameters, int pgType, int i, int[] formatCodes) throws IOException {
        Value value;
        boolean text = true;
        if (formatCodes.length == 1) {
            text = formatCodes[0] == 0;
        } else if (i < formatCodes.length) {
            text = formatCodes[i] == 0;
        }
        int paramLen = this.readInt();
        if (paramLen == -1) {
            value = ValueNull.INSTANCE;
        } else if (text) {
            byte[] data = Utils.newBytes(paramLen);
            this.readFully(data);
            String str = new String(data, this.getEncoding());
            switch (pgType) {
                case 1082: {
                    int idx = str.indexOf(32);
                    if (idx <= 0) break;
                    str = str.substring(0, idx);
                    break;
                }
                case 1083: {
                    int idx = str.indexOf(43);
                    if (idx <= 0) {
                        idx = str.indexOf(45);
                    }
                    if (idx <= 0) break;
                    str = str.substring(0, idx);
                    break;
                }
            }
            value = ValueVarchar.get(str, this.session);
        } else {
            switch (pgType) {
                case 21: {
                    PgServerThread.checkParamLength(2, paramLen);
                    value = ValueSmallint.get(this.readShort());
                    break;
                }
                case 23: {
                    PgServerThread.checkParamLength(4, paramLen);
                    value = ValueInteger.get(this.readInt());
                    break;
                }
                case 20: {
                    PgServerThread.checkParamLength(8, paramLen);
                    value = ValueBigint.get(this.dataIn.readLong());
                    break;
                }
                case 700: {
                    PgServerThread.checkParamLength(4, paramLen);
                    value = ValueReal.get(this.dataIn.readFloat());
                    break;
                }
                case 701: {
                    PgServerThread.checkParamLength(8, paramLen);
                    value = ValueDouble.get(this.dataIn.readDouble());
                    break;
                }
                case 17: {
                    byte[] d = Utils.newBytes(paramLen);
                    this.readFully(d);
                    value = ValueVarbinary.getNoCopy(d);
                    break;
                }
                case 1700: {
                    value = this.readNumericBinary(paramLen);
                    break;
                }
                default: {
                    this.server.trace("Binary format for type: " + pgType + " is unsupported");
                    byte[] d = Utils.newBytes(paramLen);
                    this.readFully(d);
                    value = ValueVarchar.get(new String(d, this.getEncoding()), this.session);
                }
            }
        }
        parameters.get(i).setValue(value, true);
    }

    private static void checkParamLength(int expected, int got) {
        if (expected != got) {
            throw DbException.getInvalidValueException("paramLen", got);
        }
    }

    private Value readNumericBinary(int paramLen) throws IOException {
        if (paramLen < 8) {
            throw DbException.getInvalidValueException("numeric binary length", paramLen);
        }
        int len = this.readShort();
        short weight = this.readShort();
        short sign = this.readShort();
        short scale = this.readShort();
        if (len * 2 + 8 != paramLen) {
            throw DbException.getInvalidValueException("numeric binary length", paramLen);
        }
        if (sign == -16384) {
            return ValueDecfloat.NAN;
        }
        if (sign != 0 && sign != 16384) {
            throw DbException.getInvalidValueException("numeric sign", sign);
        }
        if ((scale & 0x3FFF) != scale) {
            throw DbException.getInvalidValueException("numeric scale", scale);
        }
        if (len == 0) {
            return scale == 0 ? ValueNumeric.ZERO : ValueNumeric.get(new BigDecimal(BigInteger.ZERO, scale));
        }
        BigInteger n = BigInteger.ZERO;
        for (int i = 0; i < len; ++i) {
            short c = this.readShort();
            if (c < 0 || c > 9999) {
                throw DbException.getInvalidValueException("numeric chunk", c);
            }
            n = n.multiply(NUMERIC_CHUNK_MULTIPLIER).add(BigInteger.valueOf(c));
        }
        if (sign != 0) {
            n = n.negate();
        }
        return ValueNumeric.get(new BigDecimal(n, (len - weight - 1) * 4).setScale(scale));
    }

    private void sendErrorOrCancelResponse(Exception e) throws IOException {
        if (e instanceof DbException && ((DbException)e).getErrorCode() == 57014) {
            this.sendCancelQueryResponse();
        } else {
            this.sendErrorResponse(e);
        }
    }

    private void sendErrorResponse(Exception re) throws IOException {
        SQLException e = DbException.toSQLException(re);
        this.server.traceError(e);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(e.getSQLState());
        this.write(77);
        this.writeString(e.getMessage());
        this.write(68);
        this.writeString(e.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendCancelQueryResponse() throws IOException {
        this.server.trace("CancelSuccessResponse");
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("57014");
        this.write(77);
        this.writeString("canceling statement due to user request");
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(ArrayList<? extends ParameterInterface> parameters, int[] paramTypes) throws Exception {
        int count = parameters.size();
        this.startMessage(116);
        this.writeShort(count);
        for (int i = 0; i < count; ++i) {
            int type = paramTypes != null && paramTypes[i] != 0 ? paramTypes[i] : 1043;
            this.server.checkType(type);
            this.writeInt(type);
        }
        this.sendMessage();
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultInterface result, int[] formatCodes) throws IOException {
        if (result == null) {
            this.sendNoData();
        } else {
            int i;
            int columns = result.getVisibleColumnCount();
            int[] oids = new int[columns];
            int[] attnums = new int[columns];
            int[] types = new int[columns];
            int[] precision = new int[columns];
            String[] names = new String[columns];
            Database database = this.session.getDatabase();
            for (i = 0; i < columns; ++i) {
                Table table;
                String name = result.getColumnName(i);
                Schema schema = database.findSchema(result.getSchemaName(i));
                if (schema != null && (table = schema.findTableOrView(this.session, result.getTableName(i))) != null) {
                    oids[i] = table.getId();
                    Column column = table.findColumn(name);
                    if (column != null) {
                        attnums[i] = column.getColumnId() + 1;
                    }
                }
                names[i] = name;
                TypeInfo type = result.getColumnType(i);
                int pgType = PgServer.convertType(type);
                precision[i] = type.getDisplaySize();
                if (type.getValueType() != 0) {
                    this.server.checkType(pgType);
                }
                types[i] = pgType;
            }
            this.startMessage(84);
            this.writeShort(columns);
            for (i = 0; i < columns; ++i) {
                this.writeString(StringUtils.toLowerEnglish(names[i]));
                this.writeInt(oids[i]);
                this.writeShort(attnums[i]);
                this.writeInt(types[i]);
                this.writeShort(PgServerThread.getTypeSize(types[i], precision[i]));
                this.writeInt(-1);
                this.writeShort(PgServerThread.formatAsText(types[i], formatCodes, i) ? 0 : 1);
            }
            this.sendMessage();
        }
    }

    private static boolean formatAsText(int pgType, int[] formatCodes, int column) {
        boolean text = true;
        if (formatCodes != null && formatCodes.length > 0) {
            if (formatCodes.length == 1) {
                text = formatCodes[0] == 0;
            } else if (column < formatCodes.length) {
                text = formatCodes[column] == 0;
            }
        }
        return text;
    }

    private static int getTypeSize(int pgType, int precision) {
        switch (pgType) {
            case 16: {
                return 1;
            }
            case 1043: {
                return Math.max(255, precision + 10);
            }
        }
        return precision + 4;
    }

    private void sendErrorResponse(String message) throws IOException {
        this.server.trace("Exception: " + message);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    private void sendCloseComplete() throws IOException {
        this.startMessage(51);
        this.sendMessage();
    }

    private void initDb() {
        this.session.setTimeZone(this.timeZone);
        try (Command command = this.session.prepareLocal("set search_path = public, pg_catalog");){
            command.executeUpdate(null);
        }
        HashSet<Integer> typeSet = this.server.getTypeSet();
        if (typeSet.isEmpty()) {
            try (Command command = this.session.prepareLocal("select oid from pg_catalog.pg_type");
                 ResultInterface result = command.executeQuery(0L, false);){
                while (result.next()) {
                    typeSet.add(result.currentRow()[0].getInt());
                }
            }
        }
    }

    void close() {
        for (Prepared prep : this.prepared.values()) {
            prep.close();
        }
        try {
            this.stop = true;
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.trace("Close");
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        this.session = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.2.23");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", PgServerThread.pgTimeZone(this.timeZone.getId()));
        String value = "off";
        this.sendParameterStatus("integer_datetimes", value);
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        this.startMessage(90);
        this.write((byte)(this.session.getAutoCommit() ? 73 : 84));
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.secret);
        this.sendMessage();
    }

    private void writeString(String s) throws IOException {
        this.writeStringPart(s);
        this.write(0);
    }

    private void writeStringPart(String s) throws IOException {
        this.write(s.getBytes(this.getEncoding()));
    }

    private void writeInt(int i) throws IOException {
        this.dataOut.writeInt(i);
    }

    private void writeShort(int i) throws IOException {
        this.dataOut.writeShort(i);
    }

    private void write(byte[] data) throws IOException {
        this.dataOut.write(data);
    }

    private void write(ByteArrayOutputStream baos) throws IOException {
        baos.writeTo(this.dataOut);
    }

    private void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    private void startMessage(int newMessageType) {
        this.messageType = newMessageType;
        if (this.outBuffer.size() <= 65536) {
            this.outBuffer.reset();
        } else {
            this.outBuffer = new ByteArrayOutputStream();
        }
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        this.dataOut = new DataOutputStream(this.out);
        this.write(this.messageType);
        this.writeInt(this.outBuffer.size() + 4);
        this.write(this.outBuffer);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String param, String value) throws IOException {
        this.startMessage(83);
        this.writeString(param);
        this.writeString(value);
        this.sendMessage();
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void setProcessId(int id) {
        this.processId = id;
    }

    int getProcessId() {
        return this.processId;
    }

    private synchronized void setActiveRequest(CommandInterface statement) {
        this.activeRequest = statement;
    }

    private synchronized void cancelRequest() {
        if (this.activeRequest != null) {
            this.activeRequest.cancel();
            this.activeRequest = null;
        }
    }

    static class Portal {
        String name;
        int[] resultColumnFormat;
        Prepared prep;

        Portal() {
        }
    }

    static class Prepared {
        String name;
        String sql;
        CommandInterface prep;
        ResultInterface result;
        int[] paramType;

        Prepared() {
        }

        void close() {
            try {
                this.closeResult();
                this.prep.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void closeResult() {
            ResultInterface result = this.result;
            if (result != null) {
                this.result = null;
                result.close();
            }
        }
    }
}

