/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.h2.util.Bits;
import org.h2.util.MathUtils;
import org.h2.util.Utils;

public class Data {
    private byte[] data;
    private int pos;

    private Data(byte[] data) {
        this.data = data;
    }

    public void writeInt(int x) {
        Bits.writeInt(this.data, this.pos, x);
        this.pos += 4;
    }

    public int readInt() {
        int x = Bits.readInt(this.data, this.pos);
        this.pos += 4;
        return x;
    }

    private void writeStringWithoutLength(char[] chars, int len) {
        int p = this.pos;
        byte[] buff = this.data;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c < '\u0080') {
                buff[p++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                buff[p++] = (byte)(0xE0 | c >> 12);
                buff[p++] = (byte)(c >> 6 & 0x3F);
                buff[p++] = (byte)(c & 0x3F);
                continue;
            }
            buff[p++] = (byte)(0xC0 | c >> 6);
            buff[p++] = (byte)(c & 0x3F);
        }
        this.pos = p;
    }

    public static Data create(int capacity) {
        return new Data(new byte[capacity]);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void write(byte[] buff, int off, int len) {
        System.arraycopy(buff, off, this.data, this.pos, len);
        this.pos += len;
    }

    public void read(byte[] buff, int off, int len) {
        System.arraycopy(this.data, this.pos, buff, off, len);
        this.pos += len;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public void checkCapacity(int plus) {
        if (this.pos + plus >= this.data.length) {
            this.expand(plus);
        }
    }

    private void expand(int plus) {
        this.data = Utils.copyBytes(this.data, (this.data.length + plus) * 2);
    }

    public void fillAligned() {
        int len;
        this.pos = len = MathUtils.roundUpInt(this.pos + 2, 16);
        if (this.data.length < len) {
            this.checkCapacity(len - this.data.length);
        }
    }

    public static void copyString(Reader source, OutputStream target) throws IOException {
        int l;
        char[] buff = new char[4096];
        Data d = new Data(new byte[12288]);
        while ((l = source.read(buff)) >= 0) {
            d.writeStringWithoutLength(buff, l);
            target.write(d.data, 0, d.pos);
            d.reset();
        }
    }
}

