/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.store.FileLock;
import org.h2.store.FileLockMethod;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class FileLister {
    private FileLister() {
    }

    public static void tryUnlockDatabase(List<String> files, String message) throws SQLException {
        for (String fileName : files) {
            if (fileName.endsWith(".lock.db")) {
                FileLock lock = new FileLock(new TraceSystem(null), fileName, 1000);
                try {
                    lock.lock(FileLockMethod.FILE);
                    lock.unlock();
                    continue;
                }
                catch (DbException e) {
                    throw DbException.getJdbcSQLException(90133, message);
                }
            }
            if (!fileName.endsWith(".mv.db")) continue;
            try {
                FileChannel f = FilePath.get(fileName).open("r");
                Throwable throwable = null;
                try {
                    java.nio.channels.FileLock lock = f.tryLock(0L, Long.MAX_VALUE, true);
                    lock.release();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (f == null) continue;
                    if (throwable != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    f.close();
                }
            }
            catch (Exception e) {
                throw DbException.getJdbcSQLException(90133, e, message);
            }
        }
    }

    public static String getDir(String dir) {
        if (dir == null || dir.equals("")) {
            return ".";
        }
        return FileUtils.toRealPath(dir);
    }

    public static ArrayList<String> getDatabaseFiles(String dir, String db, boolean all) {
        ArrayList<String> files = new ArrayList<String>();
        String start = db == null ? null : db + '.';
        for (FilePath path : FilePath.get(dir).newDirectoryStream()) {
            boolean ok = false;
            String f = path.toString();
            if (f.endsWith(".mv.db")) {
                ok = true;
            } else if (all) {
                if (f.endsWith(".lock.db")) {
                    ok = true;
                } else if (f.endsWith(".temp.db")) {
                    ok = true;
                } else if (f.endsWith(".trace.db")) {
                    ok = true;
                }
            }
            if (!ok || db != null && !path.getName().startsWith(start)) continue;
            files.add(f);
        }
        return files;
    }
}

